
; bugs

; RXHOOK - it is possible to get a zero mid program with the jump
; 	- only a problem in M100 RXHOOK
;	- should not be an issue 







; entry process
;                                                                 DeIn
; call63012 ---> REX_INSTALL   --->    Y/N ----> REXMGR  -------------->
;                     |   |              |                      |Exit
;                     |   |        install_hook_restart_rex     |
;                     |   ---<---|       |--->-----|   |---<----|         
; REXMGR.BA --> REX_MGR_ENTRY    |                 |   |      
;                                |                 |   |
; interrupt -----------------> REX_INT_ENTRY-->  configure_REX --->RST0



; see more detailed description in REX overview pdf.
; changed in 4.6

;----------------------------------------------------------------------
; Note regarding hooks table.

; Any time that REX is switching the optrom, there
; is a chance that the hooks table is mismatched to the optrom.
; Since we print during REX startup, we need to temporarily copy the hooks table 
; somewhere, and restore when we exit.
; This does not affect the interrupt driven process - that process does use any 
; ROM routines, and interrupts are disabled.
; We do need this function in REX_INSTALL, since that is how REXMGR gets started.
; We need to rebuild the hooks table with a normal F8 exit occurs.

; When do we need to store the hooks table and have a "clean RAM"?
;	- whenever it is detected that either the REX system needs to be installed
;		or that REXMGR is to be started
;
; When must we restore the hooks table?
;	- when REX is installed, but REXMGR is not started
;	- on an F8 exit from REXMGR
;
; When do we not need to store the hooks table?
;	- during the interrupt service routine, so long as interrupts stay disabled.

; NOTE: user must re-install option rom on new RAM install.

;
; When can we ignore the stored hooks table?
;	- when we are swapping RAM images, since the swap leaves the system clean with 
;		no hooks in place, ready for the optrom to be installed/called
;		display warning message
;
; 	- when we are restoring from an earlier RAM image
;		stored images are cleaned, user must reinstall optrom
;		display warning message
;
;	- when we are switching optroms, since the switch occurs on a clean (current)
;		RAM and we exit by calling the ROM
;
;	- when there is an error attempting to install REX file
;		since this is an exit by restarting the M100 with REXROM in place.

; whenever we exit and ignore the stored hooks table, we need to reset the 
;	- stack pointer to what was stored at start up of REX



;-----------------------------------------------------------------------
; ROM start
;-----------------------------------------------------------------------
	.org	0000h

RST0:	di			; disable interrupts since boot process not complete
	jmp	clear_suflag	; Entry point arrived at from interrupt if rexrom present
	.db	"REX!"		; signiture
RST1:	RET			;Not Used
	.DB	0,0,0,0,0,0,0
RST2:	RET			;Not Used
	.DB	0,0,0,0,0,0,0
RST3:	RET			;Not Used
	.DB	0,0,0,0,0,0,0
RST4:	RET			;Not Used
	.DB	0,0,0
TRAP:	DI
	CALL	INTCALL
RST5:	RET			;Not Used
	.DB	0,0,0
RST55:	DI
	CALL	INTCALL
RST6:	JMP	STDCALL		;RST 6 used as short call to a Standard ROM routine.
	.DB	0
RST65:	DI			;Replaces the 6.5 interrupt and sets up a call to 6.5 in Standard ROM
	CALL	INTCALL
RST7:	RET			;Not Used
	.DB	0,0,0
RST75:	DI			;Replaces the 7.5 interrupt and sets up a call to 7.5 in Standard ROM
	CALL 	INTCALL



	.org	0040h
;---------------------------------------------------------
REX_ID:				; REX unique identification code.
				; 8 bytes copied to upper ram on start up
	.DB	00,00		; don't cares
	.db	00		; must be 00 - unique REX signiture
	.DB	"REX"
	.DB	rel
	.db	dotrel		; software version numbers



	.org	0048h

;---------------------------------------------------------
;The STDCALL routine allows a program running in the
;the Option ROM to call and return to an address in the
;Option ROM.
;Syntax is to use a RST 6 plus the address to be called.
;
; 		RST	6
; rvect-->	DW	04B44H  (cvect)
; pvect-->
;
;---------------------------------------------------------

STDCALL:			; 23 bytes
				; stack = rvect
	xthl
	inx 	h
	inx 	h
	xthl			; fix up first stack entry
				; stack = pvect
				; hl=hl'

	push	h			
	lxi 	h, OPON
	xthl			; stack = pvect, OPON
				; hl=hl'

	push 	h
	push 	d		; stack = pvect, OPON, hl', de'

	ldsi 	06h		; point de to stack location of return vector


	lhlx			; hl=pvect
	dcx 	h
	dcx 	h		; point hl=pvect-2
	xchg			; de=pvect-2
	lhlx			; hl=cvect

	pop 	d		; de=de'
	xthl			; hl=hl', stack= pvect, OPON, cvect

	jmp 	STDON


;---------------------------------------------------------
;Routine for the hardware traps.
;return address on entry is related to which interrupt occured.
; 
;		after interrupt occurs
; ivect		DI
;		call	INTCALL
; rvect -->
; so stack = pvect, rvect
;---------------------------------------------------------

INTCALL:			; final stack must be opon, introutine
				; interrupts are off
				; enter with return location on stack, indicating int routine
				; stack = pvect, rvect
				; 20 bytes
	push	h	
	push	d		; stack = pvect, rvect, hl', de'

	ldsi	04h

	lhlx			; hl= rvect

	dcx	h
	dcx	h
	dcx	h
	dcx	h		; hl = ivect

	push	h		; stack = pvect, rvect, hl', de', ivect

	lxi	h,OPON
	shlx			; stack = pvect, OPON, hl', de', ivect

	pop	h		; hl=ivect
	pop	d		; de=de'

	xthl			; stack = pvect, OPON, ivect
				; hl=hl', de=de'

	jmp	STDON



;---------------------------------------------------------
;STDON: Turns on Standard ROM
;---------------------------------------------------------

#if modeltype = 0		; modify this to delay the EI till the end.
	.ORG	0081H
STDON:
	PUSH	PSW
	PUSH	H		; 26C8, F1 C9  POP PSW, RET
	LXI	H,26C8H		; it returns to this location --> pop psw; ret
	XTHL

OPEXIT:				; return to location pushed on stack
	lda 	0FF45h
	ani	0FEh		; manage FF45 properly
	OUT	0E8H
	RET			; RET can be found at 008EH in stdrom
				; in both M100 and T200

#else
	.ORG	0082H
STDON:
	PUSH	PSW
	PUSH	H
	lxi	h,14E9H		; return here in T200
	XTHL
				; return to location pushed on stack
OPEXIT:
	IN	0D8h
	ani	00001100b
	OUT	0D8H
	RET			; RET can be found at 008EH in stdrom
				; in both M100 and T200
#endif


;---------------------------------------------------------
;REXEX1: exits REX software
;always with a restart
;restore hooks table to original on way out.
;---------------------------------------------------------

;	.org	0094h
EXIT:
REXEX1:
	push	h		; put hl on stack
	lxi	h,0000h		; restart rom
	xthl			; swap stack with hl, restoring hl		

	jmp	 STDON		; return to address on stack


;---------------------------------------------------------------------
clear_suflag:			


#if modeltype=1			; for T200, ensure active RAM detected and set
				; this makes starting REXROM idiot proof.  
				; call 61167,2 always works
	
	in	0D8H
	ani	00000011b		; get rom bits, zero ram bits
	out 	0D8H			; switch to bank1 ram
	mov	c,a			; store rom bits

	lda	0EEF5H			; get current active ram bits
	ani	00001100b		; make sure data in correct form

	ora	c			; or with rom bits
	out	0D8H			; set active RAM

#endif
					;clear the startup flag on CALL63012/call61167,2
	xra	a
	sta	SUFLAG
	jmp	REX_INSTALL

;---------------------------------------------------------------------
Preamble_start:				; marker

;---------------------------------------------------------------------
	.org	0383h			; 9 bytes
					; same in both machines
REX_MGR_ENTRY:
	di
	mvi	a,01h
	sta	SUFLAG			; set SUFLAG, start REXMGR
	jmp	REX_INSTALL

;---------------------------------------------------------------------
#if modeltype = 0 			; M100/T102
	.org	0393h			; "call 911" in M100 (038Fh) - add 6 bytes
#else					; T200
	.org	039Ch			; "call 921,2" in T200 (0399h)	- add 4 bytes
#endif

	jmp	REXEX1			; accidental call to here
					; bail out gracefully
;---------------------------------------------------------------------
#if modeltype = 0			; M100/T102
	.org	0396h	
#else					; T200
	.org	039Fh
#endif


REX_INT_ENTRY:	; must start at 0396h in M100, 039Fh in T200
			
; RXHOOK enters REXROM via this path
; hitting this path should only happen once on power up.

					; enter from interrupt, service the interrupt
					; enter otherwise, go to rex install and rex manager
	di

#if real_hardware=0
	mvi	a,'T'			; make sure optrom is R/W
	sta	0004h			; for virtualT, write a T into 0004 to disable hook
#endif

configure_REX:				; common exit path
					; rexrom is active (we are in REXROM)
	di				; interrupts are disabled
					; NOTE: RST 6 enables interrupts!
	call	I_REX_SW
	call	read_active_block	; find active optrom, place in ACTOPT and ROMSEL				
	jnz	configrex1

	mvi	a,08h
	sta	ACTOPT			; if we can't find ACTOPT, default to 8

configrex1:
	call	fix_input_buffer
	di

	call	install_tmrhk	

; interrupts must be off here, or it breaks, don't know why.
; because it might be here becuase of an interrupt.
; if the interrupt takes too long, we will get another interrupt before it's done
; endless loop

	call	I_RESTORE_AB
	jmp	GEN_1			; restore it, no return, jump to restart main rom


;---------------------------------------------------------------------
;REX_INSTALL
;perform what is needed to (re)install the REX specific software, hooks etc.
;then, carry on to REX MANAGER
;entered via call 63012 when REXROM visible, or via REXMGR.BA
;---------------------------------------------------------------------
REX_INSTALL:
	di
	call	I_REX_SW

	call	check_hooks_table	; return with a = 0 (std) a = 1 (non standard)
	sta	HKFLAG			; store result in hook flag
					; 1 means table is non standard, so we blank it on entry
					;	and it means we need to restore it on F8 exit

	lxi	h,0000h			; capture stack pointer on entry, then carry on
	dad	sp			; put stack pointer in hl
	shld	STACK			; store in STACK
			
	call	get_freemem_in_hl    		

	mov	a,h
	cpi	03h			; compare to 3
	
					; h must be >= 3 (768 bytes)
	jm	REX_not_enough_memory	; if <2

	call	restore_tmrhk

REX_RAM_INSTALL:

	di

; rather than deinstall and install, test checksums and compare to checksum data
; if checksums disagree then reinstall.
; run checksum from start (post line number) of program till 00 00 encountered
; depends on lomem, so subtract 1x lomem and add (8000 or A000)from checksum
; compare to data
; checksum is a single byte simple sum across the range.

	lxi	d,0000h			; zero correction factor
	lxi	h,file2_data		; rexmanager
	call	file_checksum		; calculate checksum of file in memory
					; hl points to file 
					; zero = good, not zero = bad

	jnz	files_reinstall		; if zero set then delete and reinstall

#if modeltype=0
	lxi	d,08000h		; de holds correction factor
	lxi	h,file1_data		; rxhook
	call	file_checksum		; calculate checksum of file in memory
					; hl points to file 
					; zero = good, not zero = bad
#else
	lxi	d,00000h		; de holds correction factor
	lxi	h,file1_data		; rxhook as lowram program
	call	file_checksum_T200	; calculate checksum of file in memory
					; hl points to file 
					; zero = good, not zero = bad
#endif

	jnz	files_reinstall		; if zero set then delete and reinstall


REX_INSTALL_2:				; if we get here, then the file installation was successful
					; if not then make sure files are deleted and hook repaired
					; ok, all the software is installed, choose startup


	lda	HKFLAG
	ora	a			; if hooks table is non standard then store it and reset to default
	jz	REX_INSTALL_1

	call	store_hooks_table	; store the hook table in ram
	rst	6			; only reinitialize hooks table if non standard
	.dw	SETHOK			; initialize hooks table on REX MGR start

REX_INSTALL_1:

	ei
	lda	SUFLAG			; load a with flag

 	cpi	0FFH			; set SUFLAG to FF if you want to avoid REXMGR
	jz	install_hook_restart_rex

	cpi	01h			
	jz	REXMGR			; jump if flag = 01h to REXMGR directly


startup_ask_again:

	lxi	h,startr
	call	RPBUFYN
	
	push	psw
	rst	6
	.dw	LCD
	call	RPBCRLF
	pop	psw
				
	jz	REXMGR		; zero set, jump to REX Manager
				
	jmp	install_hook_restart_rex	; answer was N


startr:	.db	"Start REX Manager"
	.db	00h


;--------------------------------------------------------------------------
hooks_table_error_exit:		
	lxi	h,hooks_problem
	call	RPBUFCR
	jmp	error_exit

;------------------------------------------------------------------------
REX_not_enough_memory:			; warn on not enough space and exit
	lxi	h,no_mem
	call	RPBUFCR
	jmp	error_exit				
;------------------------------------------------------------------------
un_install_all:				; a problem was encountered, delete the files
	lxi	h,file_problem
	call	RPBUFCR
;------------------------------------------------------------------------
error_exit:

	rst	6
	.dw	BEEP

	pop	h			; clear return off of stack
		
	call	deinstall_all		; delete both file entries

	di

	rst	6			; set hooks back to standard
	.dw	SETHOK


	lxi	h,noinst
	call	RPBUF
	call	DELAY

	jmp	REXEX1			; exit with interrupt in default position

no_mem:	.db	"Not enough free memory to start REX.",00
file_problem:
	.db	"REX files could not be installed.",00
hooks_problem:
	.db	"There was a problem restoring hooks.",00

noinst:	.db	"Problem encountered.",13d,10d
	.db	"REX has been uninstalled.",13d,10d
	.db	"Address issue, and re-launch REX.",00h

;--------------------------------------------------------------------------
deinstall_all:
#if modeltype=0
	lxi	h,file1_data		; (re)install RXHOOK  - if problem, exit (make sure interrupts disabled)
	call	file_deinstaller
#else
	lxi	b,0000h
	call	adjust_lowram
#endif
	lxi	h,file2_data		; (re)install RXHOOK  - if problem, exit (make sure interrupts disabled)
	call	file_deinstaller
	ret


;--------------------------------------------------------------------------
install_tmrhk:				; only install in current working bank (T200)
	lxi	d,rex_tmrhk     	; install timer hook, probably already installed    
	lxi	h,TMRHK
					; de = source, hl = target
	di

	ldax	d			; get first byte
	mov	m,a			; store first byte

	inx	d
	inx	h			; advance pointers

#if modeltype=0
					; a = first byte
					; hl = target, de = source		
	push	h			; temp store target

	lhlx				; load original hook value into hl
	
	xchg				; now de holds an offset

	lhld	LOWRAM
	inx	h			; hl = (LOWRAM)+1
	
	dad	d			; hl = LOWRAM+1+offset

	pop	d			; get target
	shlx				; store corrected hook into (d) target

	ret	
#else
					; T200, no correction for lowram
	push	h
	lhlx		; load data into hl
	pop	d
	shlx
	ret
#endif


;---------------------------------------------------------------------------------
restore_tmrhk:
				  	; remove rex hook    
	di

#if modeltype=1  			; T200
					; 2 0010, 6 0110, 10 1010
	mvi	b,10d			
	in	0D8H
	mov	c,a			; store working banks

T200_hook_sweep:

	mov	a,b
	out	0D8H			; pick ram bank leaving optrom selected

#endif	
	lxi	h,TMRHK 		; hl = target
	mvi	m,0C9H			; store first byte
	inx	h
	lxi	d,0000h	
	xchg		
	shlx				; store corrected hook into (d) target


#if modeltype=1			; T200
	mov	a,b		; loop 3 times total
	sui	04d
	mov	b,a
	cpi	0FEh
	jnz	T200_hook_sweep
	
	mov	a,c
	out	0D8H		; correct for original 
#endif
	
	ret	



;---------------------------------------------------------
rex_tmrhk:			; timer hook at F5FFh in M100
#if modeltype=0
	jmp	hook_program_start - file1_start	
				; in M100, hook program starts at 8005h	
#else
	jmp	0A001h	
				; in T200, hook program starts at A000h always
#endif		


;--------------------------------------------------------------------------
quit:
	rst	6
	.dw	CLS
;--------------------------------------------------------------------------

install_hook_restart_rex:
quit_common:				; entry from here if quit

#if real_hardware=0
	mvi	a,'R'			; make sure optrom is R/W
	sta	0004h			; for virtualT, write a R into 0004 to enable hook
#endif


	di				; disable interrupts here, since hooks table 
					; must be restored, but OPTROM is still wrong

	lda	HKFLAG
	ora	a			; if HKFLAG = 01h, then restore hooks
	cnz	restore_hooks_table	; restore hooks table here
					; return with zero flag reset
 	jnz	hooks_table_error_exit	; if there was an error then exit gracefully

quit_continue:
	xra	a
	sta	SUFLAG			; make sure this is reset on exit from REXMGR
	sta	HKFLAG
	
	jmp	configure_REX


;--------------------------------------------------------------------------
de_install_REX:
	; remove the files
	; hook already removed

	rst	6
	.dw	CLS

	call	deinstall_all		; delete both file entries

	lxi	h,deinst
	call	RPBUF

	
remove_rex_loop:
	rst	6
	.dw	KYREAD
	jz	remove_rex_loop

	jmp	REXEX1


deinst:	.db	"All REX software is removed.",13d,10d,10d
	.db	"Power off and remove REX from laptop,",13d,10d
	.db	"or follow re-installation procedure.",13d,10d,10d
	.db	"Press any key to restart laptop.",00h

;--------------------------------------------------------------------------
check_hooks_table:			; compare table to default values
					; return a = 0 if standard
					; return a = 1 in non-standard

					; use TEMP1, TEMP3
	lxi	h,HOOKD1
	shld	TEMP1

	lxi	h,HOOKT1		; hl = start of first part of hook table
	shld	TEMP3

	mvi	d,HOOKL1		; load d with length of hook table response type 1
	mvi	e,02h			; e = 2


check_hook1:
	lhld	TEMP3
	mov	c,m
	inx	h
	mov	b,m			; bc holds current hook table entry

	lhld	TEMP1

	dsub				; compare to data

	jnz	modified_hooks		; we know they are different values now
					; exit with a = 1

check_hook2:
	lhld	TEMP3
	inx	h
	inx	h
	shld	TEMP3			; increment pointer to hook table 

	dcr	d			; decrement counter in de
	jnz 	check_hook1		; loop back if not zero

					; done with loop, set up next loop
	dcr	e			; decrement, test a for 0
	jz 	hooks_std		; if zero, done

	push	h
	lxi	h,HOOKD2		; load bc with data for first part of hook table
	shld	TEMP1
	pop	h

	mvi	d,HOOKL2		; load d with length of hook table response type 2

	jmp	check_hook1		; loop back and test table again

hooks_std:
	xra	a
	ret				; done

modified_hooks:
	mvi	a,01h			; done
	ret

;--------------------------------------------------------------------------
store_hooks_table:			; store current hooks table in unused RAM
					; reset hooks to default

					; callable routine
					; destroys registers
					; start at (FBB6) and write current hooks table
					; then copy base table to hooks table

; format
; hook_table_address1 hook_address1 hook_table_address2 hook_address2  FF FF
; FF FF marks end of hooks table list in ram

					; use TEMP1, TEMP2
	lxi	h,HOOKD1
	shld	TEMP1

	lhld	STREND			; get start of free memory
	shld	TEMP2			; TEMP2 holds target
		
	lxi	h,HOOKT1		; hl = start of first part of hook table
	shld	TEMP3

	mvi	d,HOOKL1		; load d with length of hook table response type 1
	mvi	e,02h			; e = 2


store_hook1:
	lhld	TEMP3
	mov	c,m
	inx	h
	mov	b,m			; bc holds current hook table entry


	lhld	TEMP1


	dsub				; compare to data

	jz	store_hook_no_fix	; if same, no change needed
					; we know they are different values now
					; so write old data to RAM
	push	d			; temp store de

	lhld	TEMP2			
	xchg				; de = storage ram location
	lhld	TEMP3			
	shlx				; store hook table address in ram area

	push	 d			; temp store storage ram locaiton

	xchg				; de = hook table address
	lhlx				; hl holds current hook table entry

	pop	d	
	inx	d
	inx	d			; de = next storage location

	shlx				; store hook table data in ram area

	inx	d
	inx	d

	xchg
	shld	TEMP2			; store updated storage RAM location


	lhld	TEMP3
	xchg				; de = hook table address
	lhld	TEMP1			; hl = standard hook table data
	shlx				; store corrected table entry

	pop	d			; restore de

store_hook_no_fix:
	lhld	TEMP3
	inx	h
	inx	h
	shld	TEMP3			; increment pointer to hook table 

	dcr	d			; decrement counter in de
	jnz 	store_hook1		; loop back if not zero

					; done with loop, set up next loop
	dcr	e			; decrement, test a for 0
	jz 	store_hook_done		; if zero, done

	push	h
	lxi	h,HOOKD2		; load bc with data for first part of hook table
	shld	TEMP1
	pop	h

	mvi	d,HOOKL2		; load d with length of hook table response type 2

	jmp	store_hook1		; loop back and test table again

store_hook_done:
	lhld	TEMP2			; load pointer to RAM
	xchg
	lxi	h,0FFFFh		; end of record marker
	shlx				; store in RAM

	ret				; done




;--------------------------------------------------------------------------
restore_hooks_table:			; restore current hooks table from unused RAM

					; callable routine
					; destroys registers
					; start at STREND and update current hooks table

; format
; hook_table_address1 hook_address1 hook_table_address2 hook_address2  FF FF
; FF FF marks end of hooks table list in ram



	lhld	STREND				
	xchg				; de = start of ram table that stores hook table data

	mvi	a,HOOKL1
	adi	HOOKL2
	mov	b,a			; b holds max count of entries possible


restore_hook_check:
	mov	a,b
	ora	a
	jm	restore_hook_bad_table	; if we go past 0 then bad table data

	lhlx				; load hl from (de)
					; hl = hook table address
	
	inx	h			; test for hl=FFFF
	mov	a,h
	ora	l
	rz				; if hl = FFFF then done
					; retunr with zero flag set = no errors

	dcx	h			; restore address data
	shld	TEMP1			; store address in TEMP1

	push	b			; temp store bc
	lxi	b, HOOKT1		; bc = start of hook table

	lhld	TEMP1
	dsub				; hl = hook table address - start of hook table

	pop	b			; restore bc

	mov	a,h
	ora	a
	jnz	restore_hook_bad_table	; check if h = 0, if no then bad data
	

	mov	a,l			; test for l = even number
	ani	11111110b		; make even
	cmp	l
	jnz	restore_hook_bad_table	; if l was not an even number, then bad data

	mov	a,l			; test for l < b
	rrc
	ani	01111111b
	cmp	b			; 
	jp	restore_hook_bad_table	; check if l >= b, if yes then bad data

					; hl is a good address

	inx	d
	inx	d			; advance pointer to RAM
	
	push	d			; temp store pointer to RAM

	lhlx				; load hl from (de)
					; de = hook address
					; hl = hook table data
	xchg				; de = hook table data
	lhld	TEMP1			; hl = hook table address
	xchg				; hl = hook table data, de = hook table address
	shlx				; store data at address

	pop	d			; de = pointer to RAM
	inx	d
	inx	d			; advance
	dcr	b			; decrement b
	jmp	restore_hook_check


restore_hook_bad_table:
	; if this is the case, then
	; 	declare error condition
	;	clean the RAM back to default - no hooks, no traces of OPTROM
	; 	exit with re-install the active ROM
	; signal failure with RNZ
	mvi	a,01h
	ora	a
	ret			; return with zero flag reset
	



;--------------------------------------------------------------------------
display_warning_rom:			; enter here for ROM warning
	rst	6
	.dw	CLS
	jmp	display_warning
;--------------------------------------------------------------------------
display_warning_ram:			; enter here for ROM warning
	call	clsr8

;--------------------------------------------------------------------------

display_warning:			; show warning message if exit without hooks install
					; ie - reinstall hooks programs


	mvi	b,006d

dispwarn1:
	push	b
	call	print_warn
	call	reverse_video
	call	print_warn
	call	normal_video
	pop	b
	dcr	b
	jnz	dispwarn1
	
	ret
	
print_warn:

#if modeltype = 0			; M100
	lxi	d,0508h
#else					; T200
	lxi	d,050Ch
#endif
	lxi	h,syshok
	call	RPB00

	ret

syshok:	.db	"** System hooks initialized **"
	.db	00


#if modeltype=1
;-------------------------------------------------------------------------
file_checksum_T200:

	push	d			; store correction factor
	mvi	a, hook_program_end-hook_program_start	; length
	lxi	d,0A001h
	lxi	h,hook_program_start

	jmp	file_checksum_lowram

#endif

;-------------------------------------------------------------------------
file_checksum:				; hl points to file in REXROM to test for in RAM
					; de holds correction factor
					
	push	d			; temp store
	push 	h			; temp store
	call	search_name_free	; if free slot found, TEMP2 points to first free file name slot
					; if free slot not found, TEMP2 = 0000
					; if file name found, TEMP1 points to file name entry
					; if file name not found - TEMP1 = 0000
	lhld 	TEMP1
	mov	a,h
	ora	l
	jz	file_checksum_fail	; entry not found, bad

					; entry found

	xchg				; de points to start of directory entry
	inx	d			; advance 1 location
	lhlx				; get start of ram file
	lxi	b,04d
	dad	b			; advance 4 bytes
	xchg				; de points to ram code location (basic line number)
				
	pop	h			; restore pointer to file data
	lxi	b,0011d			; advance 12 bytes
	dad	b			; point to 2nd byte of length of program
					; assume always <256 long
	mov	a,m			; place length in a
	sui	04d			; take off 4 from length
					; length in a
	lxi	b,06d
	dad	b			; advance to start of program in ROM
					; hl points to program in ROM (basic line number)

file_checksum_lowram:

;enter here with a holding length, hl points to ROM code and de points to ram code

	mov	c,a			; length in c

					; now run the checksum, ending when 00 found
	mvi	b,00h			; b holds checksum
					; add (de) subtract (hl)
					; difference = 0000 or LOWRAM(u)+lowram(l)

file_checksum_loop:
	ldax	d			; get ram data
	add	b			; b = oldb + (de) - (hl)
	sub	m			; subtract ROM data
	mov	b,a			; result in b
	
	inx	h			; increment h
	inx	d			; increment d

	dcr	c			; decrement counter
	jnz	file_checksum_loop	; loop back if a zero not found

					; result in b

	pop	h			; load hl with correction factor
	mov	a,h
	ora	l
	mov	a,b			; result in a
	jz	file_checksum_nocorrect	; if 0000 then no correction

	add	l			; add lsb
	add	h			; add msb

	lxi	d,LOWRAM		; now correct checksum for modified lomem data
	lhlx
	sub	h
	sub 	l

file_checksum_nocorrect:

	ora	a			; result should be zero
	ret				; if zero, good
					; if not zero, not good

file_checksum_fail:
	pop	b
	pop	b
	ori	01h			; if here, checksum did not match
	ret				; return with zero flag reset
					; nz = bad



;-------------------------------------------------------------------------
files_reinstall:

	lxi	h,reinst
	call	RPBUFCR

	call	deinstall_all		; is order acceptable?  first hook and then REXMGR?

	lxi	h,file2_data		; (re)install REXMGR.BA - if problem, exit
	call	file_installer
	jnz	un_install_all

#if modeltype=0
	lxi	h,file1_data		; (re)install RXHOOK  - if problem, exit (make sure interrupts disabled)
	call	file_installer
	jnz	un_install_all

;	lxi	b,0000h			; first byte to correct at offset 0000h
;	call	fix_address		; not needed....

	lxi	b,hook_program_2 - file1_start + 01h
	call	fix_address		; fix second byte

#else

	mvi	c,01d
	call	adjust_lowram		; clear open lowram hole

	mvi	c,hook_program_end-hook_program_start
	mvi	b,00
	lxi	h,0A001h
	lxi	d,hook_program_start
	call	MOVEC_D_H			; mov c bytes from d to h


	; no correction needed, we can hard code it since position is fixed
;	lxi	b,0000h			; first byte to correct at offset 0000h
;	call	fix_address		; not needed....

;	lxi	b,hook_program_2 - file1_start + 01h
;	call	fix_address		; fix second byte

#endif



	jmp	REX_INSTALL_2

reinst:	.db	"Installing REX files in RAM...."
	.db	00h

;--------------------------------------------------------------------------


fix_address:		

				; b = offset to address to bytes needing correction
				; for RXHOOK
	lhld	LOWRAM
	inx	h		; add 1 for start of file
	push	h
	push	h		; store  (LOWRAM)+1 twice on stack

	dad	b		; add offset to (LOWRAM)+1
				; hl holds address of data to correct
	xchg			; de holds address of data to correct
	lhlx			; hl = data to be corrected

	push	b
#if modeltype = 0			; M100
	lxi	b,8001h
#else					; T200
	lxi	b,0A001h
#endif

	dsub			; subtract out 8001h or A001h
	pop	b
				; hl holds normalized data
				; bc holds offset to address in program
	pop	d		; de = lowram + 1
	dad	d		; hl now holds corrected data
	xchg			; de holds corrected data
	
	pop	h		; hl = LOWRAM + 1
	dad	b		; hl = address of data to correct
	xchg			; de = address of data  to correct
	shlx			; store new jump to location 

	ret


;--------------------------------------------------------------------
get_freemem_in_hl:
	LHLD 	STREND			; load Unused memory pointer
	mov	b,h
	mov	c,l			; store in bc

	lhld	STACK			; get data from STACK

	dsub				; subtract mem pointer from SP
					; result in hl

	ret
