remove_ROM:		; do all the steps needed to clean out a ROM

	lxi	h,DIRTBL	; search for and remove trigger file
	lxi	b,DIRLEN
	mvi	d,TOTAL_NAMES

remove_advance:
	dad	b
	dcr	d
	mov	a,m
	cpi	048h			; advance to last hidden file entry
	jnz	remove_advance

remove_ROM_trigger_loop:
	dad	b
	mov	a,m
	cpi	240d
	jnz	remove_ROM_next
	mvi	m,00h

remove_ROM_next:
	dcr	d
	jnz	remove_ROM_trigger_loop


	call	remove_romba		; remove any ROM .BA files as defined


remove_ROM_altlcd:
	call	I_ROMNAME		;ROMNAME
					; 	enter with a indicating hooks reset
					; 	copy new ROM 40-47 to upper ram
					;	reset upper RAM areas to default
					; 	hook table already initialized
	call	GEN_1		

;#if install_hook = 1
;	di
;	call	install_tmrhk  		; not sure this is needed
;	ei
;#endif

	xra	a
	sta	MENCNT
	sta	KYBCNT

	ret



find_rom_call:			; test for certain rom names, to configure start parameters
				; called from Menu, return with hl,a parameters


#if modeltype = 0		; M100 code
				; call 63013,1 (should work every time) 
	mvi	a,1h
	lxi	h,63013d
	ret
#else				; T200 code		

; search for "Super"
	call	I_REMOTE_GETBYTE
	
	mvi	b,5d		; count down 5 times
	lxi	d,Super		; point to Super
	lxi	h,004Dh		; point to location in optrom


; REMOTE_GETBYTE
; return a byte in a from the flash at location hl
; from block c (returns to block 00)
; only a is changed, the rest are unchanged

test_roms_loop:
	lda	ACTOPT
	mov	c,a		; load a with active option rom
	call	GEN_1
	mov 	c,a
	ldax	d		; get first letter

	cmp	c
	jnz	test_roms_fail
	inx	h
	inx	d
	dcr	b
	jnz	test_roms_loop

					; Super was found
	lxi	h,61167d
	in 	0D8H
	ani	00001100b
	ori	00000010b		; ram bits + optrom select
	ret
	
	
test_roms_fail:				; Super was not found
	lxi	h,61167d
	mvi	a,02d
	ret


				; assume rom code will turn on interrupts
Super:
	.db	"Super"	
#endif

; call 27801,,0 is the call to start SUPER ROM 6C99H

;6C99H	(DBH)	IN D8H		; alternate rom start code
;6C9BH	(E6H)	ANI FCH		; 11111100  get ram bits
;6C9DH	(F6H)	ORI 01H		; turn on multiplan rom
;6C9FH	(2CH)	INR L		; test L
;6CA0H	(2DH)	DCR L	
;6CA1H	(C2H)	JNZ EEEFH	; 61167 if l <>0
;6CA4H	(EEH)	XRI 03H		; xor 00000011 - leave ram bits alone, reverse rom bits
;6CA6H	(C3H)	JMP EEEFH	; jump here with an option ROM call.

; this is equivalent to call61167,x where x is 2,6,10 depending on bank.

; "Super" is at 004Dh-0051h in T200 and M100

; work around - test for "Super" and if it is there then call 61167, 2,6,10





