; REX ROM
; January 2011 V4 firmware

; T200 startup - has to use lowmem because of conflict with copy function
; call61167, (2,6,10)  or call 27801,,0 to start
; call 27801,,0 is the call to start REXMGR 6C99H in bank 2 and 3


rel:		.equ	04d			; release number 0-9d 
dotrel:		.equ	07d			; dot release number 0-9d
#DEFINE  version    	rel+30h,".",dotrel+30h	; text version number

real_hardware:	.equ	1d			; 0 = virtualT, 1 = real REX/laptop
						; make sure OPTROM is R/W in virtualT!
include_dir:	.equ	0d			; 0 = no, 1 = include directory

modeltype:	.equ	0d			; 0 = M100, 1 = T200


#if modeltype = 0

#include        "M100rom_published_lib.asm"
#include        "M100rom_unpublished_lib.asm"


#else

#include        "T200rom_published_lib.asm"
#include        "T200rom_unpublished_lib.asm"

#endif


;-----------------------------------------------------------
;
; processes that require REX to go offline must be performed in ALTLCD
; 	erasing a sector
;	programming a single byte into another block
;
; processes that require REX to depart state 1111 must be performed in ALTLCD
;	getting status and version
;	reading a byte from another block
;
;-----------------------------------------------------------

; change record
; V1.0 	original release, not general use
; V1.1
;	change active block range to 08-15, range for active block = 4000-43FF
; 	rearrange menu for "active" block and "current" block, include names
; 	added rom directory stuff
; 	added erase block function
; 	added program block function
; 	added select current block function
; 	added name current block function

; V4.1
;	added file inject for REXMGR.BA and RXHOOK
; 	must change installation to include copy of 40-48h to FAA4 after rom swap!!!
; 	use the timer interrupt rather than the power up interrupt
; 	timer interrupt jumps to 1B32
;	immediate call to F5FF
;	R75HOK 	RS75HK	.EQU	F5FF	62975	F38F	62351	EEC2	61122	;	 Rst 7.5 hook normally from timer
; 	F5FF normally RET, instead jump to directory entries.


; V4.2
;	major rewrite for new menu style
;	implement save to TPDD
; 	implement ram to flash and flash to ram
;	implement start up rom installer
;	implement de-installation function for REX removal
; 	implement T200 support
; 	use project function in Crimson Editor to manage file(s)

; V4.3
;	found a few important bugs like how to rom switch correctly
;	visual progress indicator included
; 	rewrite of TPDD routines for robustness, no use of M100 routines
; 	selectable sort, enter hints, block number indications


; V4.4
; 	improved startup - check for directory change, offer to revert
;	minor bugfix

; V4.5
;	first release locked in

; V4.6
;	bugfix and new features release
; 	- include support for ROM2 Cleuseau operation  (done)
;	- fix to 12 block limitation - (done)
; 	- menu support for REX model number display (done)
;	- checksum to TPDD routines (done)
;	- improved bank switching (done)
;	- main rom management (done)
;	- stronger directory structure testing (done)
;	- warning message (done)


; V4.7 T200 support release
;	- various bugs - search file bug fixed
;	- T200 support
;		- special startup for some roms
;		- lowram rxhook installation
;		- proper bank management
;	- speedup in menu for cursor display
;	- .BA rom file sweep out
;	- REX file checksum check against ROM data on REX Mgr startup
;	- reduced functionality on startup to improve speed
;		- bottom 16k of bank 1 is now ignored - no software checking
;		- less verbose startup
;		- directory checking after file changes only
;	- elimination of stand alone main rom managment UI
;	- file copy from saved image supported



; 	
; bugs list
; TPDD save overwrites existing file, replace option?
; better text for command error - file name exists.
; recovery of blocks should detect type of block first
; 	or at least discriminate RAM from OPTROM/OS


; next release gotta haves




; ideas for future improvements
; - restore hooks after first REX interrupt/config?
; - allow swap of actram without exit?
; - allow swap of actopt without exit?
; - allow copy function to specify a new type?
; - pop down fast rom switch menu?



;
;---------------------------------------------------------------------------------
; on any reset or power up, 8 bytes at 40h will be copied to upper ram 
; FAA4 (M100) F4D3 (T200), and the code at F624 (M100) will be intact also.

; we must repair these 8 bytes to what they need to be for any one rom, after activation

; REX will have a special code sequence at 0040h and at 0005h
;---------------------------------------------------------------------------------
; some details
;---------------------------------------------------------------------------------
; code at 63012 (F624)  M100	(6 bytes)
; F3, 3E, 01, D3, E8, C7

; code at 038Fh (911) (5 bytes)
; 3EH,01H,D3H,E8H,C7H ---> 0393h is the key location in M100
;
;	DI
;	MVI 	a,01h
;	out	0E8h
;	RST	0


; code at 61167 (EEEF) T200 (4 bytes)
; F3h, D3h, D8h, C7h

; code at 921 (0399h) T200 (4 bytes)
; F3h, D3h, D8h, C7h ---> 039Ch is the key location in T200

;0399h	f3h 	DI
;039Ah	d3h	OUT D8
;039Ch	c7h	RST0




active_block_table_start:	.equ	04000h	; start of active block directory
active_block_table_end:		.equ	043FFh	; end of active block directory
;active_block_table_end:		.equ	04007h	; end of active block directory

name_directory_start:		.equ	04400h	; start of block name directory
name_directory_end:		.equ	04FFFh	; end of block name directory
;name_directory_end:		.equ	0462Fh	; end of block name directory

;-----------------------------------------------------------------------
;Globals on the Telcom Back Page to temporarily hold HL and
;DE registers during a CALL to Standard ROM, or during an
;Interrupt.
;-----------------------------------------------------------------------

SUFLAG:	.EQU	ALTLCD			; 1 byte, see menu for def'n
ROMSEL:	.EQU	ALTLCD+1d		; 1 byte, bit 6 indicates which rom is selected
JMPVECT:.equ	ALTLCD+2d		; 2 bytes, location to store jump vector
HKFLAG:	.equ	ALTLCD+4d		; 1 byte, indicating state of hooks table

DSTATE:	.equ	ALTLCD+5d		; 1 byte, holds state of display
ODSTATE:.equ	ALTLCD+6d		; 1 byte, old state

CURORG:	.EQU	ALTLCD+7d		; 1 byte, cursor origin
OCURSOR:.equ	ALTLCD+8d		; 1 byte, indicating old cursor value

CURSOR:	.EQU	ALTLCD+9d		; 1 byte, cursor variable
COUNT:	.EQU	ALTLCD+10d		; 1 byte, stores count of image type

FREBLK:	.EQU	ALTLCD+11d		; 1 byte, holds next free block
ACTOPT:	.EQU	ALTLCD+12d      	; 1 byte, stores active optrom image number
ACTRAM:	.EQU	ALTLCD+13d		; 1 byte, stores active RAM image number
CURBLK:	.EQU	ALTLCD+14d      	; 1 byte, storage location for current block

TEMP1:	.EQU	ALTLCD+15d		; 2 bytes
TEMP2:	.EQU	ALTLCD+17d		; 2 bytes
TEMP3:	.EQU	ALTLCD+19d		; 2 bytes
TEMP4:	.EQU	ALTLCD+21d		; 2 bytes
TEMP5:	.EQU	ALTLCD+23d		; 2 bytes

TYPE:	.EQU	ALTLCD+25d		; 1 byte, stores display type
LASTB:	.EQU	ALTLCD+26d		; 1 byte, holds last byte of directory entry
STACK:	.EQU	ALTLCD+27d		; 2 byte startup stack storage
FREE:	.EQU	ALTLCD+29d		; 1 byte, holds # free blocks
MODE:	.equ	ALTLCD+30d		; 1 byte, holds ramfile mode
CURSL:	.equ	ALTLCD+31d		; 1 byte, holds cursor length
STORGS:	.EQU	ALTLCD+32d		; 2 bytes store origins
STCNTS:	.EQU	ALTLCD+34d		; 2 bytes store count values

end_var_space:	.equ 	ALTLCD+36d



;-----------------------------------------------------------------------
; ALTLCD allocations
; 30 bytes for variables
; FD48 = GEN_1, 64+64+8-30 = 106 bytes for REX SW
; this leaves 320-136 = 184 bytes for GEN_1 software/data
;-----------------------------------------------------------------------



;-----------------------------------------------------------------------
; MACROS
;-----------------------------------------------------------------------
#DEFINE  ALTLCD_shift(xx)    	(end_var_space + xx - S_REX_SW)
#DEFINE  GEN_1_shift(xx,yy)    	(GEN_1 + xx - yy)
;#DEFINE  GEN_2_shift(xx,yy)    	(GEN_2 + xx - yy)


;-----------------------------------------------------------------------
; Code
;-----------------------------------------------------------------------

	.org	0000h
	.fill	4000h,0FFh

#include	"system.asm"
#include	"menu.asm"
#include	"rex_routines.asm"
#include	"general_routines.asm"
#include	"directory_routines.asm"
#include	"file_routines.asm"
#include	"help_routines.asm"
#include 	"TPDD_routines.asm"
#include 	"directory_mgmt.asm"
#include	"ramfile_routines.asm"

Program_end:

.ECHO "\nThe program ends at "
.ECHO ($Program_end)
.ECHO ".  "

#if Program_end > 03FFFh
.ECHO "Program is too long!!!"
#else
.ECHO "Program length is ok."
#endif

.ECHO "  The Program can be "
.ECHO (03FFFh - Program_end)
.ECHO " bytes longer.\n\n"

#if include_dir = 1
	#include	"directories.asm"
#endif

	.org	Preamble_start
#include 	"actblk_routines.asm"
#include	"rom_routines.asm"
#include	"ram_routines.asm"
#include	"misc.asm"




Preamble_end:

.ECHO "\n\nThe preamble ends at "
.ECHO ($Preamble_end)
.ECHO ".  "

#if Preamble_end > 0382h
.ECHO "Preamble is too long!!!  "
#else
.ECHO "Preamble length is ok.  "
#endif

.ECHO "The Preamble can be "
.ECHO (0382h - Preamble_end)
.ECHO " bytes longer.\n\n"

	.END
