

;---------------------------------------------------------------------------------
;subroutines always loaded into ALTLCD at fixed locations
;SERPAR
;	data for setting the serial parameters
;OPON
;	switch to OPTROM from STDROM
;	entry: 	none
;	exit:	none
;STD_ON
;	switch on the main rom, must be used in REX routines in upper memory when bank switching
;	entry:	none
; 	exit:	none
;SNDKEY
;	sends the key sequence to REX 
;	entry:  none, in any state
;	exit:	in state 000
;	registers changed: none
;SETBLOCK
;	sends command 2 to REX
;	entry:  a = target block
;	exit:	none
;	registers changed: a
;WAITREADY
;	sends command 3 to REX, reads status and version bytes, and returns only when flash status is ready
;	entry: 	none
;	exit:	b = status byte, c = version byte
;	registers changed: a, hl, bc
;PROGBYTE
;	program a byte into the flash -  program data from b to (de)
;	entry: 	de = PA, data in b
;	exit:	none
;	registers changed: a, hl - preseves bc and de

;TBAR (T200 only)
;	output a byte to memory location in video ram

;---------------------------------------------------------------------------------
;subroutines run from GEN_1 (these routines must use relative jumps and calls)
;SETPRIMARY			
;	set the main rom in use to Primary for REX Manager
;
;CHKSUM
;	calculate checksum in block
;	entry: 	a = block for calculation
;	exit:	de = checksum value
;BLANK
;	test if block blank
;	entry: 	a = block for calculation
;	exit:	zero set blank, zero reset, not blank
;RESTORE_AB
;	set the active block, and exit from REX Manager (note - always JMP GEN_1
;	entry: 	none
;	exit:	none
;STV
;	get status and version byte
;	entry: 	none
;	exit:	b = status byte, c = version byte
;ERB
;	send erase block commands to block a at address hl
;	entry: 	a = block to be erased, address = hl
;	exit:	none
;CPYBLK
;	copy 32k block from source b to target c
;	entry: 	b = source block, c = target block
;	enter with bc = source/target, de = end/start
;	exit:	none
;WRITE128
; 	write 128 bytes from d to h
; 	bc holds target block and counter
;READ128
; 	write 128 bytes from h to d
; 	bc holds source block and counter
;REMOTE_POKEBYTE
;	program a byte into flash at location hl
;	entry: 	a = poke value, hl = location, c = target block, returns to block 00
;	exit:	none
;REMOTE_GETBYTE
;	read a byte from flash at location hl
;	entry: 	hl = location, c = target block, returns to block 00
;	exit:	a = result
;R2F
; 	write RAM data to FLASH (32k)
; 	to FREBLK (returns to block 00)
;F2R
; 	write FLASH data to RAM (32k)
; 	to block in c (returns to block 00)
; 	including stack management
; 	return with zero set if ram size wrong, reset if ok
;ROMST
; 	switch out REXROM
; 	switch in the active optrom
; 	turn on main rom
;	call optrom through normal laptop call
;ROMNAME
; 	switch out REXROM
; 	switch in the active optrom
; 	copy 40-48 to upper ram, return
;BARS	
;	input hl = memory pointer, 0000-7FFF
; 	assumes interrupts are off
;	call immediately before moving into 
;	copy, TPDD routines, F2R, R2F
;	and checksum
;TESTROM
;	test main rom to see if characters equal enu
; 	return with zero set = equality
; 	not zero set, different
;SETROM
; 	set the main rom value, preserving block data
; 	a holds value, 1 or zero
; 	update ROMSEL
;---------------------------------------------------------------------



;---------------------------------------------------------------------
; subroutine library for use at GENERAL USE locations in ALTLCD
; assemble here with jumps/calls adjusted for relative offset
; must use the REL_JMP routines

; must disable interrupts, since any code could show up in optrom area
;---------------------------------------------------------------------
I_REX_SW:	
	call	CPBLOK
	.dw	S_REX_SW
	.dw	REX_SW
	.db	E_REX_SW - S_REX_SW
	ret

;---------------------------------------------------------------------
S_REX_SW:							
S_SERPAR:	
	
#if modeltype=0
	.db	"98N1D"						
	.db	00h
#else
	.db	"98N1DNN"						
	.db	00h
#endif

;---------------------------------------------------------------------
S_OPON:				; general use

#if modeltype = 0
	PUSH	PSW		; Model 100 logic.
	lda 	0FF45h
	ori	001h		; manage FF45 properly
;	sta	0FF45h		; sensitive - cannot take an interrupt here
				; either the rom switch is screwed up, or 
				; PSW gets trashed, or FF45 gets trashed
				; if the interrupt occurs after sta 0FF45 but before
				; out E8, then we might not return to REXROM (and the
				; rest of port E8 gets screwed up)
				; we would return to somewhere in main rom.
	OUT	0E8H
	POP	PSW
	RET
#else
	PUSH	PSW		; T200 logic.
	IN	0D8h
	ani	00001100b
	ori	00000010b	
	OUT	0D8H
	POP	PSW
	RET
#endif
;---------------------------------------------------------------------
S_STD_ON:			; used by REXMGR

#if modeltype = 0	
	PUSH	PSW		; Model 100 logic.
	lda 	0FF45h
	ani	0FEh		; manage FF45 properly
	OUT	0E8H
	POP	PSW
	RET
#else
	PUSH	PSW		; T200 logic.
	IN	0D8h
	ani	00001100b	; must fix this for port status byte (timer)
	OUT	0D8H
	POP	PSW
	RET
#endif


;----------------------------------------------------------------
S_SNDKEY:			; sends the key to REX
				; starts in state 111, exits in state 000
				; registers unaffected
	push	h
	push	psw
	lxi	h,0000h		; zero hl

	mov	a,m
	mov	a,m
	mov	a,m		; three reads from 000 to ensure in state 111
	pop	psw
				; state 111
	mvi	l,184d		; key = B6
	mov	l,m		
	mvi	l,242d		; key = F2
	mov	l,m		
	mvi	l,52d		; key = 34
	mov	l,m		
	mvi	l,176d		; key = B0
	mov	l,m		
	mvi	l,49d		; key = 31
	mov	l,m		
	mvi	l,191d		; key = BF
	mov	l,m		
	pop	h
	ret			; state 000


;------------------------------------------------------------------------
S_SETBLOCK:
				; state 000
				; a holds desired sector + main rom selection
				; hl unchanged, bc unchanged, de unchanged
				; 12+4+13+7+10+10 = 56 cycles

	push	h		; temp store h
	lxi	h,0001h		; set h=00
	mov	l,m		; send command 2
	mov	l,a		
	mov	a,m		; provision active block to be visible
				; back to state 000
	pop	h		; reload h
	ret

;------------------------------------------------------------------------
S_PROGBYTE:			; enter and exit in state 000
				; de = PA, b = PD
				; preserves bc, de
				; trashes a, hl

				; state 000
	lxi	h,0AAAh		; aaa,aa
	mov	a,m
	mov	a,m

	lxi	h,0555h		; 555,55
	mov	a,m
	mov	a,m


	lda	0AAAh		; aaa,a0
	lda 	0AA0h		; 

				; program the byte
	lda	0006h		; send command 6

	mov	h,d
	mov	l,e		; set hl = de
	mov	a,m		; load PAL

	mov	l,b		; hl = PA data
	mov	a,m		; do the write, hl = address, data set


;------------------------------------------------------------------------
				; state 000
				; preserves bc, de
				; modifies hl, a

S_WAITREADY:			; loop until ready is read, stack = nothing
	lxi	h,0003h	
S_WAITREADY1:			; slightly faster
	mov	a,m		; read status
	ral			; carry set if MSB = 1 (ready)
	mov	a,m		; state 000
	jnc	WAITREADY1	; slightly faster
	ret

#if modeltype = 1
;------------------------------------------------------------------------
S_TBAR:					; uses PSW
	push	h			; temp store
	push	b
	push	d

S_TBAR2:
	lxi	h,0000h			; set this location to pointer
					; initial offset is 320*15+33 = 4833
	mvi	b,08h			; 8 bytes to update
	lxi	d,0040d

S_TBAR1:
	mvi	a,010d
	out	0FFh
	mov	a,l
	out	0FEh			; set low address

	mvi	a,11d
	out	0FFh
	mov	a,h
	out	0FEh			; set high address
	
	mvi	a,12d
	out	0FFh			; send data
S_TBAR3:
	mvi	a,00h			; set this to the data required	
	out	0FEh			; set data
	
	dad	d
	mov	a,h
	ani	00011111b		; 8k or less
	mov	h,a
	dcr	b
	jnz	TBAR1
	
	lda	TBAR3+1d
	stc
	ral				; rotate and set a bit

	sta	TBAR3+1d		; increment and store
	ani	11000000b

	pop	d
	pop	b
	pop	h
	rz				; return if zero, ie bit 6 is on

	push	h
	mvi	a,01h			; reset data
	sta	TBAR3+1d		; increment and store

	lhld	TBAR2+1d
	inx	h
	mov	a,h
	ani	00011111b		; 8k or less
	mov	h,a
	shld	TBAR2+1d		; advance 8 bytes and store

	pop	h

	ret

#endif

E_REX_SW:
S_GEN_1:
;98 bytes
;------------------------------------------------------------------------
; set up the adresses for the code snippets area
;------------------------------------------------------------------------
REX_SW:			.EQU	ALTLCD_shift(S_REX_SW)
SERPAR:			.EQU	ALTLCD_shift(S_SERPAR)
OPON:			.EQU	ALTLCD_shift(S_OPON)
STD_ON:			.EQU	ALTLCD_shift(S_STD_ON)
SNDKEY:			.EQU	ALTLCD_shift(S_SNDKEY)	
SETBLOCK:		.EQU	ALTLCD_shift(S_SETBLOCK)
PROGBYTE:		.EQU	ALTLCD_shift(S_PROGBYTE)
WAITREADY:		.EQU	ALTLCD_shift(S_WAITREADY)
WAITREADY1:		.EQU	ALTLCD_shift(S_WAITREADY1)
#if modeltype = 1
TBAR:			.EQU	ALTLCD_shift(S_TBAR)
TBAR1:			.EQU	ALTLCD_shift(S_TBAR1)
TBAR2:			.EQU	ALTLCD_shift(S_TBAR2)
TBAR3:			.EQU	ALTLCD_shift(S_TBAR3)
#endif

GEN_1:			.EQU	ALTLCD_shift(S_GEN_1)

;----------------------------------------------------------------
; SETPRIMARY
; make sure primary rom is selected.
;----------------------------------------------------------------
I_SETPRIMARY:	
	call	CPBLOK  
	.dw	S_SETPRIMARY         
	.dw	GEN_1         
	.db	E_SETPRIMARY- S_SETPRIMARY
	ret	
;----------------------------------------------------------------
S_SETPRIMARY:			
				; assume state 111, REXROM selected.
	di			; since it is possible that REX Manager could start
				; with secondary selected, all this routine does
				; is make sure primary is selected.

	call	SNDKEY
	xra	a		; zero a
	call	SETBLOCK	; state 000

	lda	0000h		; state 111

	ei
	ret

E_SETPRIMARY:

								
;----------------------------------------------------------------
; CHKSUM routine, stored at GEN_1 
; start in block 00
; switch to specified block, passed in a
; compute checksum
; revert to block 0
; return

; de = checksum

;----------------------------------------------------------------
I_CHKSUM:	
	call	CPBLOK  
	.dw	S_CHKSUM         
	.dw	GEN_1         
	.db	E_CHKSUM-S_CHKSUM
	ret	
;----------------------------------------------------------------
S_CHKSUM:			; switch out block 0
				; assume state 111
	di			; a holds target block
				; enter with 
				; a = target block
				; d = stop address, e = start address
				; increments of 256 bytes

	call	SNDKEY
	call	SETBLOCK	; state 000

	lxi	h,0000h		; checksum	
	mov	a,m		; state 111

	dad	sp		; hl = sp
	shld	TEMP5		; temp store stack in TEMP5

	mov	h,e
	mvi	l,00h		; load hl with start address

	sphl			; stack pointer = hl

	mov	a,d		; load a with d =  stop pointer
				; done with de

	mvi	b,00h		; zero out b

				; hl = checksum, de temp 16 byte, b temp 16 byte

CHKSUM_loop1:			; 62 cycles total per loop, 16384 loops
				; 406 323 200, .41 seconds
	pop	d		; 10
	mov	c,d		; 4
	dad	b		; 10
	mov	c,e		; 4
	dad	b		; add to hl 10

	ldsi	00h		; de = sp 10
	cmp	d		; 4

	jnz	GEN_1_shift(CHKSUM_loop1,S_CHKSUM)	; 10

	xchg			; de holds checksum

	lhld	TEMP5
	sphl			; restore stack
	push	d
	call	SNDKEY
	xra	a
	call	SETBLOCK	; state 000
	lda	0000h		; state 111
	pop	d		; load checksum in de
	ei
	ret

E_CHKSUM:


;----------------------------------------------------------------
; BLANK routine, stored at GEN_1 
; start in block 00
; switch to specified block, passed in a
; compute if blank or not
; revert to block 0
; return

;exit:	zero set blank, zero reset, not blank
;----------------------------------------------------------------
I_BLANK:	
	call	CPBLOK  
	.dw	S_BLANK         
	.dw	GEN_1         
	.db	E_BLANK- S_BLANK
	ret	
;----------------------------------------------------------------
S_BLANK:			; switch out block 0
				; assume state 111

	di			; a holds target block
	call	SNDKEY
	call	SETBLOCK	; state 000
	lxi	h,0000h
	mov	a,m		; state 111

	dad	sp		; hl = sp
	shld	TEMP5		; temp store stack in TEMP5

	lxi	h,0000h
	sphl			; stack = 0000

	lxi	b,0001h		; increment for memory reading
	lxi	d,0C000h	; offset to measure stack, 4000h loops
	xra	a		; preload a with 00h

				; test for blank  this loop takes 50 cycles * 16384
				; 400 ns per
				; 327 680 000 ns, .33 seconds at worst
BLANK_loop:
	pop	h		; hl should be FFFF  10
	dad	b		; add 1, test for carry 10
	jnc	GEN_1_shift(BLANK_done,S_BLANK)	; if no carry, then was not FFFF 10
				; hl should be 00
	inx	d		; increment d 6
	cmp	d		; test a=d 4
	jnz	GEN_1_shift(BLANK_loop,S_BLANK) 	; 10

	mvi	a,0FFh		; if here then blank, set a=FF

BLANK_done:			; if here then a =0

	lhld	TEMP5
	sphl			; restore stack

	inr	a		; zero bit set if blank, reset if not blank
	push	psw		; temp store flags

	call	SNDKEY		; state 111
	xra	a
	call	SETBLOCK	; state 000
	lda	0000h		; state 111

	pop	psw		; restore flags

	ei
	ret
E_BLANK:


;----------------------------------------------------------------
;RESTORE_AB
;	set the active block, and exit from REX Manager (note - always JMP GEN_1
;	entry: 	none
;	exit:	none
;----------------------------------------------------------------
I_RESTORE_AB:
	call	CPBLOK  
	.dw	S_RESTORE_AB         
	.dw	GEN_1   
	.db	E_RESTORE_AB- S_RESTORE_AB
	ret
;----------------------------------------------------------------
S_RESTORE_AB:

	; enter with rexrom in optrom
	; enter with rex sw installed
	; first restore active block and selected main rom
	; then initialize ALTLCD again
	; then restart

	di			; state 111

	call	SNDKEY		; state 000
	lda	ACTOPT
	ani	00111111b
	mov	b,a
	lda	ROMSEL
	ani	01000000b
	ora	b
	call	SETBLOCK	; state 000
	lda	0000h		; state 111

	call	STD_ON		; turn on main rom, managing FF45


	rst	0		; RESTART!

E_RESTORE_AB:


;---------------------------------------------------------------------
;ROMST
; 	switch out REXROM
; 	switch in the active optrom
; 	turn on main rom
;	call optrom through normal laptop call
;---------------------------------------------------------------------

I_ROMST:
	call	CPBLOK
	.dw	S_ROMST
	.dw	GEN_1
	.db	E_ROMST - S_ROMST
	ret

;---------------------------------------------------------------------
S_ROMST:			; enter with REX ROM present
				; timer hook should be installed already
				; M100 code - call 63012 or call 63013,1
				; T200 - call 61167,2

	di
	push	h
	push	psw		; preserve psw, h

				; assume in state 111
	call	SNDKEY		; send key  registers unaffected
				; state 000
	lda	ACTOPT
	ani	00111111b
	mov	b,a
	lda	ROMSEL
	ani	01000000b
	ora	b		; create correct config byte
	
	call	SETBLOCK	; set the block  hl unchanged, bc unchanged, de unchanged
				; state 000
	lda	0000h		; state 111

				; actopt is active now
	call	STD_ON		; turn on main rom, managing FF45 properly, no interrupts


	pop	psw
	pop	h		; restore hl and a

	pchl			; a and hl are set up	
				; jump to hl with a


E_ROMST:
;---------------------------------------------------------------------



;---------------------------------------------------------------------
; STV
; get status and version byte
; firmware byte in c, status in b
;---------------------------------------------------------------------

I_STV:	call	CPBLOK
	.dw	S_STV
	.dw	GEN_1
	.db	E_STV - S_STV
	ret

;---------------------------------------------------------------------
S_STV:				; assume in state 111

#if real_hardware = 0 
	lxi	b,0ffffh	; send back a spoofed status	
	ret
#endif

	di
	push	psw

	call	SNDKEY		; state 000
	lxi	h,0003h		; state 000
	mov	b,m		; send command 3
	mov	a,m		; status read
				; state 000 
	lxi	h,0007h		; state 000
	mov	c,m		; send command 7
	mov	a,m		; status read
				; state 000 
	lda	0000h		; no command, state 111

	pop	psw
	ei
	ret
E_STV:
;---------------------------------------------------------------------


;---------------------------------------------------------------------
; ERB
; send erase block commands to location in hl to block in a
;---------------------------------------------------------------------

I_ERB:	call	CPBLOK
	.dw	S_ERB
	.dw	GEN_1
	.db	E_ERB - S_ERB
	ret

;---------------------------------------------------------------------
S_ERB:
	di			; a holds target block
	call	SNDKEY		; state 111
	call	SETBLOCK	; state 000
				; hl is erase address

				; state 000
	push 	h

	lxi	h,0AAAh
	mov	a,m		; load l with AA
	mov	a,m		; load h with 0A, d with AA, and do the write

	lxi	h,0555h
	mov	a,m		; load l with 55
	mov	a,m		; load h with 05, d with 55, and do the write

	lda	00AAh		; load l with AA
	lda 	0A80h		; load h with 0A, d with 80 and do the write

	lxi	h,0AAAh
	mov	a,m		; load l with AA
	mov	a,m		; load h with 0A, d with AA, and do the write

	lxi	h,0555h
	mov	a,m		; load l with 55
	mov	a,m		; load h with 05, d with 55, and do the write

				; send erase sector bytes
	lda	0006h		; send command 6

	pop	h
	mov	a,m		; load h,l with sector address

	mvi	l,030h		; load l with 30h
	mov	a,m		; do the write, hl = SA, d = 30h
				; state 000

				; need a 50 microsecond delay to ensure no command collisions
				; each clock cycle is 400 ns, so I need to burn off 125 clock cycles
	mvi	a,13h		; load a with some small number 
				; 11 cycles per loop
ERB_50:	dcr	a		; 13 cycles
	jnz	GEN_1_shift(ERB_50,S_ERB)
				
	call	WAITREADY

	xra	a		; restore the system block
	call	SETBLOCK	; state 000

	lda	0000h		; state 111
	
	ei
	ret
E_ERB:
;---------------------------------------------------------------------

;---------------------------------------------------------------------
; proposed CPYBLK
; copy block from b to c
; enter in state 111
; enter with bc = source/target, de = end/start
; self modifying code
; 125 bytes
;---------------------------------------------------------------------

I_CPYBLK:
	call	CPBLOK
	.dw	S_CPYBLK
	.dw	GEN_1
	.db	E_CPYBLK - S_CPYBLK
	ret

;---------------------------------------------------------------------

S_CPYBLK:
	di

	mov	h,e			; set h = start
	mvi	l,00h
	shld	TEMP1			; pointer to memory

	mov	a,d
	sta	GEN_1_shift(CPYBLK_1+2d,S_CPYBLK)
					; store d at location to test end of loop
					; done with de

	mov	a,b
	sta	GEN_1_shift(CPYBLK_2+1d,S_CPYBLK)
					; store b at location to set source
	mov	a,c
	sta	GEN_1_shift(CPYBLK_3+1d,S_CPYBLK)
					; store c at location to set target
					; done with bc



	mvi	h,00h			; set hl = 0000h

	dad	sp			; hl = sp
	shld	TEMP5			; temp store stack in TEMP5

	call	SNDKEY			; state = 0000

CPYBLK_loop3:				; stack must be original here
		
CPYBLK_2:
	mvi	a,00h			; variable for source
	call	SETBLOCK		; set source block
	lda	0000h			; state 111

	lxi	h,INPUT_BUFFER+50d+80h	; point hl to ram buffer
	sphl				; set stack pointer

	lhld 	TEMP1			; start at TEMP1
	xchg				; source in de, stack target

CPYBLK_loop1:				; copy from source to RAM, 2 bytes at a time	
	lhlx				; hl = (de)
	push	h			; put on stack
	inx	d
	inx	d	
	mov	a,e
	ani	01111111b
	jnz	GEN_1_shift(CPYBLK_loop1,S_CPYBLK)

	xchg				; hl holds pointer to memory
	shld	TEMP1			; advance TEMP1
	shld	TEMP2			; store in TEMP2 also

	call	SNDKEY			; state = 0000

CPYBLK_3:
	mvi	a,00h			; variable location for target
	call	SETBLOCK		; set target block

	lhld	TEMP1			; start at TEMP2
	xchg				; de = pointer to flash

CPYBLK_loop2:
	pop	b
	dcx	d

	call	PROGBYTE	; program data from b to (de)

	mov	b,c
	dcx	d
	call	PROGBYTE	; program data from b to (de)


	mov	a,e
	ani	01111111b
	jnz	GEN_1_shift(CPYBLK_loop2,S_CPYBLK)

	
	lhld	TEMP2		
	shld	TEMP1		; advance TEMP1

	mov	a,h
	ani	00000011b
	ora	l
	jnz	GEN_1_shift(CPYBLK_1,S_CPYBLK)

#if modeltype = 0
	mvi	a,0FFh
	out	0FFh		; send to LCD
#else
	call	TBAR		; uses PSW
#endif


CPYBLK_1:			; stack is restored here
	mov	a,h
	cpi	080h		; alter this memory location based on d
	jnz	GEN_1_shift(CPYBLK_loop3,S_CPYBLK)


	lhld	TEMP5
	sphl			; restore stack

	xra	a
	call	SETBLOCK	; restore REXROM, state 000

	lda	0000h		; state 111

	ei
	ret

E_CPYBLK:




;---------------------------------------------------------------------
; WRITE128
; write 128 bytes from d to h
; bc holds target block and counter
; enter in state 111
;---------------------------------------------------------------------

I_WRITE128:
	call	CPBLOK
	.dw	S_WRITE128
	.dw	GEN_1
	.db	E_WRITE128 - S_WRITE128
	ret

;---------------------------------------------------------------------

S_WRITE128:		; h = pointer to memory, d = pointer to data source
			; preserve hl
			; c = target block
			; state 111
	di


	call	SNDKEY		; state = 0000
	mov	a,c
	call	SETBLOCK

	mvi	c,080h	
	xchg			; de = target, hl = source
				; preserve de
WRITE128_loop:

	mov	b,m
	push	h
	call	PROGBYTE		; write from b to (de), trashes a,hl
					; preserves bc and de
	pop	h

	INX 	H			; increment HL		
	INX 	D			; increment DE				
	DCR 	c			; decrease c				
	JNZ	GEN_1_shift(WRITE128_loop,S_WRITE128)		; if B>0 then loop back

	xra	a
	call	SETBLOCK	; restore REXROM, state 000

	lda	0000h		; state 111
	
	xchg			; restore hl and de

;	ei		leave this out because of BAR
	ret

E_WRITE128:


;---------------------------------------------------------------------
; READ128
; write 128 bytes from h to d
; bc holds source block and counter
; enter in state 111
;---------------------------------------------------------------------

I_READ128:
	call	CPBLOK
	.dw	S_READ128
	.dw	GEN_1
	.db	E_READ128 - S_READ128
	ret

;---------------------------------------------------------------------

S_READ128:		; h = pointer to memory, d = pointer to data, b = counter
			; c = target block
			; state 111
	di

	mvi	b,080h
	call	SNDKEY		; state = 0000
	mov	a,c
	call	SETBLOCK
	lda	0000h		; state = 1111

READ128_loop:
	mov	a,m			; get data from source
	stax	d			; store data at (de)

	INX 	H			;increment HL		
	INX 	D			;increment DE				
	DCR 	B			;decrease B						
	JNZ	GEN_1_shift(READ128_loop,S_READ128)		;if B>0 then loop back

	call	SNDKEY		; state = 0000
	xra	a
	call	SETBLOCK	; restore REXROM, state 000

	lda	0000h		; state 111

;	ei		leave this out because of BAR
	ret

E_READ128:


;---------------------------------------------------------------------
; REMOTE_POKEBYTE
; program a byte in a into the flash at location hl
; into block c (returns to block 00)
;---------------------------------------------------------------------

I_REMOTE_POKEBYTE:
	call	CPBLOK
	.dw	S_REMOTE_POKEBYTE
	.dw	GEN_1
	.db	E_REMOTE_POKEBYTE - S_REMOTE_POKEBYTE
	ret

;---------------------------------------------------------------------
S_REMOTE_POKEBYTE:


#if real_hardware = 0
	mov	m,a		; just write to ROM as if it was RAM
	ret
#endif

	di
	
	push	psw
	push	h
				; assume in state 111
	call	SNDKEY		; send key ; registers unaffected
				; state 000
	mov	a,c
	call	SETBLOCK	; set the block , hl unchanged, bc unchanged, de unchanged
	
	pop	d		; load de with target
	pop	psw
	mov	b,a		; load b with source data

	call	PROGBYTE	; write from b to (de), trashing a, hl

	xra	a
	call	SETBLOCK	; state 000, set block to 00

	lda	0000h		; state 111
	ei
	ret

E_REMOTE_POKEBYTE:

;---------------------------------------------------------------------
; REMOTE_GETBYTE
; return a byte in a from the flash at location hl
; from block c (returns to block 00)
; only a is changed, the rest are unchanged
;---------------------------------------------------------------------

I_REMOTE_GETBYTE:
	call	CPBLOK
	.dw	S_REMOTE_GETBYTE
	.dw	GEN_1
	.db	E_REMOTE_GETBYTE - S_REMOTE_GETBYTE
	ret

;---------------------------------------------------------------------
S_REMOTE_GETBYTE:

#if real_hardware = 0
	mov	a,m		; just read from ROM
	ret
#endif

	di
				; assume in state 111
	call	SNDKEY		; send key  registers unaffected
				; state 000
 	mov	a,c
	call	SETBLOCK	; set the block  hl unchanged, bc unchanged, de unchanged

	lda	0004h		; state 000
	mov	a,m		; do the read
	push	psw		; temp store a
	mov	a,m		; state 000	

	xra	a
	call	SETBLOCK	; state 000

	lda	0000h		; state 111

	pop	psw		; get result
	ei
	ret

E_REMOTE_GETBYTE:
;---------------------------------------------------------------------



;---------------------------------------------------------------------
;R2F
; 	write RAM data to FLASH (32k)
; 	to block c (returns to block 00)
;---------------------------------------------------------------------

I_R2F:
	call	CPBLOK
	.dw	S_R2F
	.dw	GEN_1
	.db	E_R2F - S_R2F
	ret

;---------------------------------------------------------------------
S_R2F:
	di
				; assume in state 111
	call	SNDKEY		; send key  registers unaffected
				; state 000
	mov	a,c
	call	SETBLOCK	; set the block  hl unchanged, bc unchanged, de unchanged

#if modeltype=0			; M100
	lxi	d,0000h		; pointer to FLASH
	lxi	h,8000h		; pointer to RAM
#else
	lxi	d,02000h	; pointer to FLASH
	lxi	h,0A000h	; pointer to RAM
#endif

R2F_loop:
	mov	b,m		; load c with data
	push	h
	call	PROGBYTE	; write from c to (de), trashes a and hl
	pop	h
	inx	d
	inx	h

	mov	a,h
	ani	00000011b
	ora	l
	jnz	GEN_1_shift(R2F_1,S_R2F)	; skip ahead if not zero

#if modeltype = 0
	mvi	a,0FFh
	out	0FFh		; send to LCD
#else
	call	TBAR		; uses PSW
#endif


R2F_1:
	mov	a,l
	ora	h		; test hl = 0000
	jnz	GEN_1_shift(R2F_loop,S_R2F)	; loop back if hl <> 0000  

	xra	a
	call	SETBLOCK	; state 000

	lda	0000h		; state 111

	ei
	ret

E_R2F:
;---------------------------------------------------------------------


;---------------------------------------------------------------------
;F2R
; 	write FLASH data to RAM (32k)
; 	from block c (returns to block 00)
; 	including stack management
;
;---------------------------------------------------------------------

I_F2R:
	call	CPBLOK
	.dw	S_F2R
	.dw	GEN_1
	.db	E_F2R - S_F2R
	ret

;---------------------------------------------------------------------
S_F2R:


	di
				; assume in state 111
	call	SNDKEY		; send key  registers unaffected
				; state 000
	mov	a,c		; c holds the source ram block 
	call	SETBLOCK	; set the block  hl unchanged, bc unchanged, de unchanged

	lda	0000h		; state 111



; get current depth of stack
; copy current stack data to top of ALTLCD



	ldsi	00h		; de = current stack pointer
	mov	b,d
	mov	c,e		; bc = current stack pointer


	lhld	STACK		; load hl with STACK data from start of REXROM
	push	h
	dsub			; get difference
	mov	b,h		; b should be 0, do I need b?
	mov	c,l		; difference in bc stored

	shld	TEMP5		; store hl in TEMP5 for future use

	pop	h		; hl points to stack value at start of REXROM
	lxi	d,ALTLCDE-1d	; point de to top of ALTLCD-1

	inr	c		; add 1 to bc
	dcx	h		; advance on stack

F2R_loop3:
	dcr	c
	jz	GEN_1_shift(F2R_ready,S_F2R)

	mov	a,m
	stax	d		; copy byte to new stack

	dcx	h
	dcx	d
	jmp	GEN_1_shift(F2R_loop3,S_F2R)


F2R_ready:			; ; done with stack copy, ready to copy


	mvi	l,00h
	mvi	e,00h		; this way, we can handle lowram adjustments.
	lda	LOWRAM+1d
	ani	11100000b
	mov	h,a	
	ani	01100000b	; get LOWRAM adjusted for flash
	mov	d,a		; d points to source
				; h points to target

; pick whichever LCD buffer is first
; T200 order is ALTLCD, STDLCD
; M100 is ALTLCD, STDLCD

	lxi	b,ALTLCD

F2R_loop1:
	ldax	d		; load source data
	mov	m,a		; save target data
	
	inx	d
	inx	h

	mov	a,h
	ani	00000011b
	ora	l
	jnz	GEN_1_shift(F2R_1,S_F2R)

#if modeltype = 0
	mvi	a,0FFh
	out	0FFh		; send to LCD
#else
	call	TBAR		; uses PSW
#endif

F2R_1:
	mov	a,l
	ora	h		; test hl=0000
	jz	GEN_1_shift(F2R_loop1A,S_F2R)	; jump out if hl = 0000

	mov	a,h
	cmp	b
	jnz	GEN_1_shift(F2R_loop1,S_F2R)	; loop back if h <> b

	mov	a,l
	cmp	c
	jnz	GEN_1_shift(F2R_loop1,S_F2R)	; loop back if hl <> bc
			
					; hl = bc, correct h and d

	lxi	h,STDLCDE+1h		; copy everything except the LCD buffers
	lxi	d,STDLCDE+1h-8000h



	jmp	GEN_1_shift(F2R_loop1,S_F2R)	; loop back 


; get current depth of stack
; copy current stack data to new stack location

F2R_loop1A:	


	lhld	TEMP5		; get stack depth value
	mov	b,h		; b should be zero, do I need b?
	mov	c,l		; difference in bc

	lhld	STACK - 08000h	; load hl from lower STACK value

	lxi	d,ALTLCDE-1h	; de = source, hl = target

	inr	c		; add 1
	dcx	h		; advance on stack
	
F2R_loop2:
	dcr	c
	jz	GEN_1_shift(F2R_stack,S_F2R)

	ldax	d
	mov	m,a		; copy byte to new stack

	dcx	h
	dcx	d

	jmp	GEN_1_shift(F2R_loop2,S_F2R)
	

; stack rebuilt
; now provide new stack pointer to processor

F2R_stack:

	inx	h
	sphl			; should be current

; done
F2R_done:
				; state 111
	call	SNDKEY		; state 000
	xra	a
	call	SETBLOCK	; state 000
	lda	0000h		; state 111
		

	ei
	ret

	; rexrom is enabled again
E_F2R:
;---------------------------------------------------------------------





;---------------------------------------------------------------------
;ROMNAME
; 	copy new ROM 40-47 to upper ram
; 	hooks table already reset
;	reset upper RAM areas to default


;---------------------------------------------------------------------

I_ROMNAME:
	call	CPBLOK
	.dw	S_ROMNAME
	.dw	GEN_1
	.db	E_ROMNAME - S_ROMNAME
	ret

;---------------------------------------------------------------------
S_ROMNAME:
				; state 111
	di

; (not needed) first, restore hooks table to default
;				; now, call SETHOK with M100 ROM present
;	call	STD_ON		; turn on main rom, managing FF45, no interrupts enabled
;	pop	psw
;	ora	a
;	cnz	SETHOK		; restore hooks table if a = 1
;	call	OPON



; next, copy 8 bytes from new optrom to RAM

				; state 111
	call	SNDKEY		; send key  registers unaffected
				; state 000
	lda	ACTOPT
	call	SETBLOCK	; set the block  hl unchanged, bc unchanged, de unchanged
				; state 000
	lda	0000h		; state 111


	lxi	h,0040h
	lxi	d,ROM_ID
	mvi	b,08d

remove_name_loop:
	mov	a,m
	stax	d
	inx	h
	inx	d
	dcr	b
	jnz	GEN_1_shift(remove_name_loop,S_ROMNAME)



; now reset upper RAM to default values

	call	STD_ON
					; reset upper ram areas
	lxi	h,RAMLD			; upper ram target
	lxi	d,RAMLDS		; source
	mvi	b,RAMLDL		; number of bytes
					; F605h + 36d = F629h  F62A is the flag.
;copy_data:
;	ldax	d
;	mov	m,a
;	inx	h
;	inx	d
;	dcr	b
;	jnz	GEN_1_shift(copy_data,S_ROMNAME)

	call 	BLKMV			; Move B bytes from (DE) to M with increment

; now turn on REXROM again
	call	OPON
	call	SNDKEY		; send key  registers unaffected
				; state 000
	xra	a
	call	SETBLOCK	; set the block  hl unchanged, bc unchanged, de unchanged
				; state 000
	lda	0000h		; state 111


; REXROM selected, enable interrupts and return
	ei			; turn on interrupts 
	ret

E_ROMNAME:




;------------------------------------------------------------------------
I_BARS:
	call	CPBLOK
	.dw	S_BARS
	.dw	GEN_1
	.db	E_BARS - S_BARS
	ret

;------------------------------------------------------------------------
S_BARS:	

#if modeltype = 0	; m100

 			; input hl = memory pointer, 0000-7FFF
			; assumes interrupts are off
			; call immediately before moving into 
			; copy, TPDD routines, F2R, R2F
			; and checksum

	di		; di included, no ei though.
	push 	psw	
	xra	a
	out	0B9h
	
	in	0BAh
	ani	11111100b
	ori	00000010b
	out	0BAh		; preserve upper 6 bits, select driver 10

	mvi	a,192d		; bank 3, row 0
	out	0FEh
				; set for data sequential load incrementing
	pop	psw
				; leave interrupts disabled so that data can be written
				; also port BA, B9 cannot be changed.
	ret

#else				; T200
				; initialize TBAR function


	push	h
	push	d
	push	psw

	lhld	LRAMRF
	lxi	d,3553d		; 11x320+33 = 3553
	dad	d		; hl now holds effective ram address
	
	mov	a,h
	ani	00011111b	; 8k or less
	mov	h,a

	shld	TBAR2+1d		; set starting point

	mvi	a,01d
	sta	TBAR3+1d	; set initial byte

	pop	psw
	pop	d
	pop	h

	ret
#endif

E_BARS:


;------------------------------------------------------------------------
I_TESTROM:
	call	CPBLOK
	.dw	S_TESTROM
	.dw	GEN_1
	.db	E_TESTROM - S_TESTROM
	ret

;------------------------------------------------------------------------
S_TESTROM:		; test main rom to see if characters equal enu
			; return with zero set = equality
			; not zero set, different
	di		

	call	STD_ON
		
	lxi	d,0004h

	ldax	d
	cpi	'e'
	jnz	GEN_1_shift(testrom_exit,S_TESTROM)

	inx	d	

	ldax	d
	cpi	'n'
	jnz	GEN_1_shift(testrom_exit,S_TESTROM)

	inx	d	

	ldax	d
	cpi	'u'

testrom_exit:
	push	psw
	call	OPON
	pop	psw

	ei
	ret			; returns with not zero, not equal, zero , equal

	


E_TESTROM:

;------------------------------------------------------------------------
I_SETROM:
	call	CPBLOK
	.dw	S_SETROM
	.dw	GEN_1
	.db	E_SETROM - S_SETROM
	ret

;------------------------------------------------------------------------
S_SETROM:			; set the main rom value, preserving block data
				; a holds value, 1 or zero
				; update ROMSEL
	di		

	ani	00000001b	; state 111
	rlc
	rlc			; put data in bit 6

	push	psw

	call	SNDKEY

	lxi	h,0003h		; state 000
	mov	a,m		; send command 3, result in a
	mov	h,m		; status read, trash result

	ani	00111111b	; extract current block data

	mov	h,a
	pop	psw

	ora	h		; set block bits

	lxi	h,0001h		; set h=00
	mov	l,m		; send command 2
	mov	l,a		
	mov	a,m		; provision active block to be visible
				; back to state 000

	lda	0000h		; state 111

	ei
	ret			; returns with not zero, not equal, zero , equal



E_SETROM:


;------------------------------------------------------------------------
I_FASTDO:
	call	CPBLOK
	.dw	S_FASTDO
	.dw	GEN_1
	.db	E_FASTDO - S_FASTDO
	ret

;------------------------------------------------------------------------
S_FASTDO:			; quickly find EOF of a .DO file in flash
				; entry with hl pointing to start of .DO file
				; a holding target block in flash
	di	
	lxi	d,0000h	
				; assume in state 111
	call	SNDKEY		; send key  registers unaffected
				; state 000

	call	SETBLOCK	; set the block  hl unchanged, bc unchanged, de unchanged
	ldax	d		; state 111

	dcx 	h		; bc should be 0000h

fastdo_loop:
	inx	h
	inx	b
	mov	a,m
	cpi	01Ah		; test for a = EOF
	jnz	GEN_1_shift(fastdo_loop,S_FASTDO)


	call	SNDKEY
	xra	a
	call	SETBLOCK
	ldax	d		; state 111
	
	ei
	ret			; returns with not zero, not equal, zero , equal



E_FASTDO:




; hl source, de target, bc length

;------------------------------------------------------------------------
I_FASTCPY:
	call	CPBLOK
	.dw	S_FASTCPY
	.dw	GEN_1
	.db	E_FASTCPY - S_FASTCPY
	ret

;------------------------------------------------------------------------
S_FASTCPY:			; quickly copy a block from flash to ram
				; hl source, de target, bc length
				; a holds source block

	di	
				; assume in state 111
	call	SNDKEY		; send key  registers unaffected
				; state 000
				; a holds source block
	call	SETBLOCK	; set the block  hl unchanged, bc unchanged, de unchanged
	lda	0000h		; state 111


fastcpy_loop:
	mov	a,m
	stax	d

	inx	h
	inx	d
	dcx	b
	mov	a,b
	ora	c
	jnz	GEN_1_shift(fastcpy_loop,S_FASTCPY)

	call	SNDKEY
	xra	a
	call	SETBLOCK
	lda	0000h		; state 111
	
	ei
	ret			; returns with not zero, not equal, zero , equal



E_FASTCPY:

