; what am I doing now?   

; - bug associated with name - on esc when entering name, cursor gets out of sync.

;------------------------------------------------------------------------

; routines for loading in RAM files from a saved image

; scan remote ram image for file names and pointers
;	some kind of check to confirm the image is valid
; build a directory in RAM at GEN_1 --> must rebuild standard table when done
;	watch out that REX software does not wipe out the table
; display the file names on the screen
;	display LOCAL: in 1st column top, display:XXXXXX: in column 3 top
;	show local in 2nd column, show remote in 4th column
; 	spacing is different, - need 9 spaces for filenames - adjust accordingly
;	arrow keys scroll up and down in list
;	arrow keys or tab to move between lists
; features in local
;	help, name, kill, Size exit
; features in remote
;	help, copy, size, exit

; Screen map
;0123456789012345678901234567890123456789
;RAM: VVVVV free    |ZZZZZZ:
;     XXXXXX.XX     |     XXXXXX.XX
;     XXXXXX.XX     |     XXXXXX.XX 
;     XXXXXX.XX     |     XXXXXX.XX 
;     XXXXXX.XX     |     XXXXXX.XX 
;     XXXXXX.XX     |     XXXXXX.XX 
;     XXXXXX.XX     |     XXXXXX.XX 
;Help      Copy           Size      Exit  <-- remote mode 1
;Help           Kill Name Size      Exit  <-- local mode 0
;BBBB BBBB BBBB BBBB BBBB BBBB BBBB BBBB

; table at GEN_1
; each entry is 2 bytes for pointer to record
; max Totalnames, 47 in T200,  27 files M100
; max table size 108 M100, 180 T200 

; Variables
; CURBLK - source
; STCNTS, STORGS
; CURSOR - 00-(COUNT-1)range
; COUNT - quantity of files depending on mode. [0..]
; CURORG - depending on MODE, holds byte 1 or 2 of TEMP5

;Cursor operation
;- need to store the previous mode - use MSB to handle that.
;-	OCURSOR and CURSOR
;- need to identify when the screen scrolls - use DSTATE for that.
;-	STATE


ramcursor_length:	.equ	015d
table_offset:		.equ	035d

ramfile_manager:

	lxi	h,rammenu_loop0
	shld	JMPVECT			; store this location as the restart of menu

	rst	6
	.dw	CLS

	mvi	a,ramcursor_length
	sta	CURSL			; set cursor length


rammenu_loop0:			; use this when the directory changes
				; essentially, when a file operation happens, start over

	call	I_REMOTE_GETBYTE	; mostly use this - install once

	mvi	a,10000000b		; toggle MSbit of MODE
	sta	MODE
	sta	CURSOR			; initial CURSOR is 10000000
	sta	OCURSOR			; same initially

	lxi	h,0101h
	shld	STORGS			; initialize CURORGs

	xra	a	
	dcr	a
	sta	DSTATE			; initial DSTATE = FF ie redraw current column

					; DSTATE toggles between FF and 0
					; FF = redraw current column, single cursor toggle (no blink)
					; 00 = current column ok

	call	ramfile_column
	call	ramfile_line1

	call	scan_files	; set TEMP5, build table of data at GEN_1
				; set TEMP5+1, build table of data at GEN_1
				; detailed check of directory structure
				; set counts in TEMP5
				; if TEMP5=0000 then return to main menu with error

				; use TEMP5 STCNTS to store counts of each file list
				; use TEMP4 STORGS to store cursor origins
				; set mode to side with files, default ram image first

	xra	a
	sta	MODE

	call	load_CURORG	; update CURORG depending on MODE
	call	load_COUNT	; update COUNT depending on MODE

	call	display_file_column	; show alternate side first

	mvi	a,10000000b
	sta	MODE


;rammenu_loop1:
					; this loop for ??


	call	load_CURORG		; update CURORG depending on MODE
	call	load_COUNT		; update COUNT depending on MODE

rammenu_loop1a:
	mvi	a,0FFh
	sta	DSTATE

rammenu_loop2:				; this loop for cursor updates
					; highlight the menu entry that is under the cursor

					; mode = 10000000 REMOTE
					; mode = 00000000 LOCAL
	lda	DSTATE
	ora	a
	jz	rammenu_loop3		; if DSTATE is zero then no column redraw

					; we need to redraw the column and do a single cursor toggle
	call	display_file_column

	lda	CURSOR
	call	toggle_cursor		; initial cursor toggle	

	call	ramfile_display_fnkeys	; show once to start

	xra	a
	sta	DSTATE			; reset DSTATE

rammenu_loop3:

	lda	CURSOR
	ani	10000000b
	mov	l,a
	lda	OCURSOR
	ani	10000000b
	cmp	l
	cnz	ramfile_display_fnkeys		; display new function keys if mode changed.

;	call	blink_ramcursor		; toggle cursors if different
	call	blink_cursor

	lda	CURSOR
	sta	OCURSOR

					; now get keyboard response, take action.

rammenu_loop4:				; use this loop if cursor not updated, or keyboard input invalid


rammenu_get_key:

	rst	6
	.dw	KYREAD		; wait for a character, returned in a
				; carry set - function key pressed
				; zero set - no key found
	jz	rammenu_get_key
	
				; a key has been pressed 
				; arrow keys move cursor around
				; space advances cursor
				; enter "selects", action depends on cursor location
				; function keys take action depending on cursor location

				; check for function keys first

	jc	rammenu_function_key_pressed		; if carry set then A holds fun key number
				; some other key pressed
				; up is 30, down is 31, left is 29, right is 28
				; space is 32, enter is 13
				; tab is 9

				; s or S for sort order

	rst	6
	.dw	UPCAS		; convert to uppercase

	call	ramprocess_cursor_type
	
	jmp	rammenu_loop2


;--------------------------------------------------------------------
ramprocess_cursor_type:	; enter with a holding keyboard input

	push	psw
					; populate registers
	lhld	CURSOR			; load CURSOR and COUNT
	lda	CURORG			; load data
	mov	b,a			; b = CURORG
					; h = COUNT
					; l = CURSOR
	mov	a,l
	ani	01111111b		; turn off MODE bit
	mov	l,a
	pop	psw
	
	cpi	29d
	jz	ramcursor_left_right
	cpi	28d
	jz	ramcursor_left_right

	dcr	h
	inr	h
	rz				; done if count is zero
		

	cpi	31d
	jz	ramcursor_down
	cpi	30d
	jz	ramcursor_up

	
	cpi	20d
	jz	ramcursor_shiftup

	cpi	02d
	jz	ramcursor_shiftdown

	ret  			; cursor unchanged


ramcursor_down:
	inr	l
;	jmp	ramcursor_range_adjust
	inr	l		; same thing, but shorter code
ramcursor_up:		
	dcr	l
	jmp	ramcursor_range_adjust

					; b = CURORG
					; h = COUNT
					; l = CURSOR
ramcursor_shiftup:
	mov	a,b
	sui	12d
	mov	b,a

;	jmp	ramcursor_range_adjust
	; same thing, less code

ramcursor_shiftdown:

	mov	a,b
	adi	06d
	mov	b,a

	jmp	ramcursor_range_adjust

ramcursor_left_right:			; change context


	lda	MODE
	push	psw			; temp store
	ora	l	
	sta	OCURSOR
	
	pop	psw			; restore
	xri	10000000b	
	sta	MODE			; toggle MODE

					; cursor remains in l

	call	load_CURORG		; load new CURORG based on MODE
	mov	b,a

	call	load_COUNT		; load COUNT from STCNTS, returns new COUNT in a
	mov	h,a

	dcr	h
	inr	h			; test for count = 0	
	jnz	ramcursor_range_adjust	; if new count is not zero then here...

; count is zero
		
	mvi	b,01d
	mvi	l,00d			; set CURORG = 1, CURSOR = 0
	jmp	cursor_range_ok		; exit and set the range				



; mode toggled, all registers updated
;--------------------------------------------------------------------
ramcursor_range_adjust:	
					; make sure CURSOR is in range
					; adjust CURORG if needed
					; enter with b, h, l set

					; if CURSOR < 0 -- CURSOR = 0, decrement CURORG

					; if CURSOR > 5 -- CURSOR = 5, increment CURORG

					; if CURSOR > COUNT - CURORG -- decrement CURSOR

					; if CURORG <1 -- CURORG = 1

					; if CURORG > COUNT -- CURORG = COUNT

					; if COUNT < 6 -- CURORG = 1
					; if COUNT > 6 and CURORG > COUNT-6 -- CURORG = COUNT-6

					; [0..] range for COUNT
					; [1..COUNT] range for CURORG
					; [0..] range for CURSOR

					; b = CURORG
					; h = COUNT
					; l = CURSOR


ramcursor_range_adjust1:
	mov	a,b
	cpi	01h
	jm	range_CURORG_low	; if CURORG < 1, CURORG = 1

	mov	a,l
	cpi	00h			; look at CURSOR
	jm	range_CURSOR_low	; if CURSOR <0,  fix	

;	mov	a,b
;	cpi	01h
;	jm	range_CURORG_low	; if CURORG < 1, CURORG = 1

;	mov	a,l
	cpi	06d			; look at CURSOR
	jp	range_CURSOR_high1	; if CURSOR >=6, fix	

;	mov	a,l
	cmp	h			; look at CURSOR
	jp	range_CURSOR_high3	; if CURSOR > COUNT, CURSOR = COUNT - 1	
		

	mov	a,h
	sub	b			; COUNT - CURORG in a
	cmp	l
	jm	range_CURSOR_high2	; if COUNT - CURORG < CURSOR then decrement CURORG


	mov	a,h
	sui	05d
	mov	d,a
	cpi	01d
	jp	CURORG_max_ok
	mvi	d,1d
CURORG_max_ok:			; d holds maximum CURORG

	mov	a,b
	dcr	a
	cmp	d
	jp	range_CURORG_high
		

cursor_range_ok:
					; range is ok

	lda	MODE			; we know bit 7 is zero in l already
	ora	l
	mov	l,a			; restore MODE bit 

					; all registers are updated
					; push down to variables, and variable storage
					; update the variables
	shld	CURSOR			; save CURSOR and COUNT

					; decide if CURORG changed, if so DSTATE = FF

	lda	CURORG
	cmp	b
	mvi	a,00h
	jz	no_DSTATE_change
	dcr	a
no_DSTATE_change:
	sta	DSTATE			; store either 00 (ok) or FF (change)

	mov	a,b
	sta	CURORG			; save CURORG
	
	call	save_CURORG		; update CURORG variable storage
					; STCNTS is never updated, unless a file is killed - rescan
	ret

range_CURSOR_low:			; CURSOR < 0
	mvi	l,00d			; CURSOR = 0
	dcr	b			; decrement CURORG
	jmp	ramcursor_range_adjust1	; retest

range_CURSOR_high1:			; CURSOR >=6
	mvi	l,05h			; CURSOR = 5
	inr	b			; increment CURORG
	jmp	ramcursor_range_adjust1	; retest

range_CURORG_low:
	mvi	b,02h			; CURORG = 1
;	jmp	ramcursor_range_adjust1	; retest
					; b ends up being 1, less code
range_CURSOR_high2:
	dcr	b			; decrement CURORG
	jmp	ramcursor_range_adjust1	; retest

range_CURSOR_high3:
	mov	l,h			; CURSOR = COUNT - 1
	dcr	l			; max value based on COUNT
	jmp	ramcursor_range_adjust1	; retest




range_CURORG_high:
	mov	b,d			; CURORG = CURORG_max
	jmp	ramcursor_range_adjust1	; retest

	
;--------------------------------------------------------------------
					; restore CURORG depending on MODE

save_CURORG:				; used when up or down arrow happens
	push	h

	lxi	h,STORGS
	call	adjust_hl
	lda	CURORG
	mov	m,a

	pop	h
	ret

;--------------------------------------------------------------------
					; store CURORG in STORGS based on MODE

load_CURORG:
	push	h

	lxi	h,STORGS
	lxi	d,CURORG
	jmp	set_VAR

;--------------------------------------------------------------------				; update COUNT based on MODE

load_COUNT:				; get COUNT from STCNTS based on MODE
	push	h

	lxi	h,STCNTS
	lxi	d,COUNT
;	jmp	set_VAR
;--------------------------------------------------------------------
				; hl points to source, bytes must be adjacent
				; de points to target
set_VAR:
	call	adjust_hl
	mov	a,m
	stax	d

	pop	h
	ret

;--------------------------------------------------------------------
adjust_hl:
	lda	MODE
	ora	a			; MODE 0 local, 1 remote
	rz
	inx	h
	ret



;-------------------------------------------------------------------------
scan_files:				; build a table at GEN_1
					; length of table is 2*TOTALNAMES long
					; place all files possible
					; update counts


	lxi	d,GEN_1+table_offset	; blank out 4xtotalnames bytes at GEN_1 and INPUT BUFFER
					; offset to make room for REMOTE_GETBYTE and anything else <35 bytes
					; 35 bytes of offset

	mvi	b,4*TOTAL_NAMES
	push	b	
	call	set_b_00_de
	lxi	d,INPUT_BUFFER
	pop	b
	call	set_b_00_de


	xra	a
	sta	STCNTS			; zero out counts
	sta	STCNTS+1d
	sta	TEMP3			; set initial mode = 0


scan_files_loop:
	lda	TEMP3			; get mode
	mvi	c,2*TOTAL_NAMES		; bc = offset
	mvi	b,00h
	lxi	h,INPUT_BUFFER
	lxi	d,DIRTBL
	ora	a
	jz	scan_files_mode0
	dad	b			; advance 2xTOTAL_NAMES if mode 1
	mov	a,d
	ani	01111111b
	mov	d,a			; adjust for lower 32k if mode 1
scan_files_mode0:
	
	xchg
				; de is target
				; hl is source
	mvi	c,DIRLEN	; set directory length into bc
	mvi	b,00h
				; file types of interest
scan_file1:
	dad	b
	call	get_file_descriptor	; return a 

	cpi	0FFh		; FF marks end of directory
	jz	scan_files_next

	call	test_for_file_type
	jnz	scan_file1
				; found a file

	shlx			; store pointer to RAM file at de
	inx 	d
	inx	d		; advance de

	push	b
	push	h		; temp store

	lxi	h,STCNTS	; get pointer to counts
	mvi	b,00h
	lda	TEMP3
	mov	c,a		; bc holds corrected pointer to count
	dad	b		; hl corrected
	mov	a,m		; get count
	inr	a		; increment
	mov	m,a		; store count

	pop	h
	pop	b		; restore
	jmp	scan_file1

scan_files_next:
	lda	TEMP3
	ora	a
	jnz	scan_copy		; if one, done

	inr	a
	sta	TEMP3			; next
	jmp	scan_files_loop

scan_copy:
	call	CPBLOK
	.dw	INPUT_BUFFER
	.dw	GEN_1+table_offset
	.db	4*TOTAL_NAMES
	ret

;------------------------------------------------------------------------

get_file_descriptor:

	lda	TEMP3
	jmp	get_byte_mode01


;------------------------------------------------------------------------
get_remote_data_byte:
	push	b
	push	d
	push	h
	lda	CURBLK
	mov	c,a
	call	GEN_1		; get byte
	pop	h
	pop	d
	pop	b
	ret
;------------------------------------------------------------------------
test_for_file_type:		; enter with a holding file type byte

	cpi	080h		; basic
	rz			; found a file

	cpi	0C0H		; text
	rz			; found a file

	cpi	0A0H		; machine code
	rz			; found a file
	
	ori	01h
	ret			; return not zero


;---------------------------------------------------------------------------
display_file_column:		; MODE indicates column
					; counts updated
					; table built
					; curorg updated

				; start loop at CURORG
				; end loop at (CURORG+5) or COUNT, whichever is less

				; if count is 0 then message and return.


	lda	CURORG
	mov	b,a

	adi	05d
	mov	c,a		; use CURORG + 5

	lda	COUNT
	ora	a
	jz	display_file_column_message	; message/return if there is nothing to display

	cmp	c
	jp	display_range_set	; if COUNT >= CURORG+5 use CURORG+5

	mov	c,a		; else use COUNT as end of print loop
	
display_range_set:

	call	get_table_address	; get start of table

				; hl points to start of table, ready to loop


	mov	a,b
	dcr	a		; correct for count-1
	call	get_table_entry

	mvi	d,01d		; set start of loop

	mov	a,c
	sub	b
	inr	a
	inr	a
	mov	e,a		; end of looping at e
		
display_file_loop:
	

	push	d		; preserve
	push	h

	call	display_file_entry_mode		; pass d location, h pointer to text
	
	pop	h
	pop	d		; restore

	inx	h
	inx	h

	inr	d
	mov	a,d
	cpi	07d	; loop from 1 to 6, done when 7

	jm	display_file_loop	; if COUNT  >= index loop back

	
	ret

display_file_column_message:
	lda	MODE

	call	ramfile_get_position		; a holds cursor value

	lxi	d,display_file_nofile
	xchg
	call	RPB00

	ret

display_file_nofile:
	.db	"NO FILES!      ",00

;---------------------------------------------------------------------------
get_table_data:
	call	get_table_address	; get start of table
					; hl points to start of table, ready to loop
	lda	CURSOR
	ani	01111111b
	mov	c,a
	lda	CURORG
	add	c
	dcr	a
	jmp	get_table_entry		; hl points to table entry for CURSOR + CURORG

;---------------------------------------------------------------------------
					; return hl pointing to table start
get_table_address:
	lxi	h,GEN_1+table_offset		; get pointer to file data from table
	lda	MODE
	ora	a
	rz				; mode 0 


	lxi	h,GEN_1+TOTAL_NAMES+TOTAL_NAMES+table_offset
							; address if mode 1
	ret
;---------------------------------------------------------------------------

get_table_entry:		; enter with a holding cursor position, hl holding table start
				; exit with hl corrected for table entry
	add	a		; double a, range 00-xx not 11-xx
	mvi	d,00h
	mov	e,a		; get pointer to table
	dad	d		; hl at record
	ret
;---------------------------------------------------------------------------
display_file_entry_mode:


	push	d	; de holds cursor index

	xchg
	lhlx		; hl holds pointer to file directory entry

	shld	TEMP1

	inx	h
	inx	h
	inx	h	; advance to name text

	lda	MODE
	ora	a
	jz	display_file_entry_mode0
				; else get 8 bytes of data from remote rex memory
	lxi	d,INPUT_BUFFER

	push	d

	mvi	b,8d

display_file_entry_mode1loop:
	call	get_remote_data_byte

	stax	d
	inx	h
	inx	d
	dcr	b
	jnz	display_file_entry_mode1loop

	pop	h		; hl points to input buffer


display_file_entry_mode0:	; get 8 bytes of data from local memory
				
	pop	d		; get back index for loop

				; hl points to 8 bytes of data
	push	h		; temp store hl

	lda	MODE
	ora	d		; index in a
	dcr	a		; correct for offset
	call	ramfile_get_position		; a holds cursor value

	shld	TEMP2

	rst	6
	.dw	POSIT		; set location

	pop	h		; get back hl

	mov	a,d

	cmp	e
	jp	display_column_blank


	mvi	d,06h		; print XXXXXX.YY
	call	print_d
	mvi	a,'.'
	rst	6
	.dw	LCD
	mvi	d,02h
	call	print_d

	lxi	h,b6		; clear out size field
	call	RPBUF

				; now display size
	lhld	TEMP2
	mov	a,h
	adi	010d
	mov	h,a		; set location

	rst	6
	.dw	POSIT		

	lhld	TEMP1
	call	get_size_of_selection

	mov	h,b
	mov	l,c

	rst	6
	.dw	NUMPRT

	ret

display_column_blank:

	lxi	h,b15
	jmp	RPBUF



;---------------------------------------------------------------------------
ramfile_get_position:		; enter with a being cursor value [0..] [128..y]
				; get the cursor location 
				; depends on MODE bit, and cursor value

#if modeltype=0
	lxi	h,0402h
#else
	lxi	h,0406h
#endif

	push	psw
	ani	01111111b	; strip out mode bit
	add	l
	mov	l,a		; update row based on CURSOR

	pop	psw		; check what MODE is
	ani	10000000b
	ora	a
	rz
	mvi	a,20d		; add 20 to column if mode = 1
	add	h
	mov	h,a
	ret


;---------------------------------------------------------------------------
ramfile_line1:
;0123456789012345678901234567890123456789
;RAM: VVVVV free    |ZZZZZZ:


#if modeltype=0
	lxi	h,0101h
#else
	lxi	h,0105h
#endif
	rst	6
	.dw	POSIT

	lxi	h,RAM
	call	RPBUF

	mvi	a,':'
	rst	6
	.dw	LCD
	mvi	a,' '
	rst	6
	.dw	LCD
	
	call	get_freemem_in_hl 
	
	rst	6
	.dw	NUMPRT

	lxi	h,free1
	call	RPBUFK


#if modeltype=0
	lxi	h,1501h
#else
	lxi	h,1505h
#endif
	rst	6
	.dw	POSIT

	lxi	h,REX1
	call	RPBUF

	lda	CURBLK
	call	find_directory_entryA

; exit 		hl = pointer to directory entry (or potentially end of record) (or free entry)
; 		zero set if found, zero not set if not found

	inx	h
	mvi	d,06h
	call	print_d		; print block name at screen

	ret


free1:	.db	" free",00	
REX1:	.db	"REX: ",00

;------------------------------------------------------------------------
ramfile_column:
#if modeltype=0
	lxi	h,1401h
#else
	lxi	h,1405h
#endif

	rst	6
	.dw	POSIT

	mvi	b,07d
ramfile_column1:
	push	b
	lxi	h,col
	call	RPBUF
	pop	b
	dcr	b
	jnz	ramfile_column1

	ret

	
col:	.db	"|",27d,66d,27d,68d,00

;------------------------------------------------------------------------
ramfile_display_fnkeys:
;Help      Copy                     Exit  <-- remote mode 1
;Help           Kill Name           Exit  <-- local mode 0

#if modeltype = 0			; M100
	lxi	h,0108h
#else					; T200
	lxi	h,010Ch
#endif
	rst	6
	.dw	POSIT

	lxi	h,fn1			; 1 HELP
	call	RPBUF

	lxi	h,b5			; 2 blank
	call	RPBUF

ramkey3:

	lda	COUNT
	ora	a
	jz	ramkey2

	lda	MODE
	ora	a
	jz	ramkey3a		; jump if mode = 0

	lxi	h,fn3a			; 3 COPY
	call	RPBUF

ramkey4:
	lxi	h,b5			; 4 blank
	call	RPBUF
	lxi	h,b5			; 5 blank
	call	RPBUF
	jmp	ramkey6

ramkey3a:
	lxi	h,b5			; 3 blank
	call	RPBUF

	lxi	h,fn4			; 4 kill
	call	RPBUF

	lxi	h,fn5			; 5 blank
	call	RPBUF

ramkey6:
	lxi	h,b5			; 6 blank
	call	RPBUF

	lxi	h,b5
	call	RPBUF

	lxi	h,fn8
	jmp	RPBUF

ramkey2:
	lxi	h,b5
	call	RPBUF

	jmp	ramkey4


;------------------------------------------------------------------------
rammenu_function_key_pressed:
;Help      Copy                     Exit  <-- remote mode 1
;Help           Kill Name           Exit  <-- local mode 0

	mov	d,a
	lda	COUNT
	ora	a
	jz	rammenu_function_key_nocount

	mov	a,d

	ora	a		; fn key 1
	jz	display_ramfile_help

	dcr	a		; 2

	push	psw		; temp store fn key result

	lda	MODE
	ora	a
	jnz	ramkey_copy

	pop	psw
	dcr	a		; 3

	dcr	a		; 4
	jz	ramfile_kill

	dcr	a		; 5
	jz	ramfile_name

ramkey_6:
	dcr	a		; 6
	dcr	a		; 7
	dcr	a		; 8

ramkey_exit:
	jz	restart_REXMGR

	jmp	rammenu_loop2		; must have pressed some other key, so loop back

ramkey_copy:
	pop	psw
	dcr	a		; 3
	jz	ramfile_copy
	
	dcr	a		;4
	dcr	a		;5
	jmp	ramkey_6

rammenu_function_key_nocount:
	mov	a,d
	ora	a
	jz	display_ramfile_help
	cpi	07d
	jmp	ramkey_exit
	
	
;--------------------------------------------------------------------------
get_size_of_selection:			; enter with h pointing to directory entry

	call 	get_file_data		; a holds first byte, hl has corrected pointer to start of file

get_size_of_selection1:
	lxi	b,0000h			; initialize B

	CPI	80H			; test for basic program
	JZ	get_BA_size

	CPI	0A0H			; test for machine language
	JZ 	get_CO_size

	cpi	0C0H
	jz	get_DO_size

	ret				; return!

;--------------------------------------------------------------------------
get_DO_size:		; enter with hl pointing to starting address of program
			; corrected for mode

	push	h
	call	I_FASTDO
	pop	h		
	
	lxi	b,0000h			; initialize b
	lda	CURBLK			; a points to target block, hl pointst to starting address
	call	GEN_1

	push	b
	call	I_REMOTE_GETBYTE
	pop	b

	ret


;--------------------------------------------------------------------------
				; calculates the size number for a basic program	
get_BA_size:			; enter with hl pointing to starting address of program

				; error here - use rom program

				; get first byte
				; if zero, look for next zero
				; if non zero, load next line address
				; repeat

	push	d		; temp store

	mov	b,h
	mov	c,l		; store start of file in bc
				; could be high or low (mode)

get_BA_size1:
	call	get_byte_MODE	; get data
	mov	e,a
	inx	h
	call	get_byte_MODE	; get data
	mov	d,a


	ora	d		; test de for 0000
	jz	get_BA_size_done	; if zero, then done

	mov	h,d
	mov	l,e		; new file pointer on hl

	call	fix_hl_mode

	jmp	get_BA_size1	; loop back


get_BA_size_done:
	inx	h

	push	h		; hl = end of file

	dsub			; hl=hl-bc
				; start of file is in bc

	mov	b,h
	mov	c,l		; length in bc

	pop	h		; restore hl = end of file
	pop	d		; restore de


				; bc holds length
	RET


;--------------------------------------------------------------------------
				; subroutine - calculates the size of a machine language program
get_CO_size:			; enter with hl pointing to starting address of program

					; code from 21A4
					; get size of ML program
					; start length exe
	INX 	H			
	INX 	H			; advance to length
	call	get_byte_MODE		; get data
	MOV 	E,a	

	INX 	H	
	call	get_byte_MODE		; get data
	MOV 	D,a			; get file length in DE

	xchg				; length in hl	

	lxi	d,0006d			; add 6	
	DAD 	D			; hl now points to end of file for ML code file
					; including header
	MOV 	B,h
	mov	c,l

	RET



;--------------------------------------------------------------------------
fix_hl_mode:
	lda	MODE			; local = 00000000b, remote = 10000000b
	xri	0FFh			; local = 11111111b, remote = 01111111b

	ana	h			; kill MSB of h if remote
	mov	h,a			
	ret


;--------------------------------------------------------------------------
get_byte_MODE:			; preserves hl, bc, de

	lda	MODE

get_byte_mode01:
	ora	a
	jz	get_byte_mode0
				; else get data from remote rex memory
	call	get_remote_data_byte

	ret

get_byte_mode0:
	mov	a,m
	ret


;--------------------------------------------------------------------------
ramfile_kill:			; check, then kill file under cursor


	lxi	h,sure
	call	RPBMSGYN	; if "Y" return with zero set
				; if not "Y", return with zero reset

	push	psw
	rst	6
	.dw	LCD
	pop  	psw

	jnz	rammenu_loop1a
	
	call	get_table_data
	
	xchg
	lhlx			; hl points to file directory entry
				
	PUSH H
	CALL	get_file_data	; Get start address of file at M
	XCHG
	POP H
	MOV A,M			; a holds first byte of directory entry
				; hl points to directory entry
				; de points to start of program
	CPI	80H		; IF FILE TYPE IS BASIC
	JZ	KILL_BA	  	;

	cpi	0A0H		; IF FILE TYPE IS machine code
	jz	KILL_CO

				; else FILE TYPE IS Text
	cpi	0C0H
	jz	KILL_DO	   	
	
	; unknown, don't kill
	jmp	rammenu_loop1a


;--------------------------------------------------------------------------

KILL_DO:			; 1FBFH
	rst	6
	.dw	KILD		; KIL .DO FILE TYPE
	jmp	KILL_COMMON

;--------------------------------------------------------------------------

KILL_CO:			; 1FD9H
	rst	6
	.dw	KILC		; KILL .CO FILE TYPE

;--------------------------------------------------------------------------
KILL_COMMON:
	rst	6		; don't know why this is needed, somethign to do with
	.dw	LNKFIL		; routine at 18DD
	JMP	rammenu_loop0	

;--------------------------------------------------------------------------

KILL_BA:	
	rst	6
	.dw	KILB		; KILL .BA FILE TYPE
	JMP	rammenu_loop0	; does not need the extra lnkfil

;--------------------------------------------------------------------------
get_file_data:

	call	get_byte_MODE
	push	psw
					
	INX 	H			; Get start address of file at M
					; already corrected for mode
	call	get_byte_MODE
	push	psw

	INX 	H	
	call	get_byte_MODE
	MOV 	h,a	

	pop	psw
	MOV 	l,a	

	call	fix_hl_mode		; correct for mode

	pop	psw			; hl holds pointer to start of file
					; a holds first byte
	ret

;--------------------------------------------------------------------------
ramfile_copy:

; make a directory entry
; find the right spot to open up a hole
; inject the program
; linkfil

; is there at least one directory space
; is there free memory enough for the file - MAKHOL will not do it if it cannot. check flags
; is there a file of the same name?
; what kind of file to make BA, DO, CO?

; for DO, ASCTAB-1 is the start address

; BINTAB, VARTAB, ARYTAB all adjusted by MAKHOL, so correct BINTAB when adding CO.
; when adding DO, BA, MAKHOL is fine to use
; adding .DO, no adjutments needed
; adding .BA, must adjust ASCTAB

; flow
; check for same name, return if found (copy to Input buffer)
; check for a free directory space , return if none, store in TEMP1 if there is one
; create entry
; get size of source file
; branch to deal with the 3 types

	lda	COUNT
	ora	a
	jz	rammenu_loop2			; if count = zero go back

	call	get_table_data		; get pointer in hl to table entry based on CURSOR

	xchg
	lhlx				; hl points to directory entry of source
					; already corrected in table
	push	h

	call	get_size_of_selection 	; enter with h pointing to directory entry
					; a holds first byte, hl has corrected pointer to start of file
					; bc holds size
	mov	h,b			; store size in TEMP4
	mov	l,c
	shld	TEMP4

	pop	h

	lxi	d,INPUT_BUFFER
	push	d
	lxi	b,000Bh			; c = 011d

	call	ramfile_copy_block	; entire entry copied to INPUT_BUFFER


	pop	h
	push	h
	call	search_name_free	; hl points to start of file name record data
					; if free slot found, TEMP2 points to first free file name slot
					; if free slot not found, TEMP2 = 0000
					; if file name found, TEMP1 points to file name entry
					; if file name not found - TEMP1 = 0000

	lhld	TEMP1
	mov	a,h
	ora	l
	jnz	ramfile_copy_fail	; if temp1 <> 0000 then file name found - error

	lhld	TEMP2
	mov	a,h
	ora	l
	jz	ramfile_copy_fail	; if temp2 = 0000 then no free entry found - error

					; new entry address in TEMP2
					; source directory entry at input buffer

	pop	d			; get back input buffer pointer in de
	ldax	d
	mov	m,a			; store first byte in new directory entry
	push	psw			; temp store for use later

	inx	h
	inx	h
	inx	h
	inx	d
	inx	d	
	inx	d			; DE points to source name
					; hl points to target for name

	mvi	c,08d
	call	MOVEC_D_H		; make directory entry
					; entry made except for start of file


	pop	psw			; get back first byte		

					; size - TEMP1
					; new directory entry address - TEMP2
					; source directory entry address - INPUT_BUFFER

	cpi	080h
	jz	ramfile_copy_BA

	cpi	0A0h
	jz	ramfile_copy_CO

	cpi	0C0h
	jz	ramfile_copy_DO

	jmp	ramfile_copy_fail

;---------------------------------------------------------------------------
ramfile_copy_BA:			; new directory entry address in TEMP2
					; source directory entry at input buffer

					; find NULDIR pointer
					; make a hole xx long at NULDIR
					; inject data at NULDIR
					; store pointer NULDIR-1 in directory entry
					; update ASCTAB
					; LNKFIL
					
					; LNKFIL appears to correct NULDIR properly after the insertion


	lhld	NULDIR			; point hl to NULDIR entry

	shld	TEMP3			; store injection point in TEMP3
	dcx	h
	shld	TEMP1			; starting address just below 

	call	ramcopy_makehole

	lhld	TEMP4
	xchg				; size in DE

	lhld	ASCTAB
	dad	d
	shld	ASCTAB			; advance ASCTAB

	call	ramfile_copy_file	; copy the data into the hole

	jmp	rammenu_loop0		; done
	

;---------------------------------------------------------------------------
ramfile_copy_CO:			; new directory entry address in TEMP2
					; source directory entry at input buffer

					; save BINTAB to temp
					; make hole at VARTAB of size xx
					; inject data here
					; reset BINTAB from temp
					; LNKFIL
					
	lhld	BINTAB
	push	h			; store BINTAB


	lhld	VARTAB			; use BINTAB as injection point
	shld 	TEMP3
	shld	TEMP1			; last file, so use same starting address

	call	ramcopy_makehole

	pop	h
	push	h
	shld	BINTAB			; restore BINTAB

	call	ramfile_copy_file	; copy the data into the hole

	pop	h
	shld	BINTAB			; restore BINTAB

	jmp	rammenu_loop0		; done

;---------------------------------------------------------------------------
ramfile_copy_DO:			; new directory entry address in TEMP3
					; source directory entry at input buffer

					; ASCTAB-1 start of new file in directory entry
					; make xx byte hole at ASCTAB, xx is file length incl EOF
					; copy data to hole
					; LNKFIL

	lhld	BINTAB			; hl points to injection point
	shld	TEMP3			; store injection point in TEMP3
	dcx	h
	shld	TEMP1			; start address for new directory entry in TEMP1

	call	ramcopy_makehole	; make the hole
	call	ramfile_copy_file	; copy the data into the hole
	jmp	rammenu_loop0		; done
					

;---------------------------------------------------------------------------
ramcopy_makehole:			

	lhld	TEMP4
	mov	b,h
	mov	c,l			; bc holds size

	lhld	TEMP3			; hl is injection point

	rst	6
	.dw	MAKHOL			; make hole BC long at HL, adjusting pointers

; MAKHOL adjusts BINTAB, VARTAB, ARYTAB
; MAKHOL does not adjust ASCTAB, needed by LNKFIL


	jc	ramfile_copy_fail	; jump here if not enough space

	ret

;---------------------------------------------------------------------------
ramfile_copy_file:			; copy the data into the hole

					; TEMP2 new directory entry address
					; INPUT_BUFFER source directory entry, points to source file
					; TEMP3 injection point of new file
					; TEMP1 start address for directory entry
					; TEMP4 size

	lhld	TEMP4
	mov	b,h
	mov	c,l			; get size in BC

	lhld	TEMP3			; target in hl
	xchg				; target in de

	lhld	INPUT_BUFFER+1d
	call	fix_hl_mode		; correct hl for lower block
	
					; hl source, de target
	call	ramfile_copy_block	; copy block


	lhld	TEMP2			; TEMP2 holds pointer for new directory entry
	inx	h
	xchg
	lhld	TEMP1			; start address for directory entry in hl
	shlx				; store new start of file into new directory entry


	rst	6
	.dw	LNKFIL			; fix up directory


	ret

	

;---------------------------------------------------------------------------
ramfile_copy_fail:

	lxi	h,ramfile_error
	jmp	common_error

ramfile_error:	.db	"Copy error....",00

;---------------------------------------------------------------------------
ramfile_copy_block:		; hl source, de target, bc length


	push	h
	push	b
	push	d
	
	call	I_FASTCPY

	pop	d
	pop	b
	pop	h

	push	h
	push	b
	push	d

	lda	CURBLK

	call	GEN_1

	call	I_REMOTE_GETBYTE

	pop	d
	pop	b
	pop	h

	ret
	


;---------------------------------------------------------------------------
ramfile_name:				; get a new 6 byte max name


	call	get_name_common		; entry with hl pointing to start of 6 byte name location on screen, formatted for POSIT
					; store 6 byte name at INPUT_BUFFER, F685 is first character of name
					; if escape hit then set zero bit
					; if successful, reset zero bit
					; enter with hl = col,row

	jz	rammenu_loop1a		; if escape hit, then bail out (no cursor change)



	call	get_table_data		; get pointer in hl to table entry based on CURSOR

	xchg
	lhlx				; hl points to directory entry of source
					; already corrected in table

	inx	h
	inx	h
	inx	h			; hl points to target for name


	
	lxi	d,INPUT_BUFFER		; DE points to source name


	mvi	c,06d
	call	MOVEC_D_H		; make directory entry
					; entry made except for start of file
	jmp	rammenu_loop0