
; the approach:
; ram images are created by REXROM.  the stack pointer on startup of REXMGR
; is the same as the stack pointer at main menu.  By saving the value of STACK in ALTLCD
; we know where to put the stack to safely operate after the swap.



copy_ram_to_flash:		; target = FREBLK
RAM_to_FLASH:			


	call	check_flash_ready
		
	lda	FREBLK
	call	check_blank
		
	lxi	h,msgr1
	call	RPBMSG

#if real_hardware=0
	ret
#endif	

	mvi	a,modeltype		; write model information to top of ALTLCD
	sta	ALTLCDE			; 00 = model 100, 1 = T200

	call	I_BARS
	call	GEN_1			; set up bar indicator

	call	I_R2F			; write RAM data to FLASH (32k)
					; to block c (returns to block 00)
	lda	FREBLK
	mov	c,a			
	call	GEN_1

	ret


;---------------------------------------------------------------------
copy_flash_to_ram:
FLASH_to_RAM:				; enter with a = source block
					; interrupts on, rexrom visible

#if real_hardware=0
	ret
#endif	


	sta	TEMP2			; temp store a			
	call	check_flash_ready
	
#if modeltype = 0
	lhld	TIMYR1			; get current year data (2 bytes)
	push 	h			; store current year data
#endif

; check if model matches expected

	call	I_REMOTE_GETBYTE
	lxi	h,ALTLCDE-8000h
	lda	CURBLK
	mov	c,a
	call	GEN_1

; read a byte from flash at location hl
; entry: hl = location, c = target block, returns to block 00
; exit:	a = result

	cpi	modeltype		; compare to model 100 00
	jz	copy_flash_to_ram_modelok


	lxi	h,msgr3
	jmp	common_error



copy_flash_to_ram_modelok:	
; now figure out if mem size right


	lxi	h,LOWRAM - 08000h +1d	; point hl to LOWRAM data in flash
	lda	CURBLK
	mov	c,a
	call	GEN_1

	ani	11100000b		; look at top 3 bits only
	mov	e,a

	lda	LOWRAM+1d
	ani	11100000b
	cmp	e			; compare local LOWRAM to flash LOWRAM

	jz	flash_to_ram_mem_size_ok

flash_to_ram_mem_size_wrong:		; exit with zero set
	lxi	h,msgr4
	jmp	common_error


; memory size ok

; time to copy
flash_to_ram_mem_size_ok:

	lxi	h,msgr2
	call	RPBMSG

	call	I_BARS
	call	GEN_1		; set up bar indicator

	call	I_F2R

; F2R
; write flash data to RAM excluding altlcd
; from block c (returns to block 00)

	lda	TEMP2		; get source
	mov	c,a		; store in C
	call	GEN_1

; restore year data
#if modeltype = 0
	pop 	h
	shld	TIMYR1
#endif

	call	I_REX_SW	; reinstall REX software in new image
	
	ret

;----------------------------------------------------------------
msgr1:	.db	"Copying RAM to Image......",00h
msgr2:	.db	"Copying Image to RAM......",00h
msgr3:	.db	"Model mismatch..cannot install!",00h
msgr4:	.db	"RAM size mismatch...cannot install!",00h
