;------------------------------------------------------
RPBMSGYN:
	mvi	a,01d
	jmp	RPBMSG_1
;--------------------------------------------------------------------------
RPBMSG:				; set d = 0108h	(row) (col) col row
				; hl points to data for printing at de
	mvi	a,04d		; escK terminator
RPBMSG_1:
	push	psw		; store terminator

	push	h		; temp store
	call	clsmsg

#if modeltype = 0 		; M100/T102
	lxi	d,0108h
#else				; T200
	lxi	d,010Ch
#endif
	
	pop	h		; restore

	jmp	RPB00_2


;------------------------------------------------------
RPBUFYN:
	mvi	a,01d
	jmp	RPBUF_1
;------------------------------------------------------
RPBUFCR:
	mvi	a,02d
	jmp	RPBUF_1
;------------------------------------------------------
RPBUFK:
	mvi	a,04d
	jmp	RPBUF_1
;------------------------------------------------------
RPBUFCRK:
	mvi	a,06d
	jmp	RPBUF_1

;--------------------------------------------------------------------------
RPB00:			; print from hl with de holding cursor location
	xra	a		; set terminator
RPB00_1:
	push	psw		; store terminator
RPB00_2:			; terminator on stack only
				
				; hl points to data, de is cursor
	xchg
	rst	6
	.dw	POSIT		; set cursor at hl
	xchg			; hl = pointer to data

	jmp	RPBUF_2
;--------------------------------------------------------------------------
; subroutine RPBUF

RPBUF:					; print at cursor from hl till 00 read 
	xra	a		; set terminator
RPBUF_1:
	push	psw		; store term indicator

RPBUF_2:			; only terminator on stack
	mov	a,m
	inx	h

	ana	a
	jz	RPBterm	

	rst	6
	.dw	LCD
	jmp	RPBUF_2

;--------------------------------------------------------------------------
RPBterm:
	pop	psw			; get terminator
					; 00000001 = ? Y/N
					; 00000010 = CRLF
					; 00000100 = ESCK
					; 00000110 = ESCK and CRLF
					; 00 = ret

	ora	a			; 0, exit
	rz		

	cpi	01d			; 1
	jz	RPBYN

	cpi	02d			; 2
	jz	RPBCRLF
	
	cpi	04d			; 4 
	jz	esc_K

	call	esc_K			; must be 6

;------------------------------------------------------
RPBCRLF:
	push	h			; temp store pointer
	lxi	h,crlf
	call	RPBUF
	pop	h			; restore pointer
	ret

crlf:	.db	13d,10d,00d


;------------------------------------------------------
RPBYN:
;	pop	h			; clear stored h, useless anyhow
					; confirm this was not needed?
	lxi	h,msgyn
	call	RPBUF
	jmp	get_YN

msgyn:	.db	" (Y/N)? ",00 
;---------------------------------------------------------------
;RNUMPT - print number in a at HL
;---------------------------------------------------------------
RNUMPT:
	push	psw
	rst	6
	.dw	POSIT

	pop	psw
	mvi	h,0h
	mov	l,a
	
	rst	6
	.dw	NUMPRT
	
	ret

;--------------------------------------------------------------------
print_d:				; print d characters at LCD from hl
name_print_loop:
	mov	a,m			; get character
	rst	6
	.dw	LCD			; print character, incrementing posit		
	inx	h
	dcr	d
	jnz	name_print_loop
	ret


;---------------------------------------------------------
; copy code block located at first pointer to location second pointer
; copy n bytes
; format 
;	call 	CPBLOK
;	.dw	source
;	.dw	target
;	.db	count (<256)		
;---------------------------------------------------------
CPBLOK:	pop	d

	lhlx
	push 	h		; temp store hl - pointer to source code block

	inx	d
	inx	d
	lhlx			; hl holds pointer to target location

	inx	d
	inx	d
	ldax	d		; load a with # of characters

	inx	d		; de = return location, hl = pointer to target location
	xchg
	xthl			; hl = pointer to source code block, stack = return location, de = pointer to target location

	mov	c,a		; c holds # of characters, hl = source location, de = target location

	xchg

;--------------------------------------------------------------------
MOVEC_D_H:			; mov c bytes from d to h
	ldax	d		; load data
	mov	m,a		; store data
	inx	h
	inx	d
	dcr 	c
	jnz	MOVEC_D_H


	ret


;--------------------------------------------------------------------
fix_input_buffer:		; avoids "SN ERROR" in basic
	mvi	b,0C0h
	lxi	d,INPUT_BUFFER-4d
	jmp	set_b_00_de


;--------------------------------------------------------------------
;esc_B:	mvi	a,66d		;B - down one line
;	jmp	esc_sequence
;--------------------------------------------------------------------
;esc_D:	mvi	a,68d		;D - left cursor
;	jmp	esc_sequence

;--------------------------------------------------------------------
reverse_video:
	mvi	a,070h		;p - turn on reverse vid
	jmp	esc_sequence
;--------------------------------------------------------------------
normal_video:
	mvi 	a,71h		;q - turn off reverse vid
;--------------------------------------------------------------------
esc_sequence:	
	rst	6
	.dw	ESCA
	ret


;--------------------------------------------------------------------	
add_whitespace:				; hl points to first location to add a space
					; b holds count
					; b >= 1 

	mvi	M,20H			; store 20H at HL, which should be the end of the text buffer  20 = space
	inx 	h			; increment HL
	dcr	b
	jnz	add_whitespace		; if HL was equal to DE which was HL+18, then FCED
	
	ret				; adding whitespace to the end of the text




;--------------------------------------------------------------------
get_YN:				; if "Y" return with zero set
				; if not "Y", return with zero reset


	call	get_key

	rst	6
	.dw	UPCAS		; convert to upper case
	
	cpi	'Y'		; test for Y, set zero flag accordingly
	rz

	cpi	'N'
	jz	get_YN_no

	jmp	get_YN		; if not y or n, loop back

get_YN_no:
	ora	a		; reset zero bit
	ret


;-----------------------------------------------------------------------
chksum_calc:

	call	GEN_1			; calculate checksum in block a

	mov 	a,d
	call	print_a_as_2_hex_char
	mov	a,e	

;-------------------------------------------------------------------------
print_a_as_2_hex_char:		; print a as two hex characters
	push	psw

	rrc
	rrc
	rrc
	rrc			; rotate a 4 times (fast)
	
	call	print_a_as_hex	

	pop	psw
				; carry on to print_a_as_hex

;-------------------------------------------------------------------------

print_a_as_hex:			; use lower 4 bits of a to create and print a hex character

	ani	00001111b	; zero out upper 4 bits

	adi	030h		; add base of 30h
	cpi	03Ah		; if greater than equal to 3A
	jm	print_a_as_hex1
	adi	07h		; 3Ah has to be 41h etc
print_a_as_hex1:
	rst	6
	.dw	LCD		; print the character
	ret




;-----------------------------------------------------------------------
cls_date:
#if modeltype=0
	lxi	h,1A07h
#else
	lxi	h,1A0Bh
#endif
	jmp	print_escK_at_hl
;-----------------------------------------------------------------------
cls_blockinfo:

#if modeltype=0
	lxi	h,0107h
#else
	lxi	h,010Bh
#endif
	rst	6
	.dw	POSIT
	
	lxi	h,b11
	jmp 	RPBUF

;-----------------------------------------------------------------------
cls_enter:
clsr2:
#if modeltype=0
	lxi	h,0102h
#else
	lxi	h,0106h
#endif

	jmp	print_escK_at_hl

;-----------------------------------------------------------
clsbar:
#if modeltype=0
	lxi	h,2008h
#else
	lxi	h,200Ch
#endif
	jmp	print_escK_at_hl


;-----------------------------------------------------------

clsr7:
#if modeltype=0
	lxi	h,0107h
#else
	lxi	h,010Bh
#endif
	jmp	print_escK_at_hl

;-----------------------------------------------------------
clsmsg:
clsr8:
#if modeltype=0
	lxi	h,0108h
#else
	lxi	h,010Ch
#endif


;-----------------------------------------------------------------
print_escK_at_hl:		; hl is screen location, a is data	

	rst	6
	.dw 	POSIT	
;-----------------------------------------------------------
esc_K:				; erase to end of current line
	mvi	a,75d
	jmp	esc_sequence





