; menu bugs-




;--------------------------------------------------------------------
; Main Menu routines
;
; SUFLAG usage:
;		bit 0 = start up director
;		bit 1 = free blocks indicator
; 		bit 2 = display block info indicator
;		bit 3 = sort order indicator
;		bit 4 = display enter text indicator
; 		bit 5 = main rom control by REX indicator
;		bit 6 = load pending indicator
;		bit 7 = commit load indicator

; variable type - 00=ramimage, 01=romimage, 10=bootimage, 11=system
; max 16 of each type
; assumptions - you never start with more than 16 of one type of image



; support for main rom replacement
; use bit 5 of SUFLAG to indicate if it REX is providing main rom
; detect main rom status my checking for "enu" vs "ENU"
; if main rom is active, display "M" at character 9
; if primary is active, display "P" at character 9
; if secondary is active, display "S" at character 9
; do not allow switching if target is blank
; display entry name for 2,4, ignore entry names for 3/5
; assign names to 2 and 4.



; about JMPVECT
; use this pointer to redirect control to the appropriate menu
; STACK should also be reset, and should be valid for any of the menus


; Warning messages to re-install ROMS and user programs that use hooks
;	when new RAM is installed
; 	when revert to previous ram image

; note about saving RAM images and V4.5 compatibility

;	V4.5 RAM images
;	- hooks table still installed in the RAM image (bad)
;	- rom traces are still there also
;	V4.6 RAM images
;	- hooks table saved to lower ram and wiped from upper RAM
;	- rom traces are still there also


;	when we start 4.6 REX Mgr, we wipe the hooks table and store it in ram
;	we do not clear out the rom program, or reset upper memory to default
; 	when ram images are then stored in REX, they have no hooks table
;	but the hooks table is in ram still.

; 	when we restore, we remove all traces of the main rom from the ram image
;	we also need to wipe the hooks table to default also because V4.5 images 
;	still have the hooks installed.

;	V4.6 restored RAM images then, should have no hooks and no rom traces.

;	- must add a hooks sweep out to the processes that load stored ram images
;	- must add warning screen to same.

; note about ROMSEL and Main Rom Management
; 	- the point is
;		- to define the working main rom image
;		- to store the info in the active block
;	- always run REX MANAGER with Primary rom (default power up condition)
;	- we should detect the state of rom selection on start of menu
;	- maintain that throughout operation
;	- if we change the use, change ROMSEL and update the active block info, no switch
;	- detect and store ROMSEL in actblk_routines
;	- make sure that RESTORE_AB is compatible.


;--------------------------------------------------------------------
REXMGR:

				; interrupts should be on in REXMGR
				; enter with HKFLAG set based on incoming hook table status

	di	
	call	I_REX_SW



	call	I_SETPRIMARY
	call	GEN_1		; make sure primary rom is selected

	ei			; REX MANAGER runs with primary rom selected
				; active block data holds desired main rom selection.

	xra	a		; set sort to newest last, turn off block info display	
	sta	SUFLAG		; don't display enter text by default
	sta	TYPE		;  set type to 00  00=RAM 01=ROM 10=OS 11 = SYS




#if real_hardware = 1
	call	syscheck		; make sure system is backed up
					; and check directory also
#endif

restart_REXMGR:
	mvi	a,07d
	sta	CURSL			; set cursor length

	call	test_rom_mode
	call	display_title

	jmp	menu_loop1		; don't bother with directory structure on first entry


;menu_loop0:				; use this loop for file operations
;menu_loop1:				; this loop for type updates
;menu_loop2:				; this loop for cursor updates
;menu_loop3:				; use this loop if cursor not updated, or keyboard input invalid

menu_loop0:				; use this loop for file operations

	call	scan_directory_structure	; detailed check of directory structure

menu_loop1:

	xra	a
	sta	CURSOR				; zero out cursor locations
	sta	OCURSOR				; enter here for re-sorted list

menu_loop1a:	
					; this loop for type updates
	lxi	h,menu_loop0
	shld	JMPVECT			; store this location as the restart of menu

					; ROMSEL should be always set correctly

	call	read_active_block	; update active block info first
					; update ROMSEL
					; must be ahead of scan_for_BB

	call	display_rom_mode	; indicate if REX is in control of the ROM

	call	quick_scan_directory
	call	get_freeblock_status


	call	scan_for_BB		; point FREBLK to a free block pair
					; tidy up directory and block assignments to suit
					; always return pointing to a BB pair, FREBLK set

;	jz	scan_not_blank_error	; handle an error condition

	call	quick_scan_directory	; rescan the table to populate the tables again.

	call	display_group_type
	call	display_free_blocks

menu_loop00:				; enter here for resorted list

	call	directory_sort		; entries sorted
					; for sys type, a simple table is created

	call	display_directory_entries	; requires updated COUNT

	xra	a
	call	toggle_cursor			; initial cursor toggle

menu_loop1b:				; enter here to redraw screen without 
	mvi	a,0FFh
	sta	ODSTATE			; need this to redisplay


menu_loop2:					; this loop for cursor updates
						; highlight the menu entry that is under the cursor
	call	get_block_cursor	; update CURBLK

	call	update_state

	call	update_date		; display date/time if mode = 1 or type is sys

	call	display_block_info

	call	display_state

	lda	DSTATE
	sta	ODSTATE

				; now get keyboard response, take action.

menu_loop3:			; use this loop if cursor not updated, or keyboard input invalid

	call	blink_cursor		; invert cursors if different 
	lda	CURSOR
	sta	OCURSOR

menu_get_key:
	rst	6
	.dw	KYREAD		; wait for a character, returned in a
				; carry set - function key pressed
				; zero set - no key found
	jz	menu_get_key
				; a key has been pressed 
				; arrow keys move cursor around
				; space advances cursor
				; enter "selects", action depends on cursor location
				; function keys take action depending on cursor location
				; check for function keys first
	jc	menu_function_key_pressed		; if carry set then A holds fun key number
				; some other key pressed
				; up is 30, down is 31, left is 29, right is 28
				; space is 32, enter is 13
				; tab is 9

				; s or S for sort order
	rst	6
	.dw	UPCAS		; convert to uppercase
	cpi	'S'
	jz	toggle_sort
	cpi	'B'
	cz	toggle_showblock
	cpi	'E'
	cz	toggle_showenter
	cpi	'I'		; display info about REX model etc.
	jz	show_REX_info
	cpi	'C'
	jz	display_checksum
	cpi	09d
	jz	increment_type
	cpi	13d
	jz	cursor_select

	call	process_cursor_type

	jmp	menu_loop2


;--------------------------------------------------------------------
process_cursor_type:	; enter with a holding keyboard input
			; c = COUNT

	lxi	h, COUNT
	mov	c,m		; c holds count

	push	psw

	lda	TYPE
	cpi 	03d
	jnz	process_cursor1
	dcr	c		; decrement count by 1 for display purposes in sys

process_cursor1:
	lda	CURSOR
	mov	h,a
	pop 	psw

	cpi	31d
	jz	cursor_down
	cpi	30d
	jz	cursor_up
	cpi	29d
	jz	cursor_left
	cpi	28d
	jz	cursor_right
	cpi	32d
	jz	cursor_right

	
	ret  			; cursor unchanged, h = cursor
				; menu_loop3 is the jump location

	
cursor_down:
	mov	a,h
	adi	03d
	cmp	c
	rp				; if cursor+3 >= count then can't use down

	sui	03d	
	cpi	12d			; compare to 12
	rp				; if greater, can't use down arrow

	adi	04d			; otherwise add 4 to cursor location
					; otherwise update cursor location
	jmp	cursor_exit		; loop back

cursor_up:
	mov	a,h			; load a with cursor location
	cpi	04h			; test against 4
	rm				; if less, can't use up arrow
	sui	04d			; otherwise update cursor
	jmp	cursor_exit

cursor_right:
	mov	a,h
	cpi	15d				; compare to 15
	jp	cursor_right_zero		; if > = 15 then 0 and exit

	cmp	c				; compare to count
	jm	cursor_right_increment		; if < count then increment and exit
						; otherwise zero and exit
cursor_right_zero:				; zero
;	xra	a
;	jmp	cursor_exit
	mvi	a,0FFh			; alternate, less code
cursor_right_increment:
	inr 	a
	jmp	cursor_exit


cursor_left:
	mov	a,h
	cpi	1d			; compare to 1
	jp	cursor_left2		; if >= 1 then decrement and exit

cursor_left1:				; wrap to max
	mov	a,c			; load a with count (0-16)
	cpi	16d
	jm	cursor_exit	; if < 16 store and exit
					
cursor_left2:				; decrement a and exit
	dcr	a			

cursor_exit:
	sta	CURSOR
	ret 	


;-------------------------------------------------------------------
increment_type:				
	lda	TYPE			; 00=RAM 01=ROM 10=OS 11 = SYS

	inr	a			; increment it
	ani	00000011b		; and with 00000011b (wrap it)

	sta	TYPE
	jmp	menu_loop1


;-----------------------------------------------------------------------------
get_freeblock_status:


					; COUNT (A of TYPE) updated
	lda	SUFLAG
	ani	11111101b		; turn off bit 2
	sta	SUFLAG			; indicate if there is space for a new image

	mvi	a,30d
	sub	b			; if less than 2 free, we have a problem.
	mov	e,a			; e holds free blocks count
	sta	FREE			; update free blocks counter

	push	psw
	cz	no_free_blocks_setflag
	pop	psw
	cm	no_free_blocks_setflag	; set SUFLAG = 1 - no space

	ret


;-------------------------------------------------------------------
menu_function_key_pressed:
; evaluate the function key action requested, based on mode.
; entry with a = function key number

				; sys mode=2
				; load mode=1
				; save mode=0

	ora	a		; fn key 1
	jz	display_help

	push	psw		; temp store fn key result

	lda	DSTATE
	ani	00000011b
	cpi 	03h
	jz	fn_key_sys

	lda	DSTATE
	ani	00000100b	; set if load mode, 1

	jz	fn_key_mode0	; not set, save mode, 0


fn_key_mode1:		; LOAD
	pop	psw		; restore fn key result

	dcr	a		; fn key 2
	jz	Load_image_common	
	
	dcr	a		;3

fn_key_skip4:
	dcr	a		;4
	dcr	a		;5
;	dcr	a		;6
	
	jmp	fn_key7



fn_key_sys:
	pop	psw
	
	dcr	a		; fn key 2
	jz	Load_image_sysmenu	
	
	dcr	a		; fn key 3
	jz	Use_mainrom	

	jmp	fn_key_skip4


fn_key_mode0:		: SAVE COPY KILL NAME FILE
	pop	psw		; restore fn key result

	dcr	a		; fn key 2
	jz	Save_image	
	
	dcr	a		; 3
	jz	Copy_image

	mov	b,a
	call	is_active
	mov	a,b
	jz	skip_kill

	dcr	a		; 4
	jz	Kill_image
	inr	a

skip_kill:
	dcr	a
	dcr	a		; 5
	jz	Name_image

	mov	b,a
	lda	TYPE
	ora	a
	mov	a,b
	jnz	skip_file

	dcr	a		; 6
	jz	ramfile_manager		; add in later, will be larger than 16k
	inr	a

skip_file:
fn_key7:
	dcr	a
	dcr	a		; 7
	jz	de_install_REX

	dcr	a		; 8
	jz	quit			; quit with a hooks table rebuld
					; HKFLAG controls hook table rebuild
					; unchanged at this point

	jmp	menu_loop3		; must have pressed some other key, so loop back
	

;---------------------------------------------------------------------------------
get_cursor_position:
					; c holds position
	lda	CURSL
	cpi	ramcursor_length	

	mov	a,c			; get count, 0-15

	jz	ramfile_get_position	; go here to get position if ramfile in use
	

;---------------------------------------------------------------------------------
display_get_position:			; get position from location in c for display
					; return row column in hl

					; each line is 4*6 + 3*4, with 2 spaces on each side
					; SSXXXXXXYSSSXXXXXXYSSSXXXXXXYSSSXXXXXXYS
					; row 3-6, column 3,13,23,33
					; entry is 6 characters + 1 character
					; 4 lines total = 16 entries

	mov	a,c
	ani	00001100b		; line indicator in bits 2 and 3
	rrc
	rrc
#if modeltype = 0			; M100
	adi	03d			; add 3 to offset to 3rd line (range 3-6)
#else					; T200
	adi	07d			; add 7 to offset to 3rd line (range 7-11)
#endif	

	mov	l,a			; store row number in l

	mov	a,c
	ani	00000011b		; column number 0-3

	mov	h,a
	mvi	a,249d
display_get_position1:
	adi	10d
	dcr	h
	jp	display_get_position1
					; 3,13,23,33
	mov	h,a			; hl = column, row - matches posit
	ret




;--------------------------------------------------------------------
; copy block in a to FREBLK
; updates directory
;--------------------------------------------------------------------
Copy_image:
cpyblk:
	call	check_flash_ready
	call	check_free_block		; check if there is space
	lda	FREBLK
	call	check_blank
	call	check_count

	lxi	h, msg01
	call	RPBMSG

	lda	CURBLK
	mov	b,a
	lda	FREBLK
	mov	c,a
	ori	01h		; reset zero bit
	call	copy_block	; copy from CURBLK to FREBLK


	jmp 	menu_loop0	; loop back
;-------------------------------------------------------------------
; copy_block subroutine
; copy block from b to c
; make new directory entry as well
; entry with zero flag set = preserve date/time, not set, new date/time

copy_block:
	push	psw			; store flags
	push	b			; temp store

	call	copyblock_function	; copy from b to c

	call	is_name_directory_full
	cz	refresh_directories

	pop	b			; reload source target
	mov	a,b
	call	find_directory_entryA	; get the address of the current block directory entry
	push	h			; store directory pointer on stack
	call	read_directory_lastb	; update lastb

	pop	h
	inx	h
	pop	psw			; restore flags
	jz	copy_freblk_entry	; do this one if zero set on entry
	jmp	write_freblk_entry	; do this one if not zero on entry

;--------------------------------------------------------------------
copyblock_function:
	push	b
	call	clsbar

	call	I_BARS
	call	GEN_1			; set up bar indicator

	call	I_CPYBLK

#if real_hardware = 1

	pop	b
					; set source
					; set target
	push	d
	lxi	d, 08000h		; de = end start
	call	GEN_1			; copy from b to c
	pop	d
#endif
	ret

;--------------------------------------------------------------------
; erase block 
; enter with CURBLK = block to erase
; if not ready, display error message and return
; this routine no longer "kills" the block, it just marks the directory entry
;--------------------------------------------------------------------

Kill_image:				; enter with CURBLK = block to erase
					; can't kill active blocks

	lxi	h,msge5
	call	RPBMSGYN

	jnz	menu_loop1b		; return to menu loop if not Y

	call	check_flash_ready

	lxi	h,msg03
	call	RPBMSG

	lda	CURBLK
	call	find_directory_entryA
	call	kill_directory_entry		; makes an A entry a U entry
	
	jmp	menu_loop0		; done

;-----------------------------------------------------------------------
Name_image:				; name the current block
					; CURBLK holds block to be named or renamed
					; find name in directory, and erase if present
					; get the new name
	
					; write to directory
	call	get_name_common
					; entry with hl pointing to start of 6 byte name location on screen, formatted for POSIT
					; store 6 byte name at INPUT_BUFFER, F685 is first character of name
					; if escape hit then set zero bit
					; if successful, reset zero bit
					; enter with hl = col,row

	jz	menu_loop1b		; if escape hit, then bail out (no cursor change)

	call	check_flash_ready

	lda	CURBLK
	call	find_directory_entryA
	push 	h

	lxi	d,07h
	dad	d
	mov	a,m	
	sta	LASTB			; store last byte

	pop	h
	push	h			; store pointer to original entry
	call	blank_directory_entry	; blank this directory entry
		
	call	is_name_directory_full
	cz	refresh_directories	; if end of record then we must rebuild the directories

	mvi	a,0FFh
	call	find_directory_entry	; get hl = open slot location

	push	h			; h = location for new record
	lda	CURBLK
	call	write_directory_block	; entry 	hl = pointer to directory entry, a = block number
					; exit 		none, block written

	lxi	h,INPUT_BUFFER		; get pointer to 6 byte name		
	xchg				; d points to first character

	pop	h			; hl holds new record location, de holds pointer to text		
	push	h
	call	write_directory_name	; write name bytes

	pop	h
	push	h
	call	write_directory_lastb	; write lastb

	pop	h			; hl = new record location
	pop	d			; de = old record location

	lxi	b,08d
	dad	b
	xchg
	dad	b
	xchg				; hl and de advanced 8 bytes

	mvi	b,04d

name_data_loop:				; copy 4 bytes of date and time
	ldax	d			; load a with source data
	push	b
	push	d
	call	double_byte_poke	; store in new record
	pop	d
	pop	b
	inx	h
	inx	d			; advance de, hl
	dcr	b			; count down
	jnz	name_data_loop
	
	call	fix_input_buffer

	jmp	menu_loop0		; return to menu loop

;----------------------------------------------------------------------	
get_name_common:
	lxi	h,msg04
	call	RPBMSG

#if modeltype = 0			; M100
	lxi	h,0C08h
#else					; T200
	lxi	h,0C0Ch
#endif
	call	get_6_byte_name		; entry with hl pointing to start of 6 byte name location on screen, formatted for POSIT
					; store 6 byte name at INPUT_BUFFER, F685 is first character of name
					; if escape hit then set zero bit
					; if successful, reset zero bit
					; enter with hl = col,row
	ret
;----------------------------------------------------------------------
display_checksum:			; calculate curblk checksum and display

	lda	CURBLK
	cpi	0ffh
	jz	menu_loop2

	lxi	h,msg10
	call	RPBMSG			; display message

	call	I_CHKSUM

	lda	CURBLK
	lxi	d, 08000h		; de = end start
	call	chksum_calc

	lxi	h,msg11
	call	RPBUF

	call	hit_any_key

	jmp	menu_loop1b


;--------------------------------------------------------------------

cursor_select:
evaluate_enter_key:
; type RAM
; enter (actram) - store RAM to actram, return to menu
; enter (not actram) - backup RAM to actram, install RAM from entry, new ACTRAM, exit
; enter (blank)	- backup RAM to new block, ACTRAM=NEWBLOCK, return to menu
; type ROM and OS
; enter (actopt) - do nothing (new!)
; enter (not actopt) - install new ROM and start new ROM
; enter (blank) - do nothing

	lda	TYPE
	cpi	00h		 	;00=ramimage, 01=romimage, 10=bootimage, 11=system
	jz	enter_type_is_RAM
	cpi	03h
	jz	menu_loop1b		; loop back if system type
;--------------------------------------------------------------------------	
enter_type_is_ROM_OS:			; figure out what to do
	
	lda	CURBLK
	cpi	0FFh
	jz	menu_loop2		; return if blank - do nothing

	lda	CURBLK
	mov	b,a
	lda	ACTOPT
	cmp	b
	jz	reactivate_rom		; if CURBLK = ACTOPT then reactivate

					; must be a valid rom
	lxi	h,msge4
	call	RPBMSGYN

	jnz	menu_loop1b		; return to menu loop if not Y
	
	rst	6
	.dw	LCD			; print 'Y' at cursor

	lda	CURBLK
	sta	ACTOPT			; if not, set new ACTOPT
	
	call	update_actblk_directory	; make new directory entry


install_new_ROM:			; jump to here to remove existing rom and install new


	lda	HKFLAG			; get HKFLAG
	ora	a			; test for 1
	cnz	display_warning_rom	; if 1, must warn that hooks initialized

					; hook table already initialized, no restore of hooks
	call	remove_ROM		; remove traces of ROM from RAM

	jmp	activate_rom

;--------------------------------------------------------------------------
reactivate_rom:

	di
		
	lda	HKFLAG
	ora	a
	cnz	restore_hooks_table	; test HKFLAG for 1, if 1 then restore hooks



activate_rom:			; no need for warning on hooks restore, same optrom
	xra	a
	sta 	SUFLAG			; no particular reason
	sta	HKFLAG
	call	fix_input_buffer
	call	find_rom_call
	push 	h
	push 	psw
	di

	call	install_tmrhk	

					; install same rom, and exit to ROM
	call	I_ROMST
	pop	psw
	pop	h
	jmp	GEN_1		; we don't return from this--

;--------------------------------------------------------------------------
enter_type_is_RAM:			; figure out what to do

	lda	CURBLK
	cpi	0FFh			; compare CURBLK to FF
	jz	enter_RAM_blank		; if blank, then store fresh image

	mov	b,a
	lda	ACTRAM			; compare CURBLK to ACTRAM
	cmp	b
	jz	enter_actram		; refresh this


;--------------------------------------------------------------------------
enter_not_actram:			; backup RAM to ACTRAM
					; install RAM from CURBLK
					; ACTRAM=CURBLK
					; exit
					; "switching and exiting"
					; delete old ROM
					; (removed) install new ROM
	lxi	h,msge1
	call	RPBMSGYN

	jnz	menu_loop1b		; return to menu loop if not Y

	rst	6
	.dw	LCD			; print 'Y' at cursor

	call	refresh_backup		; make new ram backup
					; copy name entry to new entry for FREBLK
					; kill ACTRAM entry

	lda	FREBLK
	sta	ACTRAM

	call	update_actblk_directory
	
	lda	CURBLK
	call	FLASH_to_RAM		; install new RAM


	lda	CURBLK
	sta	ACTRAM			; new ACTRAM
	
	call	update_actblk_directory



;--------------------------------------------------------------------------
new_ram_loaded:

#if modeltype=1			; T200
	lxi	h, 0EEF5h	; point to memory location for active block
	mvi	m,00h		; set to 00h
				; if bank1 active, then this is correct
				; if bank2 or 3 active, then this is a don't care.
#endif


	lda	HKFLAG
	ora	a			; test HKFLAG, if 1 then we must warn

	cnz	display_warning_ram	; if not zero, display warning message.

	call	remove_ROM		; remove traces of ROM from RAM

	xra	a
	sta	HKFLAG			; new ram - no hooks restore
	
;	jmp	quit			; restart 

; must exit through REX_INSTALL in order to purge old REXMGR files.
	
	mvi	a,0FFh
	sta	SUFLAG
	
	rst	6
	.dw	CLS			; clear screen, in case files need reinstallation

	jmp	REX_RAM_INSTALL
	

;--------------------------------------------------------------------------
enter_actram:				; backup RAM to ACTRAM
					; return to menu
					; refrest or revert

enter_actram_refresh:		
	lxi	h,msge2
	call	RPBMSGYN

	jnz	enter_actram_revert	; revert?

	rst	6			; execute refresh
	.dw	LCD			; print 'Y' at cursor

	call	refresh_backup		; make new ram backup
					; copy name entry to new entry for FREBLK
					; kill ACTRAM entry

	lda	FREBLK
	sta	ACTRAM

	call	update_actblk_directory

	jmp	menu_loop0


enter_actram_revert:
	lxi	h,msge6
	call	RPBMSGYN

	jnz	menu_loop1b		; return to menu loop

	rst	6			; execute revert
	.dw	LCD			; print 'Y' at cursor


	lda	CURBLK
	call	FLASH_to_RAM		; install new RAM
	

	jmp	new_ram_loaded




;--------------------------------------------------------------------------

enter_RAM_blank:			; backup RAM to fresh entry
					; ACTRAM = new entry
					; get name for new entry
					; return to menu
					; "creating new backup..."

	call	check_free_block

	lxi	h,msge3
	call	RPBMSGYN

	jnz	menu_loop1b		; return to menu loop if no

	rst	6
	.dw	LCD			; print 'Y' at cursor
	
	lxi	h,msg04
	call	RPBMSG

#if modeltype = 0			; M100
	lxi	h,0C08h
#else					; T200
	lxi	h,0C0Ch
#endif

	call	get_6_byte_name
					; entry with hl pointing to start of 6 byte name location on screen, formatted for POSIT
					; store 6 byte name at INPUT_BUFFER, F685 is first character of name
					; if escape hit then set zero bit
					; if successful, reset zero bit
					; enter with hl = col,row
	jz	menu_loop1b		; if escape hit, then bail out (no cursor change)

	lxi	h,INPUT_BUFFER

	call	backup_ram		; copy RAM to FREBLK
					; move name entry to new entry for FREBLK
					; enter with hl pointing to name text

	lda	FREBLK
	sta	ACTRAM

	call	update_actblk_directory	; new routine to update the ACTBLK directory			

	call	fix_input_buffer
	jmp	menu_loop00
	



;--------------------------------------------------------------------------
refresh_backup:				; make new ram backup
					; copy name entry to new entry for FREBLK
					; kill ACTRAM entry
					
	lda	ACTRAM
	call	find_directory_entryA
	push	h

	inx	h
	call	backup_ram		; copy RAM to FREBLK
					; move name entry to new entry for FREBLK
					; enter with hl pointing to name text
	pop	h
	call	kill_directory_entry	; mark existing as killed - mark old actram as U

	ret



;--------------------------------------------------------------------------
; message text

msge1:	.db	"Switch and exit",00h
msge2:	.db	"Refresh backup",00h
msge3:	.db	"Create new backup",00h
msge4:	.db	"Install ROM", 00h
msge5:	.db	"Kill image",00h
msge6:	.db	"Revert to backup",00h

msg01:	.db	"Copying image...",000h
msg02:	.db	"Rebuilding directories...",000h
msg03:	.db	"Killing image...",000h
msg04:	.db	"New Name ? ",000h
	

msg10:	.db	"16 bit checksum = ",00h
msg11:	.db	"  <any key>...",00h



;------------------------------------------------------
is_active:			; return with zero bit set = active
				; zero bit reset = not active

	lda	CURBLK		; figure out if block is active

is_a_active:
	push	b
	mov	b,a		; block number  in b
	
	lda	ACTOPT		; cursor in a
	cmp	b		; compare to count
	jz	exit_here

	lda	ACTRAM		; cursor in a
	cmp	b		; compare to count

exit_here:
	pop	b
	ret


;-----------------------------------------------------------------
backup_ram:			; copy RAM to FREBLK
				; move name entry to new entry for FREBLK
				; enter with hl pointing to name text
	
	push	h			
	call	RAM_to_FLASH		; copy current RAM to FREBLK, refreshing it
					; no directory updates
	pop	h
	xra	a
	sta	LASTB
	call	write_freblk_entry	; enter with hl pointing to entry with name text
					; assumes LASTB is updated
	ret


;-------------------------------------------------------------------

scan_for_BB:				; find a BB pair 
					; garbage collection routine
					; assumes a valid directory scan is in place!
					; copies kill the directory scan....
					; return not zero if there is an error
scan_BB:	


	mvi	a,0FFH
	sta	FREBLK			; since looking for a new free block, reset FREBLK

	lxi	d,0000h
	call	search_sector	

	jnz	scan_UU			; jump to look for a free UU pair to erase
	
	mov	a,c
	ani	11111110b		; just to be safe, always pick even block number
	sta	FREBLK			; we found a blank pair

	; precautionary blank checks...
;	call	check_blank		; if not blank, then restart
;	rnz

;	lda	FREBLK
;	xri	00000001b
;	call	check_blank		; if not blank, then restart

;	call	quick_scan_directory

	ret				; success
					; zero set, ok, zero reset, error


scan_UU:
	lxi	d,4040h			; 64d, 64d
	call	search_sector
	jnz	scan_BU			; if not found look for BU
	jmp	scan_erase_repeat	; if found, erase and repeat

scan_BU:				; look for a BU combination
	lxi	d,0040h
	call	search_sector
	jnz	scan_XA			; if no single U then scan XA
	
scan_erase_repeat:			; if found, erase and repeat
	mov	a,c
	call	erase_pair
	jmp	search_sector_repeat	; repeat


scan_XA:				; there are no UU or BB pairs
					; there are no UB pairs
					; scan for single B
					; then look for a single A in a different block

	lxi	d,0C000h		; look for a BA pair
	call	search_sector

	jnz	search_sector_error	; if we don't find at least one single, problem!

					; found a B			
	mov	a,c			; c points B
	sta	FREBLK
					; now look for a UA or BA
	lxi	d,040C0h		; look for AU
	call	search_sector

	jz	search_XA_foundA

	lxi	d,000C0h			; now search for AB pair (excluding B found previously)
	call	search_sector

	jnz	search_sector_error


search_XA_foundA:			; we found an A to copy away
					; c holds source A
	push 	psw
	push	b

	mov	b,c

	lda	FREBLK
	mov	c,a
	xra	a			; set zero flag

	call	copy_block		; copy block in source to FREBLK

	pop	b
	push	b
	mov 	a,c

	call	erase_pair		; erase block in a
	pop	b
	pop	psw


scan_XA_test_ACTRAM:
	lda	ACTRAM
	cmp	c
	jnz	scan_XA_test_ACTOPT

	lda	FREBLK
	sta	ACTRAM			; correct ACTRAM
	call	update_actblk_directory

	jmp	search_sector_repeat	; repeat


scan_XA_test_ACTOPT:
	lda	ACTOPT
	cmp	c
	jnz	search_sector_repeat	; repeat

	lda	FREBLK
	sta	ACTOPT			; correct ACTOPT
	call	update_actblk_directory


search_sector_repeat:

	call	quick_scan_directory		; call this for a fast scan
	jmp	scan_for_BB


;----------------------------------------------------------------------------------
erase_pair:					; enter with a= block to erase
						; both must be U or B, not A
	push	psw
	call	erase_block_a			; erase block in a

	pop	psw				; erase_first
	push	psw
	call	erase_entry

	pop	psw				; erase_second
	xri	00000001b

erase_entry:
	call	find_directory_entry		; hl points to directory entry
; entry 	a = block number to be searched for
; exit 		hl = pointer to directory entry (or potentially end of record) (or free entry)
; 		zero set if found, zero not set if not found
	rnz					; return if not found
	call	blank_directory_entry		; blank the entries
	ret


;-----------------------------------------------------------------------------
search_sector_error:
	lxi	h,msgsse
	jmp 	no_free_blocks_common
;-----------------------------------------------------------------------------
no_free_blocks_error:
	lxi	h,msgnoB
;	jmp	no_free_blocks_common
;-----------------------------------------------------------------------------
no_free_blocks_common:
	call	RPBMSG
	call	DELAY

no_free_blocks_setflag:
	lda	SUFLAG
	ori	00000010b	; turn on bit 1 - no space available
	sta	SUFLAG
	ret			; loop back

msgnoB:	.db	"No free blocks!",00d
msgsse:	.db	"Can't find a blank sector!",00d

;------------------------------------------------------------------------	
display_free_blocks:		; enter with FREE updated.

#if modeltype = 0			; M100
	lxi	d,2101h
#else					; T200
 	lxi	d,2105h
#endif
	lxi	h,Freetxt
	call	RPB00

	lda	FREE
	ora	a
	rm			; don't display if a negative number

	call	display_which_block
	jmp	esc_K

Freetxt:.db	"Free:"
	.db	00
;------------------------------------------------------------------------
display_block_info:	
	lda	SUFLAG
	ani	00000100b		; test for zero in bit 2
	rz				; return if not on

#if modeltype = 0			; M100
	lxi	d, 0107h
#else					; T200
	lxi	d, 010Bh
#endif

	lxi	h,F
	call	RPB00

	lda	FREBLK
	call	display_which_block


;------------------------------------------------------------------------
display_current_block:	

	lxi	h,C
	call	RPBUF

	lda	CURBLK
	call	display_which_block

	lxi	h,b3
	jmp	RPBUF


;------------------------------------------------------------------------
display_which_block:
	mov	l,a
	mvi	h,00h
	rst	6
	.dw	NUMPRT	
	ret
;------------------------------------------------------------------------
F:	.db	"F:"
	.db	00
C:	.db	" C:"
	.db	00


;------------------------------------------------------------------------
display_group_type:		

#if modeltype = 0			; M100
	lxi	d, 0D01h
#else					; T200
	lxi	d, 0D05h
#endif

	lxi	h,grp
	call	RPB00

	lxi	h,display_type_text

	lda	TYPE
	rlc
	rlc
	mvi	d,00h
	mov	e,a
	dad	d
	
	call	RPBUF
	ret

grp:	.db	"Group<TAB>:"
	.db	00
;-------------------------------------------------------------------------------


display_directory_entries:
					; show all image entries of type in DISPLAY
					; start at beginning of table, display entries of specific type
					; for each one found that is of type, display, count
					; if <16 then last one is a ------ entry
					; display - lower 2 bits is type, next 2 bits is mode, upper 4 bits is count

					; table created at GEN_1+32d (64 bytes) with pointers to 
					; directory entries

					; print all 16 locations  - merge the sweep out with display


	mvi	c,0FFh			; position counter in table
					; index to entry table at GEN_1
display_entries1:
	inr	c

	lda	COUNT
	cmp	c			; compare c to COUNT
	jz	display_entries_lastchar	; if equal then done

	lxi	h,GEN_1+96d

	push	b
	mvi	b,00h
	dad	b
	mov	a,m			; get block number to display
	pop	b

	lxi	h,GEN_1+32d
	push	b			; temp store bc
	add	a			
	mov	c,a			; c=a*2
	mvi	b,00h			; set b = 0
	dad	b			; hl = address of table entry
	pop	b			; restore bc

	xchg				; de = pointer to table entry 
	lhlx				; load hl with address of directory entry


	mov	a,m			; get block number
	ani	00111111b
	push	psw			; temp store block number

	inx	h			; hl points to start of name text
	push	b
	push	h
					; counter in c
					; position is 0-15
	call	display_get_position	; get position from count for display
					; return row column in hl

	rst	6
	.dw	POSIT
	pop	h
	pop	b

	mvi	d,06h
	call	print_d

	pop	psw			; get back block number
	call	is_a_active		; return with zero bit set = active
					; zero bit reset = not active
	jz	display_star

	mvi	a,' '
	jmp	display_space

display_star:				; display a * if entry = ACTOPT
	mvi	a,'*'
display_space:
	rst	6
	.dw	LCD
	jmp	display_entries1


display_entries_lastchar:
	lda	TYPE
	cpi	03h
	lda	COUNT
	jz	sweep_entries		; if type is SYS then done, don't print the last entry

;	lda	COUNT
	cpi	016d
	rp				; if >= 16 then done

	mov	c,a
	call  	display_get_position	; set hl for POSIT based on value of COUNT
	rst	6
	.dw	POSIT			; set the cursor location

	lxi	h, blank_entry_text	; print ------
	call	RPBUF
	
	lda	COUNT
	cpi	015d
	rp				; done if count was 15
					; if 14 or less, need to sweep still
	inr	a			; add 1 to a

sweep_entries:				; a holds corrected count

	mov	c,a

	mvi	a,16d
	sub	c
	mov	b,a			; b holds number of loops to sweep out the old entries
					; b+c = 16
					; c holds postion
sweep_entries_loop:
	mov	a,b
	ora	a
	rz				; done if b is zero

	push	b
	call  	display_get_position	; set hl for POSIT based on value of c
	rst	6
	.dw	POSIT			; set the cursor location

	lxi	h, b7			; print 7 spaces
	call	RPBUF
	
	pop	b
	dcr	b
	inr	c

	jmp	sweep_entries_loop

b15:	.db	"    "
b11:	.db	"   "
b8:	.db	" "
b7:	.db	" "
b6:	.db	" "
b5:	.db	"  "
b3:	.db	"   ",00h

blank_entry_text:
	.db	"------ ",00h


;--------------------------------------------------------------------------

display_enter_text:		; entry with type valid, and CURBLK updated
				; types 00=RAM 01=ROM 10=OS 11 = SYS

#if modeltype = 0			; M100
	lxi	d,0102h		; row 2 column 1
#else					; T200
	lxi	d,0106h		; row 6 column 1
#endif

	lda	TYPE
	cpi	03h
	jz	sysenter_text
	
	lda	SUFLAG
	ani	00010000b		; test bit 4
	jnz	display_enter_cont	; return jump ahead if on

	lda	ODSTATE
	ani	00000011b
	cpi	03h
	jz	cls_enter		; clear enter line if the old type was SYS, and off
	ret				; otherwise done

display_enter_cont:
	lda	TYPE
	ora	a
	jz	display_enter_text_ram



display_enter_text_rom_os:

	lda	CURBLK
	inr	a
	jz	cls_enter			; if CURBLK = FF, then clear line 2

	call	display_enter_line		; print this every time otherwise

	call	is_active			; return with zero bit set = active
						; zero bit reset = not active
	lxi	h,ent2				; if CURBLK = ACTOPT, then print this
	jz	print_enter_text	

	lxi	h,ent1				; else print this
	jmp	print_enter_text


display_enter_text_ram:
	call	display_enter_line		; print this every time

	lda	CURBLK
	inr	a
	lxi	h,ent5				; if CURBLK = FF print this
	jz	print_enter_text

	call	is_active			; return with zero bit set = active
						; zero bit reset = not active
	lxi	h,ent4				; if CURBLK = ACTRAM print this
	jz	print_enter_text

	lxi	h,ent3				; block is not active - refresh and switch


print_enter_text:
	call	RPBUF
	jmp	esc_K


display_enter_line:
	lxi	h,entf
	jmp	RPB00



sysenter_text:		; display test in row 2

	lda 	CURBLK
	call	sysenter2
	call	RPB00		; print from hl with de holding cursor location
	jmp	esc_K


sysenter2:
	lxi	h,sys2
	dcr	a
	dcr	a
	rz
sysenter3:
	lxi	h,sys3
	dcr	a
	rz
sysenter4:
	lxi	h,sys4
	dcr	a
	rz
sysenter5:
	lxi	h,sys5
	ret


	
sys2:	.db	"Primary Main ROM 0000-7FFF",00h
sys3:	.db	"Primary Main ROM 8000-9FFF (T200)",00h
sys4:	.db	"Secondary Main ROM 0000-7FFF",00h
sys5:	.db	"Secondary Main ROM 8000-9FFF (T200)",00h

ent1:	.db	"Switch OPTROM image",00d
ent2:	.db	"Reactivate OPTROM",00d
ent3:	.db	"Refresh and switch",00d
ent4:	.db	"Refresh or revert",00d
ent5:	.db	"Create new backup",00d

entf:	.db	"<ENTER>:",00h



;-----------------------------------------------------------------------
; start up SYSTEM to SYSBAK directory comparison only
; compare directory blocks only
; compare checksums


syscheck:
				; get checksums from directories in block 0 and 1 - compare directories
				; if not equal, choose which directory to keep
				;	- keep main directory
				; 	- keep backup dir - copy 1dir to 0dir
				; get checksums from bottom 32k in block 0 and 1
				; if different, copy 0 to 1


	call	I_CHKSUM

syscheck_testdir:

	xra	a
	lxi	d, 06040h	; de = end start
	push	d
	call	GEN_1		; de holds 0sw checksum

	xchg			; checksum in hl
	xthl			; temp store checksum, hl = end/start
	
	mvi	a,01h
	xchg			; de = end start
	call	GEN_1		; de holds 1sw checksum
	
	pop	h		; get hl from stack


	RST	6
	.dw	0018h		; compare the two checksums

	rz

;	jnz	syscheck_diractions




syscheck_diractions:		; choose which directory to keep
				;	- keep main directory - leave bit 1 = 1
				; 	- keep backup dir - copy 1dir to 0dir, set bit 1 = 0

	lxi	h,dirdif
	call	RPBUFCR

syscheck_diractions1:
	lxi	h,keepd
	call	RPBUFYN		; answer is yes or no

	mov	b,a		; store answer
	push	b
	
	rst	6
	.dw	LCD		; print response

	call	RPBCRLF

	lxi	h,sure
	call	RPBUFYN

	push	psw		; store answer

	rst	6
	.dw	LCD

	call	RPBCRLF

	pop	psw		; get back answer

	pop	b		; get back answer
	mov	a,b		; set answer in a

	jnz	syscheck_diractions1	; if confirm Y, then answer valid, continue
					; if unsure try again.


	cpi	'Y'		; compare choice to if Y, then we want to keep current dir
	jz	syscheck_copy0to1
				; answer was N, we are reverting to old directory
	lxi	h,cpy1
	call	RPBUFCR

	lxi	h,04000h
	xra	a
	call	erase_block	; erase directory block

	call	I_BARS
	call	GEN_1		; set up bar indicator

	call	I_CPYBLK

	lxi	d,06040h
	lxi	b,00100h	; b = 01, c = 00
	call	GEN_1		; copy block from b to c

	jmp	syscheck_copysysbak

syscheck_copy0to1:		; main directory is now the keeper

	lxi	h,keepm
	call	RPBUFK

syscheck_copysysbak:

	mvi	a,01h
	sta	FREBLK
	call	erb0		; erase block 1

	call	I_BARS
	call	GEN_1		; set up bar indicator

	call	I_CPYBLK	; copy block from b to c

	lxi	b,0001h		; b = 00 c = 01
	lxi	d, 08000h	; de = end start
	jmp	GEN_1		; copy SYSTEM to SYSBAK

				; we did a system copy

;--------------------------------------------------------------
dirdif:	.db	"Directories are different."
	.db 	00
keepd:	.db	"Keep main (block 0) directory"
	.db	00h
sure:	.db	"SURE"
	.db	00d
cpy1:	.db	"Copy backup directory to main...."
	.db 	00h
keepm:	.db	"Copy main directory to backup...."
	.db 	00h	

;-----------------------------------------------------------------------
show_REX_info:			; display model, firmware codes
				; REX model = REX or REX2 (top 2 bits)
				; firmware 1 = number 0-15 (middle 4 bits)
				; firmware 2 = number 0-3 (bottom 2 bits)

	rst	6
	.dw	CLS

#if real_hardware = 1 
	call	I_STV
	call	GEN_1
					; STV
					; get status and version byte
					; firmware byte in c, status in b
#else
	mvi	c,01000111b
#endif

	push	b

#if modeltype = 0			; M100
	lxi	d,0202h
#else					; T200
	lxi	d,0206h
#endif
	lxi	h,rexsw
	call	RPB00


	call	I_CHKSUM		; display system rom checksum

	xra	a
	lxi	d, 04000h		; de = end start
	call	chksum_calc


#if modeltype = 0			; M100
	lxi	d,0203h
#else					; T200
	lxi	d,0207h
#endif
	lxi	h,rexmod
	call	RPB00


	pop	b
	push	b
	mov	a,c
	ani	11000000b
	
	jz	model_is_REX
	
	lxi	h,REX2


	jmp	show_REX_info1

model_is_REX:
		
	lxi	h,REX


show_REX_info1:
	call	RPBUF


#if modeltype = 0			; M100
	lxi	d,0204h
#else					; T200
	lxi	d,0208h
#endif
	lxi	h,rexfw
	call	RPB00


	pop	b
	push	b

	mov	a,c
	ani	00111100b

	rrc
	rrc

	mvi	h,00h
	mov	l,a
	
	rst	6
	.dw	NUMPRT			; print number in HL at cursor

	mvi	a,'('
	rst	6
	.dw 	LCD

	pop	b
	push	b

	mov	a,c
	ani	00000011b

	mvi	h,00h
	mov	l,a
	
	rst	6
	.dw	NUMPRT			; print number in HL at cursor

	mvi	a,')'
	rst	6
	.dw 	LCD

	pop	b

	lxi	h,msg11
	call	RPBMSG

	call	hit_any_key

	jmp	display_acknowledgements
	


rexsw:	.db	"Software :",version,", CS="
	.db	00
rexmod:	.db	"Model    :"
	.db	00h
rexfw:	.db	"Firmware :"
	.db	00h




;-----------------------------------------------------------------------
test_rom_mode:				; discover if REX is controlling main rom
					; set bit 5 if rex is in control
					; reset bit 5 if rex is not in control
	
	call	I_TESTROM
	call	GEN_1

	jnz	REX_no_control		; not zero, not equal, no control

REX_control:				; 0004-0006 = "enu" so REX is in control

	lda	SUFLAG
	ori	00100000b		; turn on bit 5
	jmp	test_rom_mode_done

REX_no_control:
	lda	SUFLAG
	ani	11011111b

test_rom_mode_done:
	sta	SUFLAG
	ret


;-----------------------------------------------------------------------
display_rom_mode:			; display a character at position 9
					; according to REX status
#if modeltype = 0			; M100
	lxi	h,0901h
#else					; T200
	lxi	h,0905h
#endif

	rst	6
	.dw	POSIT
	
	call	reverse_video

	lda	SUFLAG
	ani	00100000b		; test bit 5
	
	jnz	display_rom_mode1	; if not zero then REX is in control

					; REX is not in control'

	mvi	a,'M'
	jmp	display_rom_mode2
	
	
display_rom_mode1:
					; test to see what the status of REX is
	lda	ROMSEL			; get value of ROMSEL
	ani	01000000b		; get rom select indicator
	jz	display_primary

	mvi	a,'S'			; display an S
	jmp	display_rom_mode2
	
display_primary:
	mvi	a,'P'			; display a P

display_rom_mode2:
	rst	6
	.dw	LCD			; display reverse character

	call	normal_video
	ret


;----------------------------------------------------------------------------------

Use_mainrom:		; enter with CURBLK = rom to select

	call	clsr7
	lda	CURBLK
	cpi 	02d
	jz	use_continue

	cpi	04d		; only USE when block 2 or 4 (ignore 3 or 5)
	jnz	menu_loop1b
	

use_continue:

	call	check_rex_control
	jz	menu_loop1b		; if REX not in control then don't switch
					; REX can switch the ROM
	call	check_is_rom_in_use
	jz	menu_loop1b		; if rom is already in use then don't switch to it

					; current rom is not in use


	lxi	h,swi
	call	RPBMSG

	lda	CURBLK
	cpi	02d
	jz	select_primary

	lxi	h,sec
	jmp	select_continue

select_primary:
	lxi	h,pri

select_continue:	
	call	RPBUF

	lxi	h,sure
	call	RPBUFYN


	jnz	menu_loop1b	; restart menu if N

				; ok, switch it.
	lda	CURBLK		; 2 or 4
	rrc			; 1 or 2
	dcr	a		; 0 or 1
	ani	00000001b	; ensure just 1 bit is on.
	
	rrc
	rrc			; bit 6
	sta	ROMSEL		; change state of ROMSEL

	call	update_actblk_directory		; update actblk directory

; now we must update the current active optrom/active RAM record.
; we need to update the routines that manage this


	jmp	menu_loop0
	
swi:	.db	"Switching to "
	.db	00
sec:	.db	"Secondary..."
	.db	00h
pri:	.db	"Primary..."
	.db	00h
	
;----------------------------------------------------------------------------------
Load_image_sysmenu:			; CURBLK indicates target
					; FREBLK indicates free block pair

					; if rex not in control, the load whichever
					; if rex is in control, then load only secondary

	lda	SUFLAG
	ani	00100000b
	jz	Load_image_common1		; if REX not in control then load either

					; REX is in control	
	lda 	CURBLK
	ani	00000010b		; see if CURBLK is 2 or 3	

	jz	Load_image_common1	; attempt to load a new image if not block 2 or 3
					; if successful, new image name will be entered

	lxi	h,noloadprimary
	call	check_rom_common_exit

	jz	menu_loop1b		; restart menu1 if rom in use

noloadprimary:
	.db	"REX Manager uses Primary as default.",00d
;----------------------------------------------------------------------------
get_block_cursor:		; find the block number under the cursor
				; exit with CURBLK updated and
				; hl pointing to directory entry

	lda	CURSOR		; cursor range 0-15
	mov	c,a
	lda	COUNT
	cmp	c
	jz	CURBLK_is_FF


	mvi	b,00h

	lxi	h,GEN_1+96d	; point to 3rd table
	dad	b

	mov	a,m
	sta	CURBLK		; CURBLK updated with what is under CURSOR

	rlc			; a = a*2
	mov	c,a		; b = 00
	lxi	h,GEN_1+32d
	dad	b		; hl points to directory entry for CURSOR

	xchg
	lhlx			; hl = address of directory entry

	ret

CURBLK_is_FF
	mvi	a,0FFh
	sta	CURBLK
	ret


;----------------------------------------------------------------------------------
check_rex_control:		; return not zero if rex in control
				; return zero if rex in control

	lda	SUFLAG
	ani	00100000b
	rnz			; return if bit 5=1 - rex is in control

	lxi	h,msgmm1

	jmp	check_rom_common_exit


msgmm1:	.db	"REX not configured to provide main rom.",00h

;----------------------------------------------------------------------------------
check_is_rom_in_use:		
				; return zero if rom in use
				; return not zero if rom not in use
	lda	CURBLK		; 2,3,4 or 5
	ani	00000110b	; 2 or 4
	rrc			; 1 or 2
	dcr	a		; 0 or 1
	rrc
	rrc			; place bit in bit 6 position	
	push	psw

	lda	ROMSEL
	ani	01000000b
	mov	b,a

	pop	psw

	cmp	b
	
	rnz				; return if not equal, switch ok

	lxi	h,msgmm2

check_rom_common_exit:
	call	RPBMSG

	call	DELAY

	xra	a			; set zero bit
	ret
	
msgmm2:	.db	"Main ROM in use!",00h

display_type_text:
RAM:	.db	"RAM",00d	; 00
	.db	"ROM",00d	; 01
	.db	"OS ",00d	; 10
	.db	"SYS",00d	; 11


;-----------------------------------------------------------------------
display_title:
	rst	6
	.dw	CLS


#if modeltype = 0			; M100
	lxi	d,0101h
#else					; T200
	lxi	d,0105h
#endif
	lxi	h,rexver
	call	RPB00

	ret

rexver:	.db	"REX",version
	.db	00h

;-----------------------------------------------------------------------
toggle_sort:
	lda	SUFLAG
	xri	00001000b
	sta	SUFLAG		; toggle bit 3

	jmp	menu_loop1

;-----------------------------------------------------------------------
toggle_showblock:
	push 	psw
	lda	SUFLAG
	xri	00000100b
	sta	SUFLAG		; toggle bit 2

	ani	00000100b
	push	psw
	cz	cls_blockinfo

	pop	psw
	cnz	display_block_info


	pop	psw
	ret

		

;-----------------------------------------------------------------------
toggle_showenter:
	push	psw
	lda	SUFLAG
	xri	00010000b
	sta	SUFLAG		; toggle bit 4

	ani	00010000b
	cz	cls_enter


	lda	DSTATE
	xri	00100000b	; toggle bit 5
	sta	DSTATE

	pop 	psw
	ret


;-------------------------------------------------------------------
blink_cursor:

	push	b

	push 	psw
	push	h
	push	d

	lda	OCURSOR
	mov	c,a
	lda	CURSOR
	cmp	c
	jz	no_blink_cursor

	push	b
	call	toggle_cursor
	pop	b
	mov	a,c
	call	toggle_cursor

no_blink_cursor:
	pop	d
	pop	h
	pop	psw
	pop	b
	ret




;-------------------------------------------------------------------
toggle_cursor:
				; enter with a = cursor location to toggle
				; [0..x] or [128..y]  mode bit
	mov	c,a

	call	get_cursor_position	; get position from count (reg c) for display
					; return row column in hl
					; detects ramfile menu or normal menu
	inr	h
	shld	CSRY		; store x and y cursor values l in y h in x

	lda	CURSL
	mov	b,a		; b holds cursor field length

	rst	6
#if modeltype = 0
	.dw	059EDH		; entry to intercept cursor draw routine
#else
	.dw	06D75H
#endif
	ret

;------------------------------------------------------------------------------------
update_date:				; update date/time

	lda	DSTATE
	ani	00000100b		; if load mode, set
	jnz	cls_date		; load mode, clear date and CURBLK
					; save mode or sys mode
refresh_date:
	push	h
	call	get_entry_date
	call	print_date

	pop	h
	call	get_entry_time
	jmp	print_time

	


;------------------------------------------------------------------------------
; change the display of date, function keys and enter text based on cursor
; - last state
; - mode
; - enter flag on/off

; states - 8 in total  lower 4 bits for current state, upper 4 bits for old state
;	RAM	active
;	RAM	normal
;	RAM	blank
;	ROM/OS	active
;	ROM/OS	normal
;	ROM/OS	blank
;	SYS	pri1,2
;	SYS	sec1,2

; bit 5 = show enter change state
; bit 4 = toggle enter text
; bit 3 = is 1 when active
; bit 2 = is 1 when CURBLK is FF
; bit 1/0 = type

;------------------------------------------------------------------------------
update_state:
	
	lda	DSTATE
	ani	00110000b	; preserve these bits
	mov 	c,a
	lda	TYPE
	push	psw		; temp store
	ani	00000011b
	ora	c
	mov	c,a
	lda	CURBLK
	cpi 	0FFh
	mov	a,c
	jnz	update_state_bit2off  ; if not FF, then turn bit off
	ori	00000100b
update_state_bit2off:
	mov	c,a
	call	is_active	; return with zero bit set = active
				; zero bit reset = not active
	mov	a,c
	jnz	update_state_bit3off
	ori	00001000b	; active, set bit
update_state_bit3off:
	mov	c,a
	pop	psw		;restore
	cpi	03h
	mov	a,c
	jnz	update_state_done
	xri	00010000b		; toggle bit 4
	ori	00000100b		; set bit 2, spoof load mode.
update_state_done:

	sta	DSTATE
	ret


;------------------------------------------------------------------------------
display_state:			; update enter text and fn keys based on state info
	
	lhld	DSTATE		; ODSTATE is adjacent, higher
	mov	a,l
	cmp	h
	rz			; if equal, return
				; not equal

	call	display_enter_text
	jmp	display_fn_keys



;------------------------------------------------------------------------------
display_fn_keys:

key1:

#if modeltype = 0			; M100
	lxi	h,0108h
#else					; T200
	lxi	h,010Ch
#endif
	rst	6
	.dw	POSIT

	lxi	h,fn1
	call	RPBUF

key2:					; bit 4 = toggle enter text
					; bit 3 = is 1 when active
					; bit 2 = is 1 when CURBLK is FF
					; bit 1/0 = type

	lda	DSTATE
	ani	00000100b	; bit is on if in load mode

	jz	key23		; jump to display save if mode = 0

	lxi	h,fn2		; load
	call	RPBUF

	lda	DSTATE
	ani	00000011b
	cpi	03h
	jz	key3		; if SYS type jump here

	lxi	h,b5		; mode = 1
	call	RPBUF

key4b:
	lxi	h,b5
	call	RPBUF
key5b:
	lxi	h,b5
	call	RPBUF
key6b:
	lxi	h,b5
	call	RPBUF
	
	jmp	key78

key3:	
	lxi	h,fn3
	call	RPBUF
	jmp	key4b

key23:	
	lxi	h,fn23
	call	RPBUF

	lda	DSTATE
	ani	00001000b	; is it active?
	
	jnz	key4a		; if bit set (active) the blank

key4:	
	lxi	h,fn4		; kill
	call	RPBUF

	jmp	key5

key4a:
	lxi	h,b5
	call	RPBUF

key5:	
	lxi	h,fn5
	call	RPBUF

key6:	lda	TYPE
	ora	a
	jnz	key6b		; only show FILE if RAM type.
	lxi	h,fn6
	call	RPBUF

key78:	
	lxi	h,fn78
	call	RPBUF

	ret

fn1:	.db	"Help ",00
fn2:	.db	"Load ",00
fn3:	.db	"Use  ",00
fn23:	.db	"Save "
fn3a:	.db	"Copy ",00
fn4:	.db	"Kill ",00
fn5:	.db	"Name ",00
fn6:	.db	"File ",00
fn78:	.db	"DeIn "
fn8:	.db	"Exit",00
ramfn6:	.db	"Size ",00

;----------------------------------------------------------------------