

#include        "T200rom_published_lib.asm"
#include        "T200rom_unpublished_lib.asm"



;-----------------------------------------------------------------------
; ROM start
;-----------------------------------------------------------------------
	.org	0000h

OPON:	.equ	0F4D3H

RST0:	di			; disable interrupts since boot process not complete
	jmp	adjust_lowram	; Entry point arrived at from interrupt if rexrom present
	.db	"REX!"		; signiture
RST1:	RET			;Not Used
	.DB	0,0,0,0,0,0,0
RST2:	RET			;Not Used
	.DB	0,0,0,0,0,0,0
RST3:	RET			;Not Used
	.DB	0,0,0,0,0,0,0
RST4:	RET			;Not Used
	.DB	0,0,0
TRAP:	DI
	CALL	INTCALL
RST5:	RET			;Not Used
	.DB	0,0,0
RST55:	DI
	CALL	INTCALL
RST6:	JMP	STDCALL		;RST 6 used as short call to a Standard ROM routine.
	.DB	0
RST65:	DI			;Replaces the 6.5 interrupt and sets up a call to 6.5 in Standard ROM
	CALL	INTCALL
RST7:	RET			;Not Used
	.DB	0,0,0
RST75:	DI			;Replaces the 7.5 interrupt and sets up a call to 7.5 in Standard ROM
	CALL 	INTCALL



	.org	0040h

OPONimg:
	PUSH	PSW		; T200 logic.
	mvi	a,2	
	OUT	0D8H
	POP	PSW
	RET

	.org	0048h

;---------------------------------------------------------
;The STDCALL routine allows a program running in the
;the Option ROM to call and return to an address in the
;Option ROM.
;Syntax is to use a RST 6 plus the address to be called.
;
; 		RST	6
; rvect-->	DW	04B44H  (cvect)
; pvect-->
;
;---------------------------------------------------------

STDCALL:			; 23 bytes
				; stack = rvect
	xthl
	inx 	h
	inx 	h
	xthl			; fix up first stack entry
				; stack = pvect
				; hl=hl'

	push	h			
	lxi 	h, OPON
	xthl			; stack = pvect, OPON
				; hl=hl'

	push 	h
	push 	d		; stack = pvect, OPON, hl', de'

	ldsi 	06h		; point de to stack location of return vector


	lhlx			; hl=pvect
	dcx 	h
	dcx 	h		; point hl=pvect-2
	xchg			; de=pvect-2
	lhlx			; hl=cvect

	pop 	d		; de=de'
	xthl			; hl=hl', stack= pvect, OPON, cvect

	jmp 	STDON


;---------------------------------------------------------
;Routine for the hardware traps.
;return address on entry is related to which interrupt occured.
; 
;		after interrupt occurs
; ivect		DI
;		call	INTCALL
; rvect -->
; so stack = pvect, rvect
;---------------------------------------------------------

INTCALL:			; final stack must be opon, introutine
				; interrupts are off
				; enter with return location on stack, indicating int routine
				; stack = pvect, rvect
				; 20 bytes
	push	h	
	push	d		; stack = pvect, rvect, hl', de'

	ldsi	04h

	lhlx			; hl= rvect

	dcx	h
	dcx	h
	dcx	h
	dcx	h		; hl = ivect

	push	h		; stack = pvect, rvect, hl', de', ivect

	lxi	h,OPON
	shlx			; stack = pvect, OPON, hl', de', ivect

	pop	h		; hl=ivect
	pop	d		; de=de'

	xthl			; stack = pvect, OPON, ivect
				; hl=hl', de=de'

	jmp	STDON



;---------------------------------------------------------
;STDON: Turns on Standard ROM
;---------------------------------------------------------

	.ORG	0082H
STDON:
	PUSH	PSW
	PUSH	H
	lxi	h,14E9H		; return here in T200
	XTHL
				; return to location pushed on stack
OPEXIT:
	IN	0D8h
	ani	00001100b
	OUT	0D8H
	RET			; RET can be found at 008EH in stdrom
				; in both M100 and T200



;---------------------------------------------------------
;REXEX1: exits REX software
;always with a restart
;restore hooks table to original on way out.
;---------------------------------------------------------

;	.org	0094h
EXIT:
REXEX1:
	push	h		; put hl on stack
	lxi	h,0000h		; restart rom
	xthl			; swap stack with hl, restoring hl		

	jmp	 STDON		; return to address on stack




;---------------------------------------------------------------------





adjust_lowram:				; enter with bc = desired size of LOWRAM
					; could be 0 or the length of a file
					; lowram could move up or down
					; assume it is safe to do so, interrupts off etc.

; enter with hl = 00 # of 256 byte blocks

	mov	d,l		; store size of hole required in de
	mvi	e,0

        LHLD 	LOWRAM		; lomem pointer

	lxi	b,0A000h
	push	b		; store A000 on stack

	dsub			; hl=hl-bc, hl is current size of lowram space

				; hl is current lowram space
				; de is desired lowram space

	rst	6
	.dw	0018h		; compare hl, de 


	jz	adjust_nochange

	push	psw		; store state   nc = hl>de, z = hl=de, c = hl < de

				; carry set when expansion
				; carry cleared when contraction

	jnc	adjust_lowram_noswap		; if current hole is larger than desired, go here
				; take this path if current hole is smaller than desired

	xchg			; swap hl and de, so larger is in hl
				; take this path when de>hl, expansion

adjust_lowram_noswap:		; hl > de

	mov	b,d
	mov	c,e		; hl > bc

	dsub			; hl = delta hole size

	mov	b,h
	mov	c,l		; bc = delta hole size

	pop	psw		; get back flags

	pop	h		; hl = A000
	

	push	b
	jnc	adjust_lowram_shrink	; carry set when expansion
					; carry cleared when contraction
	rst	6
 	.dw 	MAKHOL		; Make a hole of BC bytes at HL

	pop	b
	jmp	adjust_lowram_pointers

      
adjust_lowram_shrink: 
	rst	6
        .dw 	MASDEL		 ;Delete BC number if characters in a text file
    
	pop	b
	lxi	h,0000h
	dsub
	
	mov	b,h
	mov	c,l		; compliment of hole size



adjust_lowram_pointers:		; bc holds value to correct
	lhld 	ASCTAB		
        dad	B
        shld	ASCTAB		; correct ASCTAB
        
	lhld	LOWRAM
	dad	b
	shld	LOWRAM		; correct LOWRAM

        mov	a,h
	sui	0A0h
        STA 	0A000H

	rst	6
	.dw 	02C62h		; Fix up directory pointers

	jmp	EXIT
	
adjust_nochange:
	pop	b
	jmp	EXIT


	.end