
; help screens
; 6 lines of help, 1-6
; last line " press space to continue, esc to return

display_ramfile_help:
	lxi	h,ram1
	jmp	display_help_loop2

display_acknowledgements:
	lxi	h,ack1
	jmp	display_help_loop2

display_helpsys:
	lxi	h,sscr1		; load first pointer
	jmp	display_help_loop2

display_help:

	lda	TYPE
	cpi	03h
	jz	display_helpsys

	lxi	h,scr1		; load first pointer


display_help_loop2:		; next screen loop

	push	h
	call	clsr7



#if modeltype = 0 			; M100/T102
	lxi	h,0101h
#else					; T200
	lxi	h,0105h
#endif

	rst	6
	.dw	POSIT		; set cursor location

	pop	h


display_help_loop1:		; display 6 lines of text


	call	RPBUFCRK	; print line till 00 at cursor from hl
				; return with hl pointing to 00 character
				; and zero set

	mov	a,m

	cpi	0feh		; if FE then done screen, page break
	jz	help_end_of_screen	

	cpi	0ffh		; if FF then done help
	jz	help_end_of_help	

	jmp	display_help_loop1

help_end_of_screen:
	inx	h
	push	h			; temp store pointer to data
	
	lxi	h,msgh1
	call	RPBMSG

	call	hit_any_key		; wait for escape or key

	pop	h

	jz	help_exit		; exit from help
	jmp	display_help_loop2	; get next screen

help_end_of_help:


help_common_exit:
	lxi	h,msgh2
	call	RPBMSG

	call	hit_any_key		; wait for key

help_exit:
	call	display_title
	call	clsmsg
	
	lhld	JMPVECT
	pchl
;	jmp	main_menu3


	
	

				; load pointer to help text
				; display text 
				; if pointer 0000 then exit on any key
				; if esc, return
				; if space, get another screen

;---------------------------------------------------------------------------------
msgh1:	.db	"<ESC> exit <any key> more",00h
msgh2:	.db	"<any key> to return",00h



;---------------------------------------------------------------------------------
; main help screens
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
scr1:	.db	"Main Menu Help",0
	.db	"==============",0
	.db	"REX is an option ROM switcher that",0
	.db	"also includes RAM backup and switching",0
	.db	"functions.  REX manages RAM or ROM data",0
	.db	"in 32k blocks, refered to as images.",0
	.db	0FEh
;	 	xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"Option ROMs may be loaded into REX",0
	.db	"images and selected for use, and your",0
	.db	"system RAM may be copied to or restored",0
	.db	"from REX images.",0
	.db	"Images are grouped by type RAM/ROM/OS.",0
	.db	"SYS images are reserved for system use.",0
	.db	0FEh
;	 	xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"Images may be 'Load'ed or 'Save'd",0
	.db	"to/from TPDD.  Filename extensions are",0
	.db	".BX is used for Option ROM images",0
	.db	".BY is used for RAM images",0
	.db	".BZ is used for OS images",0
	.db	".BR is used for REX system images",0
	.db	0FEh
;	 	xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"Images may be 'Name'd, 'Copy'd or",00
	.db	"'Kill'ed. Up to 16 images of any one",00
	.db	"type are allowed, with 24 images in",0
	.db	"total. An Image is ACTIVE when in use",0
	.db	"by REX, and is marked with a *.  There",0
	.db	"must always be one active RAM and one",0
	.db	0FEh
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"active ROM or OS image.",0
	.db	"You cannot kill an active image.",0
	.db	"Active status is changed by selection",0
	.db	"of a new image using the <ent> key.",0
	.db	"OS images are option ROMs that act as",0
	.db	"independant operating systems.",0 
	.db	0FEh
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"Keyboard Commands",00
	.db	"<b> Block number information",0
	.db	"<e> Hints on <ENTER> key functions",0
	.db	"<i> Information on REX system",0
	.db	"<c> Checksum of menu entry image",0
	.db	"<s> Toggle directory sort order",0
	.db	0FEh
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"Keyboard Commands",0
	.db	"<ent> Take action for selection",0
	.db	"<tab> Show directory for next type",0
	.db	"<esc> return to menu",0,0,0
	.db	0FEh
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"Function Keys",0
	.db	"<F1> Display help screens",0
	.db	"<F2> Load/Save image from/to TPDD",0
	.db	"<F3> Copy image to REX",0
	.db	"<F4> Delete image from REX",0
	.db	"<F5> Rename the image",0
	.db	0FEh
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"Function Keys",0
	.db	"<F6> File transfer from stored image",0
	.db	"<F7> Deinstall REX software from laptop",0
	.db	"<F8> Exit REX Manager",0,0,0
	.db	0FEh
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"Consult Bitchin100 REX Wiki for further",0 
	.db	"information.",0
	.db	0
	.db	"Enjoy your REX!",0
	.db	0
	.db	"Stephen Adolph 2010",0
	.db	0FFh



;---------------------------------------------------------------------------------
; syshelp screens
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
sscr1:	.db	"SYS Menu Help",0
	.db	"=============",0
	.db	"This menu is used to manage system",0
	.db	"related tasks, primarily management of",0
	.db	"the loaded main ROM images used when",0
	.db	"REX is replacing the internal ROMs.",0
	.db	0FEh
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"See the Wiki for the steps required",0
	.db	"to configure your laptop for ROM",0
	.db	"Replacement, and how to create ROM",0
	.db	"images that are compatible with REX.",0
	.db	"ROMs require a small change so that REX",0
	.db	"can detect the hardware configuration.",0
	.db	0FEh
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"REX Manager screens now indicate the",0
	.db	"status of the ROM Replacement function.",0
	.db	"In the top left corner there is a ",0
	.db	"highlighted character, one of M/P/S.",0
	.db	"This character indicates which system",0
	.db	"ROM is in use - internal or REX based.",0
	.db	0FEh
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"M - standard internal ROMs in use",0
	.db	"P - Primary ROM (block 2)in use",0
	.db	"S - Secondary ROM (block 4) in use",0
	.db	"When the internal ROM is in use, REX",0
	.db	"cannot provide ROM Replacement.",0
	.db	"Primary or Secondary ROM images may be",0
	.db	0FEh
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"'Load'ed via selection from menu.",0
	.db	"When the laptop is configured for ROMs",0
	.db	"provided by REX, the power-up default ",0
	.db	"is to use the Primary ROM in block 2.",0
	.db	"It is a good idea to leave this block",0
	.db	"configured with the standard image.",0
	.db	0FEh
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"'Use' command allows the user to select",0
	.db	"either Primary or Secondary ROMs for",0
	.db	"use.  This selection is tracked in the",0
	.db	"active block directory, so that system",0
	.db	"state is always restored on power up.",0
	.db	"Timestamps are recorded also.",0
	.db	0FEh
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"Messages are shown above the entries to",0
	.db	"give some information about the block",0
	.db	"under the cursor.",0,0,0,0
	.db	0FEh
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"Keyboard Commands",00
	.db	"<b> Block number information",0
	.db	"<i> Information on REX system",0
	.db	"<c> Checksum of menu entry image",0
	.db	"<tab> Show directory for next type",0
	.db	"<esc> return to menu",0
	.db	0FEh
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	.db	"Function Keys",0
	.db	"<F1> Display help screens",0
	.db	"<F2> Load image from TPDD",0
	.db	"<F3> Select ROM image for use",0
	.db	"<F7> Deinstall REX software from laptop",0
	.db	"<F8> Exit REX Manager",0
	.db	0FFh


;---------------------------------------------------------------------------------
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ack1:	.db	"Thanks to:",0
	.db	"John Hogerhuis: broad technical support",0
	.db	"Philip Avery: MENU code contributions",0
	.db	"Wilson Van Alst: base TPDD routines",0
	.db	"Ken Pettit: for VirtualT!",0
	.db	"...and many others for their feedback",0
	.db	0FFh


;---------------------------------------------------------------------------------
;		 xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
ram1:	.db	"Arrow, shift-arrow to browse",0
	.db	"<F1> Display help screens",0
	.db	"<F3> Copy file from REX image -->local",0
	.db	"<F4> Kill local file",0
	.db	"<F5> Name local file",0
	.db	"<F8> Exit File Menu",0
	.db	0FFh