; bug - can enter a name with zero length...bad.

;------------------------------------------------------------------------------------
get_6_byte_name:

; entry with hl pointing to start of 6 byte name location on screen, formatted for POSIT
; accept A-Z, 0-9 arrow keys, backspace to erase, enter to set, escape to exit
; convert to uppercase
; store 6 byte name at INPUT_BUFFER, F685 is first character of name
; if escape hit then set zero bit
; if successful, reset zero bit
; enter with hl = col,row
; uses DIRAD1 and DIRAD2, which are only used in copy image

	shld	TEMP3		; store screen location in hl

	lxi	h,INPUT_BUFFER	; store text location in de
	shld	TEMP4

	mvi	b,08d
	call	add_whitespace

	mvi	b,6d
	push	b		; store counter on stack

character_input_loop:

	lhld	TEMP3
	rst	6
	.dw	POSIT

	rst	6
	.dw	CHGET
	rst	6
	.dw	UPCAS		; upper case names only

	cpi	27d		; test for escape
	jz	quit_get_6_byte

	cpi	13d		; test for enter
	jz	done_get_6_byte
	
	cpi	08d		; test for backspace
	jz	back_one_space

	pop	b
	push	b
	mov	c,a
	mov	a,b
	ora	a
	jz	character_input_loop		; if six characters then only enter esc bkspace is good

	mov 	a,c	
	
	cpi	32d		; if <32, try again
	jm	character_input_loop	
	cpi	127		; if >126, try again
	jp	character_input_loop
				; valid character 


	lhld	TEMP4
	mov	m,a		; store character	
	
	call 	print_character

	lhld	TEMP3
	inr	h
	shld	TEMP3		; move forward one space for screen location

	lhld	TEMP4
	inx	h
	shld	TEMP4		; move forward in buffer

	pop	b
	dcr	b
	push 	b		; decrement count

	jmp	character_input_loop
	


back_one_space:
	pop	b
	push	b
	mov	a,b
	cpi	6d
	jz	character_input_loop	; if still at 6 characters, you can't backspace

	pop	b
	inr	b
	push	b		; add one to count

	mvi	a,32d
	lhld	TEMP4
	mov	m,a		; store space at buffer location
	call 	print_character

	lhld	TEMP3
	dcr	h
	shld	TEMP3		; move back one space for screen location

	lhld	TEMP4
	dcx	h
	shld	TEMP4		; move back in buffer

	mvi	a,32d
	lhld	TEMP4
	mov	m,a		; store space at buffer location
	call 	print_character

	jmp	character_input_loop	


print_character:		
	lhld	TEMP3		; point to screen location
	rst	6
	.dw	POSIT
	lhld	TEMP4
	mov	a,m
	rst	6
	.dw	LCD		; print character
	ret


quit_get_6_byte:
	pop	b
	xra	a		; set zero bit
	ret

done_get_6_byte:
	pop	b
	mov	a,b
	cpi	06d
	jz	get_6_byte_name		; bugfix?

	ori	0FFh		; reset zero bit
	ret




;--------------------------------------------------------------------
check_blank:	

#if real_hardware = 0
	ret
#endif			
	push	psw
	call	I_BLANK
	pop	psw
	mov	b,a
	push	b
	call	GEN_1		;	entry: 	a = block for calculation
				;	exit:	zero set blank, zero reset, not blank
	pop	b
	mov	a,b		; reload a in case we need it below
	rz

; found a non blank block - error in system somehow
; mark block as A, force user to delete if required
; give it the name "RECOVR", type unchanged
; current date/time
; display error message and restart REX Manager.


	sta	CURBLK			; temp store a
	lda	TYPE
	sta	LASTB			; LASTB = TYPE

	call	is_name_directory_full
	cz	refresh_directories	; if end of record then we must rebuild the directories

	mvi	a,0FFh
	call	find_directory_entry	; get hl = open slot location

	push	h			; h = location for new record
	lda	CURBLK
	call	write_directory_block	; entry 	hl = pointer to directory entry, a = block number
					; exit 		none, block written

	lxi	d,recovr_text		; get pointer to 6 byte name		
					; d points to first character

	pop	h			; hl holds new record location, de holds pointer to text		
	push	h
	call	write_directory_name	; write name bytes

	pop	h
	push	h
	call	write_directory_lastb	; write lastb


	call	get_current_time
	pop	h			; hl points to new entry
	push	h
	call	store_entry_time

	call	get_current_date
	pop	h			; hl points to new entry
	call	store_entry_date

; done with creation of a new entry
; display error message and restart


	lxi	h,msgnb
	jmp	display_check_message



;----------------------------------------------------------------
check_flash_ready:
	call	I_STV
	call	GEN_1		; get status information

	mov	a,b
	ana	a
	rm			; if bit 7=1 then ready
				; if not ready then error
;flash_not_ready_error:

	lxi	h,msgfnr
	jmp	display_check_message



;--------------------------------------------------------------------
check_free_block:
	lda	SUFLAG
	ani	00000010b		; zero = free blocks, notzero, no free blocks

	rz

	lxi	h,msgnfb
	jmp	display_check_message

;--------------------------------------------------------------------
check_count:
	lda	COUNT
	cpi	16d

	rm

	lxi	h,msgtm

;--------------------------------------------------------------------
display_check_message:
	call	RPBMSG

	call	DELAY

	lhld	STACK		; set stack to same as what was stored on entry
	sphl
	
	lhld	JMPVECT
	pchl			; return via JMPVECT

;--------------------------------------------------------------------
msgfnr:	.db	"Error - flash not ready!",00h
msgnfb:	.db	"REX is full!",00d
msgtm:	.db	"Too many of one type!",00d	
msgnb:	.db	"Found unmarked image...recovering...",00d
recovr_text:
	.db	"RECOVR"


oktxt:	.db	" OK!",13d,10d,00h

REX:	.db	"REX"
	.db	00
REX2:	.db	"REX2"
	.db	00

;---------------------------------------------------------------------
common_error:				; enter with hl pointing to error text

	call	RPBMSG
	rst	6
	.dw	BEEP

	call	DELAY

common_exit_stack:
					; reset stack and transfer control
	lhld	STACK			; reset the stack
	sphl

common_exit:	
	lhld	JMPVECT			; load vector to jump to
	pchl				; transfer control to location in hl



;---------------------------------------------------------------------

blank_GEN_1:

	lxi	d,GEN_1		; blank out 96 bytes at GEN_1, 3 bytes per entry
	mvi	b,96d		
;--------------------------------------------------------------------
; set b bytes to 00 at hl increasing
set_b_00_de:
	xra	a
set_b_a_de:
	stax	d
	inx	d
	dcr	b
	jnz	set_b_a_de	
	ret


;-------------------------------------------------------------------------

erb0:	mvi	h,00h		; enter here for normal block
erase_block:			; enter here to set hl address
	mvi	l,00h
	push	h
	push	psw
	call	I_ERB		; erase block in a, using hl address
	pop	psw
	pop	h
	jmp	GEN_1

;---------------------------------------------------------------------------------
hit_any_key:
get_key:

	rst	6
	.dw	KYREAD
	jz	get_key


	cpi	27d		; test for escape
	ret			; return with zero set if escape hit
				; zero reset if any other key



;--------------------------------------------------------------------------
; delay 
;--------------------------------------------------------------------------
DELAY:	
	mvi	b,02h		; count down loops
DL1:
	lxi	h,0FFFFh
DELAY_LOOP:
	dcx	h
	mov	a,h
	ora	l		; test for hl=0000
	jnz	DELAY_LOOP

	dcr	b		; do b loops of 65535 decrements
				; test for b = 00h
	jnz	DL1

	ret


