
;---------------------------------------------------------
; file_installer
; go through the process to inject a file pointed to by hl
; steps-
; search for the name, if it is not there then insert name in first location, else display error message and end
; make hole for the data - if it can't then error message and delete the file entry, exit properly
; inject the data
; run routine to correct links
; install at LOWMEM + 1
; this should work for LOWRAM of any value 
;---------------------------------------------------------
	

file_installer:			; note REX SW must be installed!
				; hl points to start of file data, 11bytes of name record, 2 length bytes, then the code

	push	h			; temp store
	call	search_name_free	; look for a file name match, and identify first free slot
					; hl points to start of file name record data
					; if free slot found, TEMP2 points to first free file name slot
					; if free slot not found, TEMP2 = 0000
					; if file name found, TEMP1 points to file name entry
					; if file name not found - TEMP1 = 0000

test_for_file_found:			; hl on stack
	lhld	TEMP1			; return if not zero
	mov	a,h
	ora	l
	pop	h
	jz	test_for_no_free_slot	; nothing on stack


	lxi	h, dupnam
	call	RPBUFCR


	mvi	a,01h
	ora	a			; reset zero bit
	ret				; return if name entry was found!

test_for_no_free_slot:			; nothing on stack
	push	h			; return if no free slot was found!
	lhld	TEMP2
	mov	a,h
	ora	l
	pop	h
	jnz	Install_file		; nothing on stack


	lxi	h,nodir
	call	RPBUFCR

	mvi	a,01h
	ora	a			; reset zero bit
	ret				; if not zero on return, there was an error with injection


nodir:	.db	"NO FREE DIRECTORY ENTRY!"
	.db	00h

dupnam:	.db	"DUPLICATE FILE NAME!"
	.db	00h
;---------------------------------------------------------------------------------
					; inject the name and file
					; hl points to file data
					; slot found, stack holds source data, TEMP2 is target
Install_file:
				; find an entry with 8001h starting address, and correct it
	push	h		; temp store pointer to file data
	lxi	h,DIRTBL+(11d)	; load HL with beginning of user directory


				; Find an entry with address LOWRAM+1

				; file data pointer on stack
search_address:			; hl indexes directory
	lxi	b,DIRLEN	; set directory length into bc
	dad	b		; get the next slot

	mov	a,m
	cpi	0FFh		; test for end of directory

	jz	no_BA_found	; file pointer on stack
	
	push	h		; temp store hl
	inx	h		; hl points to directory entry + 1
				; now check if pointer to file start = LOWRAM + 1
	lda	LOWRAM
	inr	a		; add 1 to LSB of (LOWRAM)
	cmp	m
	pop	h		; restore hl
	jnz	search_address	; file pointer on stack



	push	h		; temp store h
	inx	h
	inx	h		; hl points to directory entry + 2
	lda	LOWRAM+1h	; 80, A0, C0
	cmp	m
	pop	h		; restore h
	jnz	search_address	


				; hl points to directory entry that needs adjustment
	inx	h		; point to start of file bytes
	mov	a,m
	inr	a
	inr	a
	mov	m,a		; increment start pointer by 2
				; directory entry adjusted

; note - we have to look for a possible file entry that might already be there
; if it is there, we have to move the directory entry pointer because we are going
; to make a hole there, and linkfl will use this to relink
				
				; file pointer on stack

no_BA_found:			; file data pointer on stack
	pop	h		; hl points to file data
	xchg			; de points to source
	lhld	TEMP2		; hl points to target
	mvi	c,DIRLEN


	call	MOVEC_D_H	; now, make the new directory entry
				; finished with directory entry, now file 

				; de points to file data	
	lhlx			; load hl with 2 bytes at (de)(de+1)
	mov	b,h
	mov	c,l		; place length in bc
	push	b		; length on stack

	lhld	ASCTAB
	dad	b
	shld	ASCTAB		; move ASCTAB by BC bytes


	inx	d
	inx	d
	push	d		; de points to start of file data

	lhld	LOWRAM
	inx	h		; 8001, A001, C001
				; store as first file start of file data
	push	h


	RST	6
	.dw 	MAKHOL		; hl points to memory, bc is length of hole, de points to file data
	jc	not_enough_memory

	pop	h		; hl points to low memory for program inject
	pop	d		; de points to program data
	pop	b		; BC still holds file size, assumed < 255 characters
				; nothing on stack

	call	MOVEC_D_H

				; correct the directory entry
	lhld	TEMP2
	inx	h		; hl points to file directory entry
	xchg			; de points to file directory entry
	lhld	LOWRAM
	inx	h		; hl = 8001, A001, C001
	shlx			; store hl in location (DE)


				; final links adjustment
	rst	6
	.dw	LNKFIL		; adjust pointers	


	
	xra	a		; set zero flag	
	ret			; done file insertion

;--------------------------------------------------------------------------
; handle the case when not enough space is present to make the holes

not_enough_memory:		; delete the hole
				; three things on stack
				; hl points to memory, bc is length of hole, de points to file data

	lxi	h,nofree
	call	RPBUFCRK

	rst	6
	.dw	MASDEL		

	pop	h
	pop	h
	pop	h		; clear the stack

				; delete the directory entry
	lhld	TEMP2
	xra	a
	mov	m,a		; zero out directory flag

	RST	6
	.dw	LNKFIL		; reset the file pointers

	mvi	a,01h
	ora	a
	ret			; return with error condition set


nofree:	.db	"NOT ENOUGH FREE MEMORY!"
	.db	00h

;---------------------------------------------------------
; file_deinstaller
; kill a basic file
;---------------------------------------------------------

file_deinstaller:			; hl points to file record data

	call	search_name_free	; look for a file name match, and identify first free slot
					; hl points to start of file name record data
					; if free slot found, TEMP2 points to first free file name slot
					; if free slot not found, TEMP2 = 0000
					; if file name found, TEMP1 points to file name entry
					; if file name not found - TEMP1 = 0000

						
	lhld	TEMP1
	mov	a,h
	ora	l
	rz			; return with no action if file not found
	
	PUSH 	H
	rst	6
	.dw	GETTP		; Get start address of file at M
	XCHG
	POP H			; file start pointer in DE, directory entry in hl
	rst	6
	.dw	KILB	  	
	ret			; done, return


;------------------------------------------------------------------------------------

search_name_free: 			; look for a file name match, and identify first free slot
					; hl points to start of file name record data
					; if free slot found, TEMP2 points to first free file name slot
					; if free slot not found, TEMP2 = 0000
					; if file name found, TEMP1 points to file name entry
					; if file name not found - TEMP1 = 0000

; note - we should modify this so that we never look for a free slot till we find the 3 
; hidden files of type 88h, A8h, 48h

	shld	TEMP3		; use TEMP3 to store pointer to file

	lxi	h,0000h
	shld	TEMP2		; clear the free directory entry address
	shld	TEMP1		; clear slot address
	
	lxi	h,DIRTBL	; load HL with beginning of user directory
	
; first, let's advance to the last hidden file, type 048h

	mvi	c,DIRLEN	; set directory length into bc
	mvi	b,00h
search_advance:
	dad	b
	mov	a,m
	cpi	0FFh
	jz	search_no_entry_found

	cpi	048h
	jnz	search_advance	; advance until we hit last hidden file


search_name:			; hl indexes directory
	mvi	c,DIRLEN	; set directory length into bc
	mvi	b,00h
	dad	b		; get the next slot

	mov	a,m
	cpi	0FFh
	jz	search_no_entry_found

	
				; if we are here, it is time to search, we are past the last
				; hidden file
	push	h
	
	lhld	TEMP3
	mov	a,m				; load a with file type
	pop	h
	push	h
	cmp	m				; compare with slot file type
	cz	type_found			; jump to type_found routine

	pop	h
	push	h
	
	mov	a,m
	ora	a
	cz	free_slot_found			

	pop	h
	jmp	search_name			; loop back if not end of directory
				

search_no_entry_found
	ori	01h			; we are here because we got to end of directory without finding the name
	ret				; clear the zero bit and return



free_slot_found:		; hl points to current name directory entry
	push	h

	
	lhld	TEMP2
	mov	a,h
	ora	l
	pop	h
	rnz
	shld	TEMP2		; store hl into TEMP2 and return
	ret


				; compare the names if type found
type_found:			; hl points to current directory entry
	push	h
	
	inx	h		 
	inx	h		
	inx	h		; advance to name field in directory

	xchg			; place pointer in de
	lhld	TEMP3		; load hl with pointer to test file name

	inx	h
	inx	h
	inx	h		; hl points to file name, de points to record to verify
	
	mvi	b,NAMLEN	; load b with name length

compare_name:
	ldax	d		; get directory's name character
	cmp	m
	jnz	compare_name_1	; jump if not the same to search again
	inx	h
	inx	d
	dcr	b
	jnz	compare_name	; run through the whole name to compare	


	lhld	TEMP1		; file name is the same
	mov	a,h
	ora	l
	
	pop	h		; restore pointer to file name in directory
	rnz			; if TEMP1 is 0000 then it can be updated else return

	shld	TEMP1		; store directory entry in TEMP1
	ret			; name record found
	
compare_name_1:
	pop	h
	ret		




;--------------------------------------------------------------------------
; REXMGR.BA  -  program to be injected starts here
; placed here to create a basic program listing, but compiled to allow editing
; this entire program will be copied into RAM as REXMGR.BA
; sets REX to block 00
; jump to REXMGR at 0000h
;--------------------------------------------------------------------------

file2_data:
file2_name_record:

	.db	080h
	.db	00,00
	.db	"REXMGRBA"			; file name
file2_size:
	.dw	file2_end-file2_start		; file length

						; REXMGR.BA program data
file2_start:

#if modeltype = 0 			; M100/T102
	.dw	next_line_2-file2_start+8001h	; pointer to next line
#else					; T200
	.dw	next_line_2-file2_start+0A001h	; pointer to next line
#endif

	.db	01h,00h				; line number 1
	.db	41h,24h,0ddh,22h		; A$="
	
	; actual machine code starts here
	di

#if modeltype = 0			; M100
	xra	a		
	inr	a
	out	0E8h		; turn on optrom
#else					; T200
	mvi	a,00110000b
	rrc
	rrc			; 00001100b
	mov	l,a

	mvi	a,10000000b
	rlc	
	rlc			; 00000010b
	mov	h,a
	in	0D8H
	ana	l		; keep ram bits, zero out rom bits
	ora	h		; turn on optrom
	out	0D8H

#endif	

	
	xra	a
	mov	h,a		; zero h
	mov	l,a		; zero l

	mov	a,m
	mov	a,m		; need 5 reads to ensure always in state 111
	mov	a,m
	mov	a,m
	mov	a,m		; ensure in state 111
				; ready to send key
	
	mvi	l,184d		; key = B6
	mov	l,m		
	mvi	l,242d		; key = F2
	mov	l,m		
	mvi	l,52d		; key = 34
	mov	l,m		
	mvi	l,176d		; key = B0
	mov	l,m		
	mvi	l,49d		; key = 31
	mov	l,m		
	mvi	l,191d		; key = BF
	mov	l,m		; state = 000	

	xra	a
	mov	h,a
	mov	l,a
	inr	l		; set hl=0001

	mov	l,m		; send command 1
	xra	a
	mov	l,a		; set block = 0		
	mov	a,m		; provision rexrom to be visible
				; and primary main rom selected
				; back to state 000

	mov	a,m		; state 111


				; M100/T102 and T200
	xra	a
	inr	a
	inr	a
	inr	a		; a=03
	mov	h,a
	mvi	l,83h		; hl = 383h	
				; same address works in all machines

	pchl			; jump to REX_MGR_ENTRY

							; basic terminator
	.db	22h,3ah					; ):

	.db	42h,0DDh,0c3h,28h,41h,24h,29h,3ah		; B=VARPTR(A$):
	.db	43h,0DDh,0EEh,28h,42h,0D0h,31h,29h,0D0h,32h,35h
	.db	36h,0D2h,28h,0EEh,28h,42h,0D0h,32h,29H,29H,3ah	; C=peek(B+1)+256*(peek(b+2)):
	.db	0b9h,43h,3ah		; CALLC:
	.db	08Eh,"VERSION ",rel+30h,'.',dotrel+30h		; version information

#if modeltype = 1
	.db	" T200"
#else
	.db	" M100/T102"
#endif
	.db	00h
next_line_2:
	.db	00h,00h						; end of program
file2_end:



; REX HOOK program
file1_data:
file1_name_record:
	.db	088h
	.db	00,00
	.db	"RXHOOK"			; file name
	.db	00,00
file1_size:
	.dw	file1_end-file1_start		; file length

						; RXHOOK.BA program data
file1_start:


#if modeltype = 0 			; M100/T102
	.dw	08001h + next_line_1-file1_start		; pointer to next line
#else					; T200
	.dw	0A001h + next_line_1-file1_start		; pointer to next line
#endif


	.db	01h,00h				; line number 1

	; actual machine code starts here

hook_program_start:
	di
	push	psw
	push	h

	xra	a
	mov	h,a
	mvi	l,03h			; load hl with 0003h

	mov	a,m
	cpi	'M'			; see if main rom is selected
hook_program_2:

#if modeltype = 0 			; M100/T102
	jnz	08001h + hook_program_1 - file1_start	; jump to exit if a<>"M"
#else					; T200
;	jnz	0A001h + hook_program_1 - file1_start	; jump to exit if a<>"M"
	jnz	0A001h + hook_program_1 - hook_program_start	; jump to exit if a<>"M"
#endif


#if modeltype = 0 			; M100/T102
					; main rom in use - test for rexrom in optrom
	lda	0FF45h
	ori	01h
;	sta	0FF45h			; preserve state of register
	out	0e8h			; switch to option rom
#else					; T200
	IN	0D8h			; get config
	ani	00001100b		; keep RAM bits
	ori	00000010b		; swap to option rom
	OUT	0D8H
#endif

	inx	h			; load hl with 0004h

	mov	a,m			; load a with value at 0004h
	cpi	'R'			; test for REX R = 82h = 1000 0010
	jz	REX_INT_ENTRY		; if "R" then jump to REX interrupt entry - REXROM is visible


#if modeltype = 0			; M100/T102
	lda	0FF45h
	ani	0FEh
;	sta	0FF45h			; preserve state of register
	out 	0E8h			; turn main rom back on
#else					; T200
	IN	0D8h			; get config
	ani	00001100b		; keep RAM bits
	OUT	0D8H
#endif


hook_program_1:
	pop	h
	pop	psw
	ei
	ret				; return

hook_program_end:
	.db	00h
next_line_1:
	.db	00h,00h			; end of program
file1_end:






;---------------------------------------------------------------------------
remove_romba:			; sweep out .BA files associated with ROMs

; feed pointers to the data below
; call the above routine to kill the .BA files if they are there

; when to do this?  
; 	or whenever a rom is swept out....


	lxi	h,romba_data


remove_romba_loop:
	
	push	h

	call	file_deinstaller		; deinstall the file based on the data below
						; if found, wiped.
	pop	h

	lxi	d,11d				; increment hl
	dad	d
	
	mov	a,m
	cpi	0FFh				; check for end

	jnz	remove_romba_loop

	ret



romba_data:
	.db	080h
	.db	00,00
	.db	"TS-DOS  "			; file name

	.db	080h
	.db	00,00
	.db	"UR-2    "			; file name

	.db	080h
	.db	00,00
	.db	"TWORD+  "			; file name

	.db	080h
	.db	00,00
	.db	"RANDOM  "			; file name

	.db	0FFh


; roms swept out by trigger file sweep--
; Analyst, SuperROM

; roms that don't leave anything behind
; ROM2/Cleuseau, Multi-Solutions, Integrated Solutions, Multiplan


;---------------------------------------------------------------------------
adjust_lowram:				; enter with bc = desired size of LOWRAM
					; c = # of 256 blocks
					; could be 0 or the length of a file
					; lowram could move up or down
					; assume it is safe to do so, interrupts off etc.

	mov	d,c		; store size of hole required in de
	mvi	e,0d

        LHLD 	LOWRAM		; lomem pointer

	lxi	b,0A000h
	push	b		; store A000 on stack

	dsub			; hl=hl-bc, hl is current size of lowram space

				; hl is current lowram space
				; de is desired lowram space
	rst	6
	.dw	0018h		; compare hl, de 


	jz	adjust_nochange

	push	psw		; store state   nc = hl>de, z = hl=de, c = hl < de

				; carry set when expansion
				; carry cleared when contraction

	jnc	adjust_lowram_noswap		; if current hole is larger than desired, go here
				; take this path if current hole is smaller than desired

	xchg			; swap hl and de, so larger is in hl
				; take this path when de>hl, expansion

adjust_lowram_noswap:		; hl > de

	mov	b,d
	mov	c,e		; hl > bc

	dsub			; hl = delta hole size

	mov	b,h
	mov	c,l		; bc = delta hole size

	pop	psw		; get back flags
	pop	h		; hl = A000
	
	push	b
	jnc	adjust_lowram_shrink	; carry set when expansion
					; carry cleared when contraction
	rst	6
 	.dw 	MAKHOL		; Make a hole of BC bytes at HL

	pop	b
	jmp	adjust_lowram_pointers

      
adjust_lowram_shrink: 
	rst	6
        .dw 	MASDEL		 ;Delete BC number if characters in a text file
    
	pop	b
	lxi	h,0000h
	dsub
	
	mov	b,h
	mov	c,l		; compliment of hole size


adjust_lowram_pointers:		; bc holds value to correct
	lhld 	ASCTAB		
        dad	B
        shld	ASCTAB		; correct ASCTAB
        
	lhld	LOWRAM
	dad	b
	shld	LOWRAM		; correct LOWRAM

	mov	a,h
	sui	0A0H
	sta 	0A000H

	rst	6
	.dw 	02C62h		; Fix up directory pointers
	ret
	
adjust_nochange:
	pop	b
	ret