
is_name_directory_full:
; entry 	none
; exit 		zero set, directory full, zero reset, directory not full

	
	lda	name_directory_end-0Fh
	cpi	0FFh		; test a=FF
	jz	name_directory_is_not_full
				; directories have no space
	xra	a		; set zero bit
	ret

name_directory_is_not_full:	; directories have space
	ori	01h		; reset zero bit
	ret


;--------------------------------------------------------------------
write_directory_name:
; entry 	hl = pointer to directory entry, de = pointer to name text
;		writes 6 bytes, name text must be 6 bytes
; exit 		none, name written

	inx	h		; advance 1 byte to start of name entry
	mvi	b,06h		; load b with 6 characters

write_directory_name_1:		; pointers on stack
	ldax	d		; get first character	

	push	h
	push	d
	push	b		; store variables
				; a = data, hl = target pointer
	call	double_byte_poke	; poke the data

	pop	b
	pop	d
	pop	h

	inx	h
	inx	d

	dcr	b
	jnz	write_directory_name_1

	ret			; done	
		
	
;--------------------------------------------------------------------
write_directory_block:
; entry 	hl = pointer to directory entry, a = block number [0-63]
; exit 		none, block number written

	ori	11000000b		; turn on bit 7 and 6 for valid entry
	jmp	double_byte_poke

;--------------------------------------------------------------------
write_directory_lastb:
; entry 	hl = pointer to directory entry
; exit 		none, lastb written

	lxi	d,0007h
	dad	d
	lda	LASTB
	jmp	double_byte_poke

;--------------------------------------------------------------------
read_directory_lastb:
; entry 	hl = pointer to directory entry
; exit 		lastb updated

	lxi	d,0007h
	dad	d
	mov	a,m
	sta	LASTB
	ret

;--------------------------------------------------------------------
kill_directory_entry:
; entry 	hl = pointer to directory entry
; exit 		none, entry killed
	
	mov	a,m
	ani	01111111b		; turn off bit 1
	jmp	double_byte_poke


;--------------------------------------------------------------------
blank_directory_entry:
; entry 	hl = pointer to directory entry
; exit 		none, entry blanked
	
double_byte_poke0:
	xra	a
	jmp	double_byte_poke


;--------------------------------------------------------------------
find_directory_entryA:		; find A entry
	ori	11000000b	; turn on bit 7 and 6
	push	psw
	mvi	b,11111111b	; set mask for A
	jmp	find_directory_entry_mask_set		; b holds mask

;--------------------------------------------------------------------
find_directory_entry:		; find U or A entry
; entry 	a = block number to be searched for
; 		find A and U entries
; exit 		hl = pointer to directory entry (or potentially end of record) (or free entry)
; 		zero set if found, zero not set if not found

	ori	01000000b			; turn on bit #6 
	push	psw				; store block to be searched for

	mvi	b,01111111b			; set mask for U or A

find_directory_entry_mask_set:
	lxi	h,name_directory_start
	lxi	d,name_directory_end+1h

find_directory_entry_1:

	RST	6
	.dw	0018h			; compare de and hl, see if at end of record
	jz	find_directory_entry_3	; not equal, continue

	mvi	a,0ffh			; test for end of used entries
	cmp	m
	jz	find_directory_entry_3	; not equal, continue

	mov	a,m			; get firt byte
	ana	b			; and with mask
	mov	c,a			; store result in c
	pop	psw
	push	psw			; get the current block number
	cmp	c
	jz	find_directory_entry_2	; entry found, jump out

	call	advance_next_directory_entry

	jmp	find_directory_entry_1	; otherwise advance and loop back

find_directory_entry_3:			; entry not found
	pop	psw			; clear stack
	ori	01h			; reset zero bit
	ret				; hl points to free location, or end of directory

find_directory_entry_2:			; entry found
	pop	psw			; clear stack
	xra	a			; set zero bit
	ret				; hl points to directory entry

;---------------------------------------------------------------------------
advance_next_directory_entry:		; move to next directory entry
	
	push	d
	lxi	d,0016d
	dad	d
	pop	d
	ret


;--------------------------------------------------------------------
refresh_directories:			; no entry conditions
; erase the block with directories in it, 4000h-5999h
; program active block information in first directory
; rebuild the rom name directory
; erase block 1
; then copy block 0 to block 1
; uses TEMP1 and TEMP2
;--------------------------------------------------------------------
	lxi	h,msg02
	call	RPBMSG			; print message


#if real_hardware=1						
	lxi	h,active_block_table_start
	push	h		
	xra	a			; erase 4000-5FFF in block 0
	call	erase_block		; erase the directories block
#endif	

	call	I_REMOTE_POKEBYTE	; install POKEBYTE

	mvi	c,0h			; target 0
	pop	h			; start of active block directory
	push	h
	lda	ACTOPT
	call	GEN_1			; call POKEBYTE -  a written to (hl) in block c

	mvi	c,0h
	pop	h
	inx	h			; start of directory +1
	lda	ACTRAM
	call	GEN_1			; call POKEBYTE -  a written to (hl) in block c	

					; loop from 4400 to 5000
					; if a valid rom name is found, copy to new directory
	lxi	h,name_directory_start
	shld	TEMP1			; temp stores pointer to target directory (0)
	shld	TEMP2			; temp2 stores pointer to source directory (1)


refresh_directories_loop1:

	
	lhld	TEMP2			; load hl with source directory pointer

	lxi	d,name_directory_end+1h	; test for end of directory
	RST	6
	.dw	0018h			; compare de and hl
	jz	refresh_directories_2	; if equal then done

	call	I_REMOTE_GETBYTE	; install GETBYTE
	mvi	c,01h			; source 01
	lhld	TEMP2			; load pointer to directory in source
	call	GEN_1			; call GETBYTE - returns contents of (hl) from block c

	cpi	0FFh			; compare to FF
	jz	refresh_directories_2	; if FF then done!
;	jz	refresh_advance

	ani	01000000b		; test for bit 6 = 1 - not blank
	cnz	refresh_directories_copy	; copy, advance temp1

refresh_advance:

	lhld	TEMP2			; advance source to next entry
	call	advance_next_directory_entry
	shld	TEMP2

	jmp	refresh_directories_loop1

refresh_directories_2:

#if real_hardware=0 

	lhld	TEMP1
blank_loop:
	mvi	m,0FFh
	inx	h

	mov	a,h
	cpi	04Fh
	jnz 	blank_loop

	mov	a,l
	cpi	0FFh		; compare hl and de
	jnz	blank_loop
	ret
	
#endif


					; local directories rebuilt
					; active block updated
					; erase block 1
	mvi	a,01h			; block 1 erase
	call	erb0			; do the block erase

#if modeltype=0
	call	I_BARS
	call	GEN_1			; set up bar indicator
#endif
					; do a complete copy from block 0 to block 1
	call	I_CPYBLK
	lxi	b,0001h			; source 00 target 01
	lxi	d,08000h		; de = end start
	jmp	GEN_1			; do the block copy from b to c

;--------------------------------------------------------------------

refresh_directories_copy:
; entry 	TEMP2 = address of source directory entry
;		TEMP1 = address of target directory entry
	


	lxi	b,0010h			; copy 16 bytes

	lhld	TEMP2	
	xchg				; de = source
	lhld	TEMP1			; hl = target

refresh_directories_copy_loop1:
	push	b			; store counter

	push	h			; push target
	push	d			; push source
					
	call	I_REMOTE_GETBYTE	; install GETBYTE
	mvi	c,01h			; source 01 return 00
	pop	h
	push	h			; hl = source			
	call	GEN_1			; call GETBYTE - returns contents of (hl) from block c



	pop	d			; pop source
	pop	h			; pop target

	push	d			; push source
	push	h			; push target
	
	push	psw			; temp store data

	call	I_REMOTE_POKEBYTE	; install POKEBYTE
	mvi	c,00h			; target 00 return 00
	pop	psw			; restore data
	pop	h
	push	h			; hl = target	
	call	GEN_1			; program byte into directory


	pop	h			; pop target
	pop	d			; pop source
	inx	h
	inx	d			; advance pointers

	pop	b
	dcr	c			; repeat 16 times

	jnz	refresh_directories_copy_loop1

	lhld	TEMP1
	call	advance_next_directory_entry	
	shld	TEMP1			; advance TEMP1

	ret				; done


;-----------------------------------------------------------------------
double_byte_poke:
				; entry with hl = address and A = data
				; pokes the data into both main and backup system images
	push	h		; preserves hl and psw
	push 	psw

	call	I_REMOTE_POKEBYTE

	pop	psw
	pop 	h
	push	h
	push	psw

	mvi	c,00h		; target block = 0
	call	GEN_1		; write the byte to the location

	pop 	psw
	pop	h
	push	h
	push	psw
	mvi	c,01h		; target block = 1
	call	GEN_1		; write the byte to the location

	pop 	psw
	pop	h
	ret

;-----------------------------------------------------------------
write_freblk_entry:			; enter with hl pointing to entry with name text
					; assumes LASTB is updated

	call	write_common_entry

	call	get_current_time
	call	store_entry_time
	call	get_current_date
	call	store_entry_date

	ret


;-----------------------------------------------------------------
copy_freblk_entry:			; enter with hl pointing to entry with name text
					; assumes LASTB is updated

	call	write_common_entry
	
	dcx	d			; de points to source entry
	xchg
					; hl source de target
	call	get_entry_time
	xchg				; hl target de source
	call	store_entry_time
	xchg				; hl source de target
	call	get_entry_date
	xchg				; hl target de source
	call	store_entry_date

	ret


;-----------------------------------------------------------------		
write_common_entry:
; preserve hl
; enter with hl pointing to name text for new entry
; exit with hl pointing to new entry location
	push	h	
	
	call	is_name_directory_full
	cz	refresh_directories	; make sure a directory entry can be added

	mvi	a,0FFh
	call	find_directory_entry	; get a new directory entry 
	
	push	h			; temp store pointer to directory entry
	lda	FREBLK
	call	write_directory_block
	
	pop	h
	push	h
	call	write_directory_lastb	; write LASTB
	
	pop	h			; hl points to directory entry
	pop	d			; de points to name text
	push	d
	push	h
	call	write_directory_name	; entry 	hl = pointer to directory entry, de = pointer to name text

	pop	h			; hl points to new entry
	pop	d			; de points to source text
	ret



;-------------------------------------------------------------------------------
; date and time subroutines

; get current time, place in TEMP4
; print time - print out time stored in TEMP4

; get current date, place in TEMP4
; print date - print out date stored in TEMP4

; get entry time, place entry time in TEMP4
; get entry date, place entry date in TEMP4

; store entry time, write TEMP4 time data to entry
; store entry date, write TEMP4 date date to entry

; TIME	.equ	190FH  6415  03/21/09
; DATE 	.equ	192FH  6447  14:43:18
; date time format ymdhm
; 7 bits year, 4 bits month, 5 bits day  (16 bits)
; 8 bits hour, 8 bits minutes (16 bits)
;-------------------------------------------------------------------------------
; 
; point HL to GEN_1
; print the time or date string
; extract the data and encode
; preserves hl
;--------------------------------------------------------------------------------
get_current_time:

	push	h

	lxi	h,GEN_1
	push	h
	rst	6
	.dw	TIME

	pop	d		  	; de points to text

	call 	convert_2_bytes		; get hours, 8 bits
	
	sta	TEMP4

	inx	d
	inx	d
	inx	d

	call 	convert_2_bytes		; get minutes, 8 bits
	sta	TEMP4+1

	pop	h
	ret	

;--------------------------------------------------------------------------------
get_current_date:
	push	h

	lxi	h,GEN_1
	push	h
	rst	6
	.dw	DATE

	pop	d			; de points to text

	call 	convert_2_bytes		; get month, 4 bits
	
	ani	00001111b
	rrc
	rrc
	rrc
	mov	b,a			; temp store 
	ani	11100000b
	mov	c,a

	mov	a,b
	ani	00000001b
	mov	b,a			; b holds top bit for month

	inx	d
	inx	d
	inx	d

	call 	convert_2_bytes		; get day, 5 bits
	ani	00011111b
	ora	c
		
	sta	TEMP4+1

	inx	d
	inx	d
	inx	d

	call 	convert_2_bytes		; get year, 7 bits

	ani	01111111b
	rlc
	ora	b
	sta	TEMP4

	pop	h
	ret


;--------------------------------------------------------------------------------
convert_2_bytes:			; enter with de pointing to 2 characters
					; ascii number characters
	lhlx				; load hl with 2 bytes at de

	mov	a,h			; load a with ones
	sui	30h			; subtract 30h
	mov	h,a			; temp store result in h

	mov	a,l			; load a with 10s
	sui	30h
	mov	l,a			; temp store result in l
	
	ora	a
	jz	convert_2_bytes_loop_done

	xra	a
convert_2_bytes_loop:
	adi	010d
	dcr	l
	jnz	convert_2_bytes_loop

convert_2_bytes_loop_done:
	add	h			; add ones
	ret				; done
	
	

;--------------------------------------------------------------------------------
print_time:			; print time stored in TEMP4
				; 8 bits hour, 8 bits minutes (16 bits)

#if modeltype = 0			; M100
	lxi	h,2407h
#else					; T200
	lxi	h,240Bh
#endif

	rst	6
	.dw	POSIT
	


	lda	TEMP4
	call	print_8bit_number

	mvi	a,':'
	call	print_character_in_a

	lda	TEMP4+1
	call	print_8bit_number

	ret




;--------------------------------------------------------------------------------
print_date:		; 7 bits year, 4 bits month, 5 bits day  (16 bits)
			; print date stored in TEMP4

#if modeltype = 0			; M100
	lxi	h,1B07h
#else					; T200
	lxi	h,1B0Bh
#endif

	rst	6
	.dw	POSIT



	lda	TEMP4
	push	psw
	ani	11111110b
	rrc

	call	print_8bit_number

	mvi	a,'/'
	call	print_character_in_a

	pop	psw
	ani	00000001b
	rlc
	rlc
	rlc
	mov	b,a
	lda	TEMP4+1
	push	psw
	ani	11100000b
	rlc
	rlc
	rlc
	ora	b
	call	print_8bit_number

	mvi	a,'/'
	call	print_character_in_a

	pop	psw
	ani	00011111b
	call	print_8bit_number

	ret



;--------------------------------------------------------------------------------
print_8bit_number:		; binary number < 64

	ani	00111111b
	push	psw
	cpi	10d
	jp	print_number_greaterthan10

	mvi	a,'0'
	rst	6
	.dw	LCD
	
	pop	psw
	jmp	print_number_in_a



print_number_greaterthan10:		; 10<=a<64

	pop	psw

	mvi	h,00h
	mov	l,a
	rst	6
	.dw	NUMPRT

	ret

;--------------------------------------------------------------------------------

print_number_in_a:
	adi	30h
print_character_in_a:
	rst	6
	.dw	LCD			
	ret


;--------------------------------------------------------------------------------
get_entry_time:			; hl points to directory entry
				; preserves hl, de
	push	h
	lxi	b,10d

	jmp	get_common_date

;--------------------------------------------------------------------------------
get_entry_date:			; hl points to directory entry
				; preserves hl and de

	push	h
	lxi	b,08h

;--------------------------------------------------------------------------------
get_common_date:

	dad 	b
	mov	a,m
	sta	TEMP4
	inx	h
	mov	a,m
	sta	TEMP4+1

	pop	h
	ret

;--------------------------------------------------------------------------------
store_entry_time:		; hl points to directory entry
				; TEMP4 is prepped with current time data
				; preserves hl and de
	push	h
	push	d
	lxi	b,010d

	jmp	store_common_date

;--------------------------------------------------------------------------------
store_entry_date:		; hl points to directory entry
				; TEMP4 is prepped with current date data
				; preserves hl and de
	push	h
	push	d

	lxi	b,08d

;--------------------------------------------------------------------------------
store_common_date:
	dad	b
	
	lda	TEMP4
	call	double_byte_poke

	inx	h

	lda	TEMP4+1
	call	double_byte_poke

	pop	d
	pop	h
	ret


