
;---------------------------------------------------------------------------------------
quick_scan_directory:			; build the directory tables at GEN_1
					; provide counts

					; requires that TYPE is current/valid
	
					; use COUNT to hold count of assigned blocks of TYPE

					; return b = count of (A); count of assigned blocks
					; update COUNT (A of TYPE); COUNT = number of assigned blocks of type

					; build a table of the entries at GEN_1
					; 32 bytes at GEN_1 - status bytes, in order of block number
					; 64 bytes at GEN_1+32 - directory entry pointers in order

					; status bytes -  00 blank 64+type unassigned 192+type assigned
					; a block is blank if that block number is not found in the directory





	call	blank_GEN_1		; blank out 96 bytes at GEN_1, 3 bytes per entry

	xra	a
	sta	COUNT			; initialized counts
	sta	TEMP3

	lxi	h,name_directory_start-16d

qcheck_dir_0:

	lxi	d,0010h
	dad	d			; advance to next entry

	mov	a,m
	ana	a			; test for zero
	jz	qcheck_dir_0		; loop back if zero

	cpi	0ffh			; compare to FF, if equal, done
	jz	qcheck_done		; jump when end of directory


					; get pointer to GEN_1 table
	xchg				; temp store hl in de

	ani	00111111b
	mov	c,a			; put block number in c
	mvi	b,00h
	lxi	h,GEN_1
	dad	b			; get offset to GEN_1

	xchg				; hl points to directory entry
					; de points to GEN_1 table entry

	push	h
	lxi	b,0007h			; get TYPE
	dad	b
	mov	c,m
	pop	h
					; de points to GEN_1 entry
					; hl points to directory entry
	
	mov 	a,m			; get data again
	ani	11000000b
	add	c			; add last byte data

	stax	d			; store 192+lastb or 64+lastb in location

					; check if assigned block
					; c holds type
					; a holds status byte

	ani	11000000b		; look at first 2 bits
	cpi	11000000b		; are they both on?
	jnz	qentry_not_assigned
					; entry is an assigned block
	lda	TEMP3
	inr	a
	sta	TEMP3			; update count of assigned blocks

					; increment TEMP3 if c = TYPE
	lda	TYPE
	cmp	c			; compare c to TYPE
	jnz	qtype_check_cont

	lda	COUNT
	inr	a
	sta	COUNT			; count of assigned blocks of type

qtype_check_cont:
qentry_not_assigned:
					; now place pointer to record in GEN_1 second table
	mov	a,m
	ani	00111111b
	xchg				; temp store hl in de
	lxi 	h,GEN_1+32d
	add	a			; a = 2*a
	mov	c,a
	mvi	b,00h
	dad 	b
	
	xchg
	shlx				; store pointer to record in table at GEN_1+32d

	jmp	qcheck_dir_0		; loop back and get another


qcheck_done:
	lda	TEMP3
	mov	b,a
	ret




;---------------------------------------------------------------------------------------
scan_directory_structure:		; make sure directory is well structured
					; repair directory where possible
					; build the directory tables at GEN_1
					; provide counts

; requires that TYPE is current/valid

; check ACTRAM and ACTOPT are in valid range
; make sure entries 0-5 are there, with correct type
; look for double entries
; look for invalid entries based on first byte, type
; look for FF out of order
; check range of block number vs type
; check type range
; check for assigned blocks of correct type for ACTOPT and ACTRAM

; if bad entries found, erase them, error message on screen
; don't bother testing "blank" entries to see if they are in fact blank
; use TEMP2 to indicate FF encountered
; use TEMP3 to hold count of assigned blocks
; use COUNT to hold count of assigned blocks of TYPE

; replicate functions of scan_directory-- (replace that subroutine)
				; return b = count of (A); count of assigned blocks
				; update COUNT (A of TYPE); COUNT = number of assigned blocks of type
				; build a table of the entries at GEN_1
				; 32 bytes at GEN_1 - status bytes, in order of block number
				; 64 bytes at GEN_1+32 - directory entry pointers

				; status bytes -  00 blank 64+type unassigned 192+type assigned
				; a block is blank if that block number is not found in the directory





	call	read_active_block	; update active block info first

	lda	ACTRAM			; check ACTRAM range
	cpi	06d
	jm	active_block_error	
	cpi	32d
	jp	active_block_error

	lda	ACTOPT			; check ACTOPT range
	cpi	06d
	jm	active_block_error
	cpi	32d
	jp	active_block_error


	call	blank_GEN_1		; blank out 96 bytes at GEN_1, 3 bytes per entry

	mvi	a,0FFh
	sta	TEMP2

	xra	a
	sta	TEMP3
	sta	COUNT			; initialized counts

	lxi	h,name_directory_start-16d

check_dir_0:
	shld	TEMP1			; TEMP1 holds pointer to stored first FF entry
	lda	TEMP2
	cma
	sta	TEMP2			; complement TEMP2

check_dir_1:
	lxi	d,0010h
	dad	d			; advance to next entry

	push	h
	lxi	b,name_directory_end+1d
	dsub				; compare hl and bc
	pop	h
	jz	check_dir05		; jump when end of directory


					; start with SUFLAG = 00
	lda	TEMP2
	ana	m			; mask data with SUFLAG
						; if SUFLAG = FF, then result = 0data
						; if SUFLAG = 00, then result = 0
	mov	b,a
	lda	TEMP2
	cmp	b
	jnz	check_dir_FF_error	; if zero then FF error (we know data is not zero)


	mov	a,m			; get first byte
	ana	a			; test for zero
	jz	check_dir_1		; loop back if zero

	mov	a,m
	cpi	0FFh
	jz	check_dir_foundFF	; if FF, then complement SUFLAG - should be 00 from here out


	mov	a,m			; reload a			
	ani	11000000b		; now test that bit 6 and 7 are not zero
	jz	check_dir_76_error	; if zero then error in bit 7 and 6

					; bit 6,7 can be 01, 11 only
	lxi	b,0007h			; get TYPE
	push	h	
	dad	b
	mov	a,m
	pop	h
	mov	b,m			; b holds block, a holds type


	cpi	03h			; compare type to 00
	jnz	type_not_sys

	mov	a,b			; type is zero
	ani	00111111b
	cpi	06h
	jp	range_error		; for type zero, block must be <6
	cpi	00h
	jm	range_error		; block must be >0

	jmp	type_cont

type_not_sys:				; type >0
	cpi	03h
	jp	type_error		; type must be <3
	cpi	00h
	jm	type_error		; type must be >0

	mov	a,b
	ani	00111111b
	cpi	06h			; block number must be >6
	jm	range_error
	cpi	032h			; block number must be <32
	jp	range_error

type_cont:
	mov	a,m			; entry looks valid
					; get pointer to GEN_1 table
	xchg				; temp store hl in de

	push	psw			; temp store data
	ani	00111111b
	mov	c,a			; put data in c
	mvi	b,00h
	pop	psw			; restore data	

	lxi	h,GEN_1
	dad	b			; get offset to GEN_1


	xchg				; hl points to directory entry
	push	h
	lxi	b,07h
	dad 	b
	mov	a,m			; get last byte
	pop	h
					; b holds first byte, a holds last byte
	mov	c,a			; c holds last byte

					; hl points to directory entry
					; de points to GEN_1 entry
	ldax	d			; get table entry
	ora	a			; test for 0
	jnz	check_dir_repeat_entry
	
	mov 	a,m			; get data again
	ani	11000000b
	add	c			; add last byte data

	stax	d			; store 192+lastb or 64+lastb in location

					; check if assigned block
					; c holds type
					; a holds status byte

	ani	11000000b		; look at first 2 bits
	cpi	11000000b		; are they both on?
	jnz	entry_not_assigned
					; entry is an assigned block
	lda	TEMP3
	inr	a
	sta	TEMP3			; update count of assigned blocks

					; increment TEMP3 if c = TYPE
	lda	TYPE
	cmp	c			; compare c to TYPE
	jnz	type_check_cont

	lda	COUNT
	inr	a
	sta	COUNT			; count of assigned blocks of type

type_check_cont:
entry_not_assigned:
					; now place pointer to record in GEN_1 second table
	mov	a,m
	ani	00111111b
	xchg				; temp store hl in de
	lxi 	h,GEN_1+32d
	add	a			; a = 2*a
	mov	c,a
	mvi	b,00h
	dad 	b
	
	xchg
	shlx				; store pointer to record in table at GEN_1+32d

	jmp	check_dir_1		; loop back and get another


check_dir_foundFF:
	lda	TEMP2
	cpi	0FFh
	jz	check_dir_1
	jmp	check_dir_0


check_dir05:				; make sure that entries 0-5 are there
	lxi	d,GEN_1
	lxi	b,0C3C3h
	mvi	a,03h

check_dir05l:

	push	d
	lhlx
	dsub
	pop	d
	jnz 	check_dir_sys

	inx	d
	inx	d
	dcr	a
	jnz	check_dir05l



					; now check that ACTOPT and ACTRAM are present
	lda	ACTRAM
	mov	c,a
	mvi	b,00h
	lxi	h,GEN_1
	dad	b
	mov	a,m
	cpi	192d+00d
	jnz	check_dir_actram_missing

	lda	ACTOPT
	mov	c,a
	mvi	b,00h
	lxi	h,GEN_1
	dad	b
	mov	a,m
	cpi	192d
	jz	check_dir_actopt_missing	; if 192, problem 
	jm	check_dir_actopt_missing	; if <192, problem

	cpi	192d+03d		; if >= 193, problem 
	jp	check_dir_actopt_missing

	
					; done with tests
					; return with b = TEMP3

	lda	TEMP3
	mov	b,a			; return count of assigned blocks 


	ret


;-----------------------------------------------------------------------------

check_dir_FF_error:			; TEMP1 points to offending directory entry
					; zero out entry if found
	lxi	h,chkdir_1
	call	RPBMSG
	lhld	TEMP1
	jmp	check_dir_error_FF
	
chkdir_1:	.db	"FF encountered early ...",00h	


;-----------------------------------------------------------------------------
check_dir_repeat_entry:			; hl points to directory entry
					; de points to GEN_1 entry
					; if current one is A then keep it
						; else keep original
	mov	a,m
	ani	11000000b
	cpi	11000000b
	jnz	check_dir_repeat_entry_1	; write current data to GEN_1

	xchg				; zero out entry found first
	lxi	b,GEN_1
	dsub
	mov	a,l
	lxi	h,GEN_1+32d
	add	a
	mov	c,a
	mvi	b,00h
	dad	b			; get GEN_1+32 entry
	xchg
	lhlx				; get pointer to first entry


check_dir_repeat_entry_1:		; entry here to zero out second entry found

	call	blank_directory_entry
					; entry 	hl = pointer to directory entry
					; exit 		none, entry blanked

	lxi	h,chkdir_4
	call	RPBMSG

	call	DELAY
	jmp	scan_directory_structure

chkdir_4:	.db	"Repeated directory entry ...",00h

;-----------------------------------------------------------------------------
check_dir_sys:				; missing system entries - exit REX
	lxi	h,chkdir_5
	call	RPBMSG
	call	DELAY
	ret
; maybe make a routine to copy the system entries?

chkdir_5:	.db	"Missing system entries ...",00h


;-----------------------------------------------------------------------------
active_block_error:		; bad or missing active block info
	lxi	h,chkdir_6
	call	RPBMSG
	call	DELAY
	ret			; do nothing, report error
; maybe make a routine to set to a default number

chkdir_6:	.db	"Bad or missing active block info ...",00h

;-----------------------------------------------------------------------------
check_dir_actram_missing:
	lxi	h,chkdir_7
	call	RPBMSG
	call	DELAY
	ret			; do nothing, report error

chkdir_7:	.db	"Active RAM image missing ...",00h
;-----------------------------------------------------------------------------
check_dir_actopt_missing:
	lxi	h,chkdir_8
	call	RPBMSG
	call	DELAY
	ret			; do nothing, report error

chkdir_8:	.db	"Active OPTION ROM image missing ...",00h
;-----------------------------------------------------------------------------
type_error:				; hl points to bad entry
	lxi	d,chkdir_9
	jmp	check_dir_error
chkdir_9:	.db	"Incorrect entry type ...",00h
;-----------------------------------------------------------------------------
range_error:				; hl points to bad entry
	lxi	d,chkdir_10
	jmp	check_dir_error
chkdir_10:	.db	"Entry block out of range ...",00h
;-----------------------------------------------------------------------------
check_dir_76_error:			; hl points to bad entry
	lxi	d,chkdir_2
	jmp	check_dir_error
chkdir_2:	.db	"Bad directory entry ...",00h
;-----------------------------------------------------------------------------
check_dir_block_error:			; hl points to bad entry
	lxi	d,chkdir_3
	jmp	check_dir_error
chkdir_3:	.db	"Block number error ...",00h

;-----------------------------------------------------------------------------
check_dir_error:
	xchg
	push	d
	call	RPBMSG
	pop	h

check_dir_error_FF:
	call	blank_directory_entry		; zero out problematic entry
	call	DELAY
	jmp	scan_directory_structure 	; restart test


;------------------------------------------------------------------------------
erase_block_a:			; erase block in a, leaving name entry alone.
	
	push	psw
	call	check_flash_ready

#if show_info = 1
	call	clsmsg
	lxi	h,msgerase
	call	RPBMSG
#endif

	pop	psw		; erase the block now if the adjacent sector is blank, then go to name delete

#if real_hardware = 1
	call	erb0		; erase block
#endif

	ret			; now erase the name entry if required

#if show_info = 1
msgerase:	.db	"Erasing...",00h
#endif


;--------------------------------------------------------------------------

display_table:

#if modeltype = 0			; M100/T102
	lxi	h,0303h
#else					; T200
	lxi	h,0307h
#endif


	rst	6
	.dw	POSIT

	call	scan_directory_structure

	call	show_table

	call	hit_any_key

	ret

;-----------------------------------------------------------------------

show_table:

	mvi	b,0FFh		; b = block number 

show_table1:
	inr	b

	mov	a,b
	cpi	32d
	rz

	mov	e,a
	mvi	d,00h
	lxi	h,GEN_1
	dad	d		; get location in utilization table

	mov	a,m		; get byte

	cpi	192d
	jz	print_A		; it is A

	cpi	64d
	jz	print_U		; it is U
	
				; it is blank

print_B:
	mvi	a,'B'
	jmp	print_char		
print_U:
	mvi	a,'U'
	jmp	print_char
print_A:
	mvi	a,'A'
print_char:
	rst	6
	.dw	LCD
	jmp	show_table1
	




;-----------------------------------------------------------------------------------
directory_sort:				; create a 32 byte table at GEN_1+96
					; fill with only A of TYPE entries
					; entries in table at GEN_1+32d are in any order
					; sort the table at GEN_1+32d in order of date/time
					; inreasing values (newest last)
		
					; when a switch occurs, restart loop
					; exit when COUNT-1 entries processed

					; uses SORT variable to decide sort order


	call	fill_GEN_1_96		; prelim data in sort area
					; place all entries of A of TYPE in table
					; should be COUNT entries


	lda	COUNT
	ora	a
	rz				; don't sort if count = 0

	cpi	01h
	rz				; don't sort if count = 1


dir_sort_restart:
	mvi	c,0FFh			; c is pointer to sort table
	mvi	b,00h

dir_sort_loop:
	inr	c

	lda	COUNT
	dcr	a
	cmp	c			; when we hit COUNT, done sort
	rz			
	
	call	get_sort_table_entry	; get current entry address


	xchg				; de points to table
	lhlx				; get address1

	push 	h			; temp store address1

	inr	c
	call	get_sort_table_entry	; get next entry address
	dcr	c

	xchg
	lhlx				; get address2

	xchg				; de = address2
	pop	h			; hl = address1


	push	b
	call	compare_entries		; test which is larger, check type
					; zero next, minus no swap, plus swap
	pop	b
					; zero next, minus no swap, plus swap
	jz	dir_sort_loop		; loop back if no swap, get next pair
	jm	dir_sort_loop

					; positive - swap
swap_table_entries:			; enter with c pointing to entries to swap

	lxi	h,GEN_1+96d
	dad	b			; hl points to address1

	xchg
	lhlx				; get data

	mov	a,h
	mov	h,l
	mov	l,a			; swap
	
	shlx				; store data
	jmp	dir_sort_restart

	
;---------------------------------------------------------------------

get_sort_table_entry:			; c points to sort table entry
	lxi	h,GEN_1+96d
	dad	b
	mov	a,m
	add	a			; a = 2*a

	lxi	h,GEN_1+32d
	mvi	d,00h
	mov	e,a
	dad	d			; advance to next pointer
	ret
	

;-----------------------------------------------------------------------
compare_entries:		; hl, de point to two directory entries

				; return zero = swap
				; return non zero = leave alone

				; hl entry 1, de entry 2


				; compare date and time
					; hl=de, return non zero
					; if sort decending
						; hl>de return non zero
						; hl<de, return zero 
					; if sort ascending
						; hl<de, return non zero
						; hl>de, return zeroreturn


				; date time format ymdhm
				; 7 bits year, 4 bits month, 5 bits day  (16 bits)
				; 8 bits hour, 8 bits minutes (16 bits)

				; bytes 8,9,10,11

				; preserve hl, de, bc

				; compare types of both entries
compare_types:			; c points to table entries
	push	b
	push	h
	push	d

compare_dates:
	lxi	b,08d
	call 	compare_16bits		; zero next, minus no swap, plus swap
	pop	d
	pop	h
	jz	compare_times
	jm	done_date_time
	jp	done_date_time

compare_times:
	lxi	b,10d
	call 	compare_16bits 		; zero next, minus no swap, plus swap

done_date_time:

	pop	b			; restore stack
	ret				; preserve zero bits




compare_16bits:				; based on SUFLAG decide how to set zero bits
					; zero set = swap
					; zero not set = no swap
			
					; hl entry 1
					; de entry 2
	dad	b
	xchg	
	dad	b			; hl = address 2, de = address 1

	mov	b,m
	inx	h
	mov	c,m			; bc holds data 2

	xchg				; hl = address 1, de = address 2

	mov	d,m
	inx	h
	mov	e,m			; de holds data 1
	
	xchg				; hl holds data 1

	dsub				; subtract the two data 16 bit values
					; data1 - data2
					; zero set, equal
					; plus, data1 > data2
					; minus, data1 < data2
	rz				; return_next

	push	psw			; store status

	lda	SUFLAG
	ani	00001000b		; check bit 3 for 1
	jz	sort_dir_down		; if zero, then newest first (ascending order)

sort_dir_up:
	pop	psw
	jp	return_swap
	jm	return_noswap

sort_dir_down:
	pop	psw
	jm	return_swap
	jp	return_noswap




return_swap:
	xra	a
	adi	010h		; set positive, swap
	ret

return_noswap:
	xra	a
	sui 	010h		; set minus - no swap 
	ret




;------------------------------------------------------------------------
search_sector:			; search for a sector in the flash that matches use criteria
				; enter with de = seach bytes
				; return with zero set - found, c = block number
				; not zero, not found
				; 		e  d
				; seach bytes - 00 64, 00 192, 64 64, 64 192, 00 00, 
				;               B  U,  B  A  , U  U , U  A  , B  B ,
				;               l  h
				; c even when bytes match on first pass
				; do not allow returns that are same sector as FREBLK

	push	h

;	mvi	c,00h
	mvi	c,06h		; start at block 6 every time, avoid testing system blocks
	mvi	b,00h

search_sector_loop:		; loop 16 times 

	mov	a,c
	cpi	32d
	jz	search_sector_not_found

	lda	FREBLK
	cmp	c		; compare FREBLK to c
	jz	search_sector_skip

	xri	00000001b	; look at adjacent to FREBLK
	cmp	c		; compare to c
	jz	search_sector_skip


	lxi	h,GEN_1		; start at beginning of table
	dad	b

	mov	a,m		; get first byte from table
	ani	11000000b
	push	psw		; temp store

	inx	h		; advance pointer
	mov	a,m
	ani	11000000b
	mov 	h,a
	pop	psw		; recover
	mov	l,a		; h = byte 1, l = byte 0

	rst	6
	.dw	0018h		; compare hl and de

	jz	search_sector_found		; set zero bit - found
				; c = block number that points to matched search spec

	mov	a,h
	mov	h,l
	mov	l,a		; transpose hl

	inr	c		; increment c to point to next block

	rst	6
	.dw	0018h		; compare de and hl
	jz	search_sector_found			; set zero bit - found
				; c = block number that points to matched search spec

	dcr	c		; decrement c if test failed

search_sector_skip:
	inr	c		; increment block count by 2
	inr	c
	jmp	search_sector_loop


search_sector_not_found:
	ori	01h		; clear zero bit, not found
	jmp	search_sector_exit	

search_sector_found:
	xra	a		; clear zero bit, not found

search_sector_exit:
	pop	h
	ret



;---------------------------------------------------------------------
blank_GEN_1:

	lxi	d,GEN_1		; blank out 96 bytes at GEN_1, 3 bytes per entry
	mvi	b,96d		

blank_GEN_1_entry:
	xra	a
scan_blank_GEN1:
	stax	d
	inx	d
	dcr	b
	jnz	scan_blank_GEN1	

	ret

;---------------------------------------------------------------------
fill_GEN_1_96:			; block numbers for A blocks
				; table at GEN_1+96d


	lxi	d,GEN_1+96d
	mvi	b,32d
	call	blank_GEN_1_entry	; blank out 32 bytes at GEN_1+96d


	mvi	c,0FFh	
	mvi	b,00h
	lxi	d,GEN_1+96d		; pointer to table
	lxi	h,GEN_1-1h

fill_GEN_1_961:
	inr	c
	inx	h

	mov	a,c
	cpi	32d
	rz			; return if done

	lda	TYPE
	ori	11000000b
	cmp	m		; test for A of TYPE

	jnz	fill_GEN_1_961

	mov	a,c
	stax	d		; write block number to table at GEN_1+96
	inx	d	
	jmp	fill_GEN_1_961	


;-----------------------------------------------------------------------------------
filename_sweep:				; test file directory for known trigger files

					; go through each directory entry (skipping fixed entries)
					; check against all n number of names



;--------------------------------------------------------------------------------------
filenames:			; eight bytes each
	.db	"TS-DOS  "
	.db	"UR-2    "
	.db	"Super   "
	.db	"Anlyst  "



;-----------------------------------------------------------------------------------------------
;sys_entries:				; default entries for system, in case they are needed
					; to repair the directory

;	.db	128d+64d+0d;		; system block names
;	.db	"SYSTEM"
;	.db	00000011b
;	.db	10h, 81h,01d,01d
;	.db	0FFh, 0FFh, 0FFh, 0FFh	

;	.db	128d+64d+1d;
;	.db	"SYSBAK"
;	.db	00000011b
;	.db	10h, 81h,01d,01d	
;	.db	0FFh, 0FFh, 0FFh, 0FFh	

;	.db	128d+64d+2d;
;	.db	"MAIN1P"
;	.db	00000011b
;	.db	10h, 81h,01d,01d	
;	.db	0FFh, 0FFh, 0FFh, 0FFh	

;	.db	128d+64d+3d;
;	.db	"MAIN2P"
;	.db	00000011b
;	.db	10h, 81h,01d,01d	
;	.db	0FFh, 0FFh, 0FFh, 0FFh	

;	.db	128d+64d+4d;
;	.db	"MAIN1S"
;	.db	00000011b
;	.db	10h, 81h,01d,01d	
;	.db	0FFh, 0FFh, 0FFh, 0FFh	

;	.db	128d+64d+5d;
;	.db	"MAIN2S"
;	.db	00000011b
;	.db	10h, 81h,01d,01d	
;	.db	0FFh, 0FFh, 0FFh, 0FFh	