;--------------------------------------------------------------------

;active_block_table_start:	.equ	04000h	; start of active block directory
;active_block_table_end:	.equ	043FFh	; end of active block directory
;name_directory_start:		.equ	04400h	; start of block name directory
;name_directory_end:		.equ	04FFFh	; end of block name directory


	.org	04000h
	.fill 4000h,0FFh

		; 4000-43FF - block directory (1k) (512 entries)
		; 4400-4FFF - name directory (3k) (192 entries)
		; 5000-7FFF - unused (12k)



	.org	04000h
						; active block area 4000-43FFh  (1k bytes) (512 entries)
	.db	08h,06h				; set the initial active optrom block to 08h
						; set the initial active ram block to 06h
						; need 2 bytes, one for active optrom, one for active ram


	.org	name_directory_start

				; byte 0 - bit 7 = 0, unassigned block, 1 assigned block
				; byte 0 - bit 6 = stays 1 until block/entry erased
				; byte 0 - bits 0-5 = block number [0-63]
	
				; byte 1 to 6 = rom name (6 characters)

				; byte 7 bit 0,1 = type, 00=ramimage, 01=romimage, 10=bootimage, 11=system
				; byte 7 bit 2,3 = start up sequence for roms
					; 00 = call 63012, 01 = call63013,1, 10 = ?, 11 = ?
					; not implemented - not needed.

				; byte 7 bit 7-4 = unused bits

				; unused blocks have no entry
				; block#<32 = flash, block#>31=ram

				; date time format ymdhm
				; 7 bits year, 4 bits month, 5 bits day  (16 bits)
				; 8 bits hour, 8 bits minutes (16 bits)

				;  0001000 0100 00001 = 10h, 81h
				;  2008   April  1 
				
				; 16 bytes total per record

	.db	128d+64d+0d;	; system block names
	.db	"SYSTEM"
	.db	00000011b
	.db	10h, 81h,01d,01d
	.db	0FFh, 0FFh, 0FFh, 0FFh	

	.db	128d+64d+1d;
	.db	"SYSBAK"
	.db	00000011b
	.db	10h, 81h,01d,01d	
	.db	0FFh, 0FFh, 0FFh, 0FFh	

	.db	128d+64d+2d;
	.db	"MAIN1P"
	.db	00000011b
	.db	10h, 81h,01d,01d	
	.db	0FFh, 0FFh, 0FFh, 0FFh	

	.db	128d+64d+3d;
	.db	"MAIN2P"
	.db	00000011b
	.db	10h, 81h,01d,01d	
	.db	0FFh, 0FFh, 0FFh, 0FFh	

	.db	128d+64d+4d;
	.db	"MAIN1S"
	.db	00000011b
	.db	10h, 81h,01d,01d	
	.db	0FFh, 0FFh, 0FFh, 0FFh	

	.db	128d+64d+5d;
	.db	"MAIN2S"
	.db	00000011b
	.db	10h, 81h,01d,01d	
	.db	0FFh, 0FFh, 0FFh, 0FFh	


	.db	128d+64d+8d		; user image
	.db	"TS-DOS"
	.db	00000001b
	.db	10h, 81h,01d,01d	
	.db	0FFh, 0FFh, 0FFh, 0FFh	

	
	.db	128d+64d+06d		; user image
	.db	"backup"
	.db	00000000b
	.db	10h, 81h,01d,01d	
	.db	0FFh, 0FFh, 0FFh, 0FFh	



	
				; reserved 4C00-5FFFh (5k bytes)
				; DOS directory 6000-7FFF (8k bytes)

