
;--------------------------------------------------------------------
find_actblk_entry:
find_active_block:
; entry 	none
; exit 		hl = pointer to active block location in directory (or potentially end of record - 1)
; exit 		with zero set if end of directory, zero reset if entry found

	lxi	h,active_block_table_start-2d
	lxi	b,active_block_table_end-1d

find_actblk_entry1:
	inx	h
	inx	h			; advance to next entry

	mov	a,h
	xra	b				
	ora	l
	xra	c				; compare bc and hl, see if at end of record
	jz	find_actblk_last_record
	
	inx	h			; increment hl
	mov	a,m			; put 2nd byte in a
	dcx	h			; hl points to start of entry again
	ora	m			; or with first byte, test for 00
	jz	find_actblk_entry1	; if both zero then loop back

	ori	01h			; we found the first non-zero record
	ret				; if both are non zero so return, reset zero bit 


find_actblk_last_record:
	xra	a			; zero is set if hl = de
	ret				; end of directory, not found, set zero ,return			

;---------------------------------------------------------

read_active_block:
; load the ram variables from the directory
; ACTOPT, ACTRAM, ROMSEL
; exit with zero set - end of directory, zero reset, success

; use bit 6 in ACTOPT byte for ROMSEL

	call	find_active_block
;	rz				; return if active block not found

	mov	a,m
	ani	00111111b		; filter out block info
	sta 	ACTOPT

	mov	a,m
	ani	01000000b		; filter out ROMSEL info
	sta	ROMSEL

	inx	h
	mov	a,m
	sta	ACTRAM

	ori	01h			; reset zero bit
	ret

;--------------------------------------------------------------------
refresh_update_directory:
	call	refresh_directories	; if zero set, end of directory - refresh

update_active_block:
update_actblk_directory:		; update the directory to reflect contents of ACTOPT, ACTRAM
					

	call	find_active_block	; point to entry, test for end of record

	jz	refresh_update_directory	; loop back if directory needs refreshing


					; enter with hl pointing to record to erase
	call	double_byte_poke0
	inx	h
	call	double_byte_poke0	; erase entry

	inx	h			; update hl to point to new entry 
					; write ACTOPT, ACTRAM, ROMSEL to actblk directory
					; assumed previous entry is cleared already
	
	push	b
	lda	ACTOPT			; get ACTOPT
	ani	00111111b
	mov	b,a
	lda	ROMSEL			; or with ROMSEL
	ani	01000000b
	ora	b
	pop	b

	call	double_byte_poke	; write ACTOPT + ROMSEL

	inx	h
	lda	ACTRAM
	ani	00111111b
	call	double_byte_poke	; write ACTRAM


	ret
	
