
NUMPRT	.EQU	470BH		; Print binary number in HL at current position
GETTOP 	.EQU 	6E8DH		; GETS TOP ADDRESS OF FILE

TDDPT	.EQU	6D9EH		; Print time ,day,date on first line w/o CLS
;KEYWTU	.EQU	5D64H		; Wait for char from keyboard & convert to uppercase
;MNENTR	.EQU	58F7H		; Handle ENTER key from MENU command loop
;MNCMD	.EQU	58A9H 		; jump back into Handle COMMANDS from MENU command loop
;REBOOT 	.EQU	7D33H		; Boot routine, RST 0 or Reset vector target - initialization.
BEEP	.EQU	4F45H		; BEEP statement

BLKMV	.EQU	41BAH		; Move B bytes from (DE) to M with increment
MVHBI:	.EQU	032A7h		; Move B number of bytes from from M to (DE) with decrement

MVHBCI	.equ	08316H		; Move from HL to DE (incrementing) for BC bytes
MVHBCD	.equ	08321H		; Move from HL to DE (decrementing) for BC bytes


GETTP 	.EQU 	6E8CH		; GETS TOP ADDRESS OF FILE
LINKER1	.equ 	061FH		; links a .BA file


KILDC	.EQU	2AA2H		; KILL DO CO FILE TYPE
KILB 	.EQU	2B0CH		; KILL BA FILE TYPE

KILD	.equ	2AB5H		; entry that kills .DO and returns properly
KILC	.equ	2ACEH		; entry that kills .CO and returns properly


UPCAS	.EQU	1014H		; CONVERT TO UPPER CASE

LNKFIL	.EQU	2C62h		; link files in directory

ALTLCD	.EQU	0F7B0h		; altlcd buffer
ALTLCDE	.EQU	0FA2Fh		; end of altlcd buffer
STDLCD	.EQU	0FA30h		; start of standard LCD
STDLCDE	.EQU	0FCAFh		; end of standard LCD

STREND 	.EQU	0F669h		; End of storage/ first free byte


;ASCTAB	.equ	0F661H		; Pointer to start of ASCII files
BINTAB 	.equ	0F663H	 	; Pointer to start of binary files
VARTAB 	.equ	0F665H		; Pointer to start of simple variable space
ARYTAB 	.equ	0F667H		; Pointer to start of array table






;-----------------------------------------------------------------------
; M100/T200 specific variables
;-----------------------------------------------------------------------

DIRLEN:		.equ	11d		; number of bytes per directory entry
NAMLEN:		.equ	8d		; number of bytes per name entry
MAKUPS:		.equ	1013H		; convert character to uppercase

PRBUF		.EQU	3517h		; print at cursor from hl buffer till 00

NAMES:		.equ	7d		; number of fixed entries in directory table
TOTAL_NAMES:	.equ	45d		; total number of names in directory ? check?

ASCTAB:		.equ	0F661h		; points to the lowest address of .DO files
NULDIR:		.equ	0F295h		; points to unsaved basic program
SCRPD:		.equ	0F2B5h
INPUT_BUFFER:	.EQU	0EF70H		; text input buffer
EOFFIL:		.equ	1Ah		; EOF character for .DO files
TMRHK:		.equ	0EEC2h		; M100 timer hook
ROM_ID:		.equ	0F4D3h		; M100 rom id location
ROMstart:	.equ	0EEEFh 		; M100 location to start the optrom 
LOWRAM:		.equ	0F4EEh		; address of lowest ram location, 8000h in 32k M100
LCDPTR:		.equ	STDLCD+240d+2d	; 7th row, 3rd column

LRAMRF:		.equ 	0FEACh		; two bytes that store "start of video memory in 8k ram


SETHOK:		.equ	09B17h		; sets up the hook table to default

;32 x 9CA8h  at F507h
;18 x 0906h  at F547h

HOOKT1:		.equ	0F507h		; hook table start in RAM 
HOOKL1: 	.equ	032d		; hook table length (pairs) (32)
HOOKD1:		.equ	09CA8h		; hook table data 

HOOKT2:		.equ	0F547h		; hook table start in RAM 
HOOKL2: 	.equ	018d		; hook table length (pairs) (18)
HOOKD2:		.equ	00906h		; hook table data 

RAMLD:		.equ	0EEC8h		; 36 byte area copied on power up
RAMLDS:		.equ	0372h		; location in ROM for ram bytes
RAMLDL:		.equ	42d		; number of bytes to copy on power up
					; copy right up to option rom flag

; option rom flag is EEF3 in T200, F62A in M100
; copy F605 to F62A - 37 bytes  M100
; copy EEC8 to EEF3 - 43 bytes  T200

KYBCNT:		.equ	0FD1Eh		; keyboard count
MENCNT:		.equ	0F848h		; current menu selection count


;TIMYR1:		.equ	0F92D		;not needed in t200?


SNDCOM	.equ	864FH

;Send a character to the RS-232 without 
;XON/XOFF flow control.  On entry, C 
;contains character to be sent.  Exit 
;conditions are unknown.

; Constants

RSTAT	.equ	0EF3Ch
;* Text string containing the current
;RS-232 setting as follows:  BAUD,
;Length, parity, Stop Bits, XON/XOFF
;switch.

