
;variant for REX:

#include        "T200rom_published_lib.asm"
#include        "T200rom_unpublished_lib.asm"

;LOWRAM:		.equ	0F4EEh		; address of lowest ram location, 8000h in 32k M100

	.org 	58000-6d

	.dw	start
	.dw	end-start
	.dw	start
start:	

adjust_lowram:				; enter with bc = desired size of LOWRAM
					; could be 0 or the length of a file
					; lowram could move up or down
					; assume it is safe to do so, interrupts off etc.

; enter with hl = hole size
; call58000,,x

	mov	d,h	; store size of hole required in de
	mov	e,l

        LHLD 	LOWRAM		; lomem pointer

	lxi	b,0A000h
	push	b		; store A000 on stack

	dsub			; hl=hl-bc, hl is current size of lowram space

				; hl is current lowram space
				; de is desired lowram space


	rst	3
;	rst	6
;	.dw	0018h		; compare hl, de 


	jz	adjust_nochange

	push	psw		; store state   nc = hl>de, z = hl=de, c = hl < de

				; carry set when expansion
				; carry cleared when contraction

	jnc	adjust_lowram_noswap		; if current hole is larger than desired, go here
				; take this path if current hole is smaller than desired

	xchg			; swap hl and de, so larger is in hl
				; take this path when de>hl, expansion

adjust_lowram_noswap:		; hl > de

	mov	b,d
	mov	c,e		; hl > bc

	dsub			; hl = delta hole size

	mov	b,h
	mov	c,l		; bc = delta hole size

	pop	psw		; get back flags

	pop	h		; hl = A000
	

	push	b
	jnc	adjust_lowram_shrink	; carry set when expansion
					; carry cleared when contraction

 	CALL 	MAKHOL		; Make a hole of BC bytes at HL

	pop	b
	jmp	adjust_lowram_pointers

      
adjust_lowram_shrink: 

        CALL 	MASDEL		 ;Delete BC number if characters in a text file
    
	pop	b
	lxi	h,0000h
	dsub
	
	mov	b,h
	mov	c,l		; compliment of hole size



adjust_lowram_pointers:		; bc holds value to correct
	lhld 	ASCTAB		
        dad	B
        shld	ASCTAB		; correct ASCTAB
        
	lhld	LOWRAM


	dad	b
	shld	LOWRAM		; correct LOWRAM

	ret
;  	JMP 	2C62h		; Fix up directory pointers

adjust_nochange:
	pop	b
	ret

end:	.end