; Menu program for Remem in M100/T102
; loosely based on MENU.BA from PG designs
; bug fix for map number

; version 1.2, Aug 19, 2007

				; CONSTANTS
START	equ	08035H 		; 8039 - 4: 8039 is the execution location
				; 8035h for basic
				; c000 -6, bffa for co

 				; append this to the end of the basic loader, it will be shifted from
				; 83A9 to 8035



HCHSNS	equ	0FAE0H		; this is the modified hook address
				; this is called from inside Menu - add 3 to get to new pc
HCALL1 	equ	5DH		; this is the location that CHSNS is called from 
HCALL2 	equ	78H

HKVAL	EQU	7FF3H		; this is the default hook table entry
FNBITS 	EQU	0FF98H		; location that holds fn key selection


				; M100 ROUTINES
MENU	equ	5797H
POSIT	EQU	427CH		; Set the current cursor position
NUMPRT	EQU	39D4H		; Print binary number in HL at current position
GETTOP 	EQU 	5AE4H		; GETS TOP ADDRESS OF FILE
CHSNS	EQU	13DBH		; Check keyboard queue
TDDPT	EQU	5A15H		; Print time ,day,date on first line w/o CLS
KEYWTU	EQU	5D64H		; Wait for char from keyboard & convert to uppercase
MNENTR	EQU	58F7H		; Handle ENTER key from MENU command loop
MNCMD	EQU	58A9H 		; jump back into Handle COMMANDS from MENU command loop
REBOOT 	EQU	7D33H		; Boot routine, RST 0 or Reset vector target - initialization.
BEEP	EQU	4229H		; BEEP statement
CHGET	EQU	12CBH		; WAIT FOR CHARACTER FROM KEYBOARD
BLKMV	EQU	3469H		; Move B bytes from (DE) to M with increment
GETTP 	EQU 	5AE3H		; GETS TOP ADDRESS OF FILE
KILDC	EQU	1FB2H		; KILL DO CO FILE TYPE
KILB 	EQU	2017H		; KILL BA FILE TYPE
INLIN	EQU	4644H		; GET INPUT LINE
UPCAS	EQU	0FE9H		; CONVERT TO UPPER CASE


				; FILE TYPES:  B0 = ROM FILE, 80 = BASIC, C0 = DOCUMENT
				; A0 = MACHINE LANGUAGE

	.org	start



				; this file is embedded into the basic loader at 83A7.  The loader reduces the file size in
				; the lead in such that this file eventually starts at 8035.  The initial 4 bytes are
				; required to form the basic line.  The program entry is 8039.
				; once this file is appended to the loader, the line number pointers must be done manually.
				; ex.  line 1 == pointer to line two... LSB, MSB

;#######################################################################################################
line1:	Db	00h			; LINE 1
	db	00h			; this value is the next line
	DB	01H			; line number 257
	DB	01H
;#######################################################################################################
				;initialization
entry:	LXI H,	HOOK1
	SHLD	HCHSNS		; store hook1 in FAE0 (RST7) CHSNS - Check keyboard queue
	JMP     MENU		; jump to menu start
;#######################################################################################################

				; MAIN SUBROUTINE, CALLED FROM CHSNS
HOOK1:	DI     			; IMPORTANT TO DISABLE INTERRUPTS HERE

				; DETECT IF THE HOOK WAS CALLED FROM INSIDE THE EXISTING MENU PROGRAM
	INX 	SP     		; STACK DECREMENTS WHEN PUSHED, SO INCREMENTING 2X GOES BACK 1 REGISTER
				; PAIR ON THE STACK
	INX 	SP
	XTHL			; ADVANCE SP TWICE, AND EXCHANGE HL WITH SP
	DCX 	SP
	DCX 	SP
	PUSH 	PSW		; PUSH PSW ONTO CURRENT STACK, so it can be returned if necessary to
				; whatever called it.
	MOV 	A,H
	CPI     HCALL1
	JNZ     NOTMNU     	; IF THE VALUES ARE NOT EQUAL THEN WE KNOW WE WERE NOT CALLED FROM
				;THE MENU SO RETURN
	MOV 	A,L
	CPI	HCALL2

	JZ	INMNU		; IF THE VALUE READ FROM THE STACK IS 5D78H, THEN IT WAS CALLED FROM
				; THE CORRECT LOCATION, SO CARRY ON
				; HOOK WAS NOT CALLED FROM THE CORRECT PLACE, SO RESTORE THE STACK
				; AND RETURN
NOTMNU:	POP 	PSW
	INX 	SP
	INX 	SP
	XTHL
	DCX	SP
	DCX	SP     		; REPLACE THE VALUE ON THE STACK, AND RETURN
	EI
	RET


INMNU:	POP 	H	        ; IF IT IS CORRECT, THEN WE WANT TO TAKE 4 POPS FROM THE STACK (WHY?)
				; pop the PSW..and discard
	POP 	H		; pop the return address that called CHSNS

	POP 	H               ; pop 2 more values...assumed so that the stack is restored from
				; items that called routine
	POP 	H               ; at 5D70 - returns the stack to the level where menu was
				; originally called or jumped to.
				; the first pop should remove an HL value from the stack
				; and the second should remove 5860H from the stack
	EI

				; set up the display

NEWMNU:	LXI H,	1B01H  		; SET DISPLAY LOCATION TO ROW 1 COLUMN 1B
	CALL	POSIT		; Set the current cursor position
	MVI D,	0DH
	CALL    PDSP		; prints D spaces at screen location HL
	LXI H,	1E01H      	; SET DISPLAY LOCATION TO ROW 1 COLUMN 1E
	CALL	POSIT		; Set the current cursor position
	CALL    SZVAL		; decides if the number should be from file size or free memory
				; RETURNS WITH SZ NUMBER in BC
	PUSH 	B
	POP 	H
	CALL	NUMPRT    	; Print binary number in HL at current position

	LXI H,	0108H		; SET DISPLAY LOCATION TO ROW 8 COLUMN 1
	LXI D,	TITL1		;

	CALL    PRTTXT		; prints D spaces at screen location HL

	CALL	KEYWT		; PRINT TIME AND WAIT FOR A KEY
	MOV B,A 		; PLACE RESULT IN A
	XRA A
	CMP B			; SEE IF B = 0 (FUNCTION KEY IS PRESSED)
	JNZ	NOTCMD		; IF NOT A FUNCTION KEY THEN SKIP NEXT SECTION - NO COMMAND TO EXECUTE


				; HANDLES THE CASE WHERE A FUNCTION KEY IS SELECTED FROM MENU
	LXI H,	NEWMNU     	; PUSH START OF MENU ROUTINE ONTO STACK
	PUSH H
	LDA	0FF98H		; LOAD A WITH VALUE IN FF98 (CONTAINS VALUE THAT INDICATES WHAT
				; FN KEY IS PRESSED)


	RAL			; ROTATE LEFT...NOW WE CAN TEST FOR BIT 8

	JC	EXIT		; KEY 8 - EXIT  -- THIS PATH HAS TO EXIT AND RESTART THE MENU PROGRAM

	RAR			; two right rotates to get back to bit 1
	RAR
	RAR
	JC	JUMP		; KEY 2 - JUMP -- THIS PATH HAS TO EXIT AND RESTART THE MENU PROGRAM
	RAR
	JC 	INIT		; KEY 3 - INIT -- THIS PATH HAS TO EXIT AND RESTART THE MENU PROGRAM

	PUSH 	PSW

	CALL	GETBYT		; GET TOP BYTE OF FILE INDICATED IN FDEE -B RETURNS WITH FILE TYPE
	CPI	0B0H         	; SEE IF THIS IS A ROM FILE TYPE
	JZ	CMDDN

	POP 	PSW

	RAR
	RAR
	JC	KILLF		; KEY 5 - KILL  -- THIS PATH HAS TO EXIT AND RESTART THE MENU PROGRAM
	RAR
	JC	NAMEF		; KEY 6 - NAME  -- THIS PATH HAS TO EXIT AND RESTART THE MENU PROGRAM
	RAR
;	JC 	MCPY		; KEY 7	- MCOPY  -- THIS PATH HAS TO EXIT AND RESTART THE MENU PROGRAM

	RET

CMDDN:	POP 	H
	RET                     ; SHOULD RETURN BACK TO NEWMNU





NOTCMD:	MOV A,B 		; RELOAD B
	CPI      0DH		; COMPARE TO ENTER
	JZ       MNENTR		; Handle ENTER key from MENU command loop

	LXI B,   NEWMNU
	PUSH B                 	; CORRECT THE MENU ENTRY POINT IN THE STACK

	CPI      21H 		; COMPARE B TO '!'  (WHY?)
	RNC 			; RETURN TO NEWMNU IF KEY PRESSED > 21 (IGNORE ASCII ENTRIES)
	CPI      20H            ; COMPARE IT TO SPACE
	JNZ      NUMNU2 	; JUMP AHEAD IF IF NOT A SPACE
	MVI A,   1CH		; LOAD A WITH RIGHT ARROW IF A SPACE IS PRESSED

NUMNU2:	PUSH PSW		; PUSH THE VALUE OF THE KEY SELECTED ONTO STACK
	LDA	0FDEEH		; LOAD E WITH THE VALUE AT FDEE (FILE SELECTED)
	MOV E,A
	POP PSW			; RESTORE VALUE OF KEY SELECTED
	SUI      1CH		; SUBTRACT 1C FROM ACCUMULATOR - 1C, 1D, 1E, 1F TURN INTO 0,1,2,3
	JMP      MNCMD	 	; jump back into ROM MENU TO Handle COMMANDS from MENU command loop
				; IT WILL RETURN TO NEWMNU
;#######################################################################################################
PDSP28:	LXI H,	0108H
	MVI D,	28H
				; PDSP prints D spaces at screen location HL
PDSP:	PUSH D
	CALL	POSIT		; Set the current cursor position
	POP D
PDSP1:	MVI A,	20H
	RST 4                   ; RST 4 Send character in A to screen/printer
	DCR D
	JNZ	PDSP1		; loop back if d not zero
	RET
;#######################################################################################################
SZVAL:	CALL	GETBYT		; get first byte of selected file directory entry
	CPI	0B0H		; test for rom program
	JZ	SZVAL1
	CPI	0F0H		; test for trigger file
	JZ	SZVAL1
	CPI	80H		; test for basic program
	JZ	SZVAL3
	CPI	0A0H		; test for machine language
	JZ 	MLSZ
	JMP     DOSZ		; JUMP HERE IF DO FILE
;#######################################################################################################
				; subroutine - calculates size displayed for rom programs,
				; or trigger files (shows system free memory)
SZVAL1:	LHLD	0FBB2H
	XCHG
	LHLD	0F678H
	CALL	SZVAL2
	LXI H,	0FFF2H
	DAD B
	PUSH H
	POP B
	RET
;#######################################################################################################
SZVAL2:	MOV A,L
	SUB E
	MOV C,A
	MOV A,H
	SBB D
	MOV B,A
	RET
;#######################################################################################################
				;subroutine - calculates the size number for a basic program
SZVAL4:	CALL	GETBYT          ;get first byte of selected file's directory entry
				;load HL and A
SZVAL3:	CALL	5AE3H 		;Get start address of file at M
	XCHG
	PUSH D
	CALL	05F4H    	; Builds BASIC line pointers.
	POP D
	INX H
	CALL	SZVAL5
	DCX B
	DCX B
	RET
;#######################################################################################################
	DB	00H		; LINE 2
line2:	Db	00h
	db	00h
	DB	02H		; line 258
	DB	01H
;#######################################################################################################
SZVAL5:	MOV A,L
	SUB E
	MOV C,A
	MOV A,H
	SBB D
	MOV B,A
	RET
;#######################################################################################################
				;subroutine - calculates the size of a machine language program
MLSZ1:	CALL	GETBYT
MLSZ:	CALL	5AE3H		;Get start address of file at M
	PUSH H
	CALL	21A4H   	;
	POP D
	CALL	SZVAL5
	RET
;#######################################################################################################
DOSZ1:	CALL	GETBYT

DOSZ:	CALL	5AE3H 		;Get start address of file at M
	PUSH H
	LXI B,  0FFFFH
	INX B
	MVI A,	1AH
DOSZ2:	CMP M
	INX H
	INX B
	JNZ	DOSZ2
	DCX B
	POP H
	RET
;#######################################################################################################
PRTTXT:	PUSH D
	CALL	POSIT     	; Set the current cursor position (H=Row,L=Col)
	POP H
	CALL	PRNTFF
	RET
;#######################################################################################################
PRINTF:	INX H
PRNTFF:	MOV A,M					; PRINTS TILL FF RECEIVED
	INR A
	RZ
	DCR A
	RST 4
	JNZ	PRINTF
	RET
;#######################################################################################################
				;subroutine - called before file sizes are calculated
				;appears to offset the value loaded in HL by an amount determined
				; by the contents of FDEE
				;returns with a start address of selected file in the directory,
				; which is in a table at FDA1
				;returns with first byte of file's directory entry in A

GETBYT:	LDA	0FDEEH		; memory location in alt LCD, stores the file selection on the screen
	LXI H,	0FDA1H		; START OF A TABLE WITH FILE NAMES IN IT
	LXI D,	0102H		; BEGIN CHECKING FROM THE BACK OF THE TABLE
	DCR D
GETBT1: ORA A
	JZ	GETBT2
	DAD D			; adds de to HL into HL
	DCR A
	JMP	GETBT1		; loop back as a is decremented from initial value in FDEE
GETBT2:	CALL    GETTOP 		; Get start address of file at M, returns with address in HL
	MOV A,M			; load a with first byte of file
	RET

;#######################################################################################################
				; THIS SUBROUTINE PRINTS OUT THE TIME AND WAITS FOR A KEY TO BE PRESSED
KEYWT:	lxi h,	2401h		; display rampac status
	call	posit

	in	112		; get status byte from remem
	ani	2
	jnz	rpnorv

	call 	rvid

rpnorv:	mvi a,	52h		; R
	rst 4			; print it

	call 	nvid

	lxi h,	2601h		; display mode and map number
	call	posit

	in	112		; get status byte from remem
	ani	1
	jnz	monorv

	call 	rvid

monorv:	in	112
	ani	38h		;0011 1000  38h
	rrc
	rrc
	rrc
	ori	30h		; form the map number
	rst 4			; print it

	call	nvid


	CALL	CHSNS  		; Check keyboard queue
	PUSH PSW
	CZ	TDDPT		; Print time ,day,date on first line w/o CLS
	POP PSW
	JZ	KEYWT
	CALL	KEYWTU		; Wait for char from keyboard & convert to uppercase
	RET

rvid: 	mvi a,	1bh		;esc
	rst 4

	mvi a,	70h		;p - turn on reverse vid
	rst 4
	ret

nvid:	mvi a,	1bh		;esc
	rst 4

	mvi a,	71h		;q - turn off reverse vid
	rst 4
	ret
;#######################################################################################################
				; THIS SUBROUTINE RESETS THE VALUE OF THE MODIFIED HOOK ENTRY, AND EXITS
EXIT:	LXI H,  HKVAL
	SHLD 	HCHSNS 		; store 7FF3 in FAE0 (RST7) (RST COMMAND)
	JMP	MENU    	; MENU start
;#######################################################################################################
ERROR2: POP H                   ; ERROR ROUTINES
ERROR1:	POP H
ERROR:	CALL	BEEP		; BEEP statement
	RET
;#######################################################################################################
PFN:	INX H			; ENTRY HL POINTING TO DIRECTORY ENTRY
	INX H       		; SKIP THRICE
	MVI B,	06H		; PRINT 6 filename characters
	call	PFN1		; PRINTS B BYTES TO SCREEN FROM (HL) INCREMENTING HL

	mvi a, 046		; "."
	RST 4			; print .

	mvi b, 02H		; print the extension

PFN1:	INX H			; PRINTS B BYTES FROM M INCREMENTING HL
PFN2:	MOV A,M
	RST 4
	DCR B
	JNZ     PFN1
	RET
;#######################################################################################################
	DB	00H		; LINE 3
line3:	db	00h			
	db	00h
	DB	03H		; line 259
	DB	01H
;#######################################################################################################
KILLF:	CALL	TRAPF
	PUSH H
	CALL	PDSP28
	LXI H,	0108H
	LXI D,  KILLT
	CALL	PRTTXT
	POP H
	PUSH H
	CALL	PFN
	LXI H,	AYS		; print out ARE YOU SURE
	CALL	PRNTFF
	CALL	KEYWT
	CPI	59H     	; Y
	POP H
	RNZ			; RETURN IF NOT EQUAL TO Y

				; PROCEED WITH KILL
	PUSH H
	CALL	GETTP		; Get start address of file at M
	XCHG
	POP H
	MOV A,M
	CPI	80H		; IF FILE TYPE IS BASIC
	JZ	KILLB	  	;
	CALL	KILLDC	   	;
	JMP     MENU		; MENU start


;#######################################################################################################
KILLDC:	PUSH H
	JMP	KILDC		; KILL OTHER FILE TYPES
;#######################################################################################################
KILLB:	CALL	KILB		; KILL THE BASIC FILE TYPE
	JMP	MENU		; MENU start
;#######################################################################################################
					;subroutine TRAPS THE SITUATION WHERE THE FILE CAN'T BE COPIED					;OR KILLED
TRAPF:	CALL	GETBYT
	CPI	0B0H
	JZ	ERROR1
	CPI	0F0H
	JZ	ERROR1
	RET
;#######################################################################################################
				;subroutine rename a file
NAMEF:	CALL	PDSP28
	LXI H,	0108H
	LXI D,	RNM		; RENAME
	CALL	PRTTXT
	CALL	MOVNAM
	CALL	GETBYT
	PUSH H
	CALL	PFN
	LXI H,	TO
	CALL	PRNTFF
	CALL	INLIN  		; Input and display (no "?") line and store
	CALL	GETNAM
	CALL	NAMEF1
	POP H
	JNZ 	ERROR
	INX H
	INX H
	INX H
	LXI D,	0FC93H
	MVI B,	08H
	CALL	BLKMV		;Move M bytes from (DE) to M with increment
	JMP	MENU		;MENU start
;#######################################################################################################
MOVNAM:	CALL	GETBYT          ; MOVE NAME OF FILE TO BUFFER AT FC93
	INX H
	INX H
	INX H
	LXI D,	0FC93H
	XCHG
	MVI B,	08H
	JMP	BLKMV   	; Move M bytes from (DE) to M with increment
;#######################################################################################################
GETNAM:	LXI H,	0F685H
	LXI D,	0FC93H
	MVI B,	06H
	MOV A,M
	ANA A
	JZ	ERROR2
	CPI	41H
	JC	ERROR2
GETNM1:	CALL	UPCAS    		; Convert A to uppercase
	STAX D
	DCR B
	RZ
	INX H
	INX D
	MOV A,M
	ANA A
	JZ	GETNM2
	CPI	2EH
	JNZ	GETNM1
GETNM2:	MVI A,	20H
	DCX H
	JMP	GETNM1
;#######################################################################################################
	DB	00H			; LINE 4
line4:	db	00h			
	db	00h
	DB	04H			; line 260
	DB	01H
;#######################################################################################################
NAMEF1:	CALL	2146H			; NEW statement??
	CALL	20AFH         		; NAME statement??
	RNZ
	LXI H,	0FFFFH
	INX H
	SHLD	0F67EH
	LHLD	0F652H
	PUSH H
	LXI H,	NMCONT
	SHLD	0F652H
	CALL	20E4H  			;NAME statement??
NMCONT:	POP H                    	;ALLOWS RETURN TO HERE FROM NAME, WHICH TYPICALLY RETURNS TO BASIC
	SHLD	0F652H
	RET
;#######################################################################################################
JUMP:	CALL	PDSP28		; CLEAR OUT BOTTOM ROW

	LXI H,	0108H		; START AT BOTTOM ROW 1ST CHARACTER
	CALL	POSIT

	IN	112		; GET STATUS BYTE
	ANI	01		; AND WITH 1
	MOV	C,A		; STORE RESULT IN C
	MVI B,	30H		; STORE 30H '0' IN B

JUMPL:	CALL	MAPLOP

	XRA	A		; ZERO A
	ORA  	C		; OR A WITH C
	JZ	JUMPLD		; JUMP IF C = 0 TO MAPLD
	INR	B
	MOV A, 	B		; LOAD a WITH B
	CPI	38H		; COMPARE WITH 38H
	JNZ	JUMPL		; LOOP BACK IF B <> 38 -- SHOULD PRINT OUT MAPX 8 TIMES
				; SHOULD ONLY PRINT OUT MAP0 IF MODE = 0

				; C HOLDS MODE

JUMPLD:	CALL 	GETFN		; RETURNS WITH B = SELECTION MAP NUMBER 0-7

	CALL 	GETCMP		; PUT CURRENT MAP IN A AND C

	IN	112
	ANI	01		; LOAD MODE INTO A

	JNZ	GO		; IF MODE IS ONE, DONE, IF NOT CHECK...

MODE0:	MVI	C,01H		; IF MODE IS ZERO, THEN MAKE SOURCE MAP 00
	DCR	C		; CAN'T USE A 00.....

	XRA	A		; ZERO A
	CMP 	B		; TEST FOR B=0

	JNZ	ERROR		; IF B WAS NOT ZER0 ie ANOTHER FN KEY PRESSED, ERROR AND MENU
				; WITH REMEM, MAP ZERO MUST BE EQUAL TO NORMAL MODE


				; CARRY ON WITH THE CHANGE
				; ASSUME THE MAPS ARE LINEAR FROM THE FIRST 2 BYTES
				; ASSUME v4 FIRMWARE

				; b holds target map, c holds current map


GO:	LXI	D, JMPMSG
	CALL 	PRTMM

	DI

	IN 	112
	ORI	04H
	OUT	112		; TURN ON MAPS, LEAVING MODE unchanged



	CALL	STORD		; STORE CURRENT MAP DATA INTO STOR LOCATIONS

	MVI	D,1FH		; TARGET MEMORY BLOCK
	MVI	E,01H		; LOAD D WITH BYTE LOCATION AND E WITH RECORD NUMBER WITHIN MAP
	CALL	TFRDAT		; PLACE THE DATA FROM TARGET INTO SOURCE MAP


				; READY TO POKE IN CODES

				; put the correct target data into SWDATA
	LXI	H,SWDATA
	INX	H
	INX	H
	MOV	A,B		; LOAD A WITH TARGET MAP
	RLC
	RLC
	RLC			; ROTATE LEFT 3 TIMES
	ORI	01H		; OR WITH 01H
	MOV	M,A		; STORE THIS TARGET MAP DATA
				; THIS DATA IS MODE 1, RAMPAC OFF, MMU ACCESS OFF




	LXI	H, 0FCC0h	; SOURCE ALTLCD BUFFER
	CALL	POKDAT

	XRA	A		; LOAD H INTO A, PUT 0 IN H
	MOV	H,A
	CALL 	POKDAT

				; DATA POKED..

	CALL	RESTOR
	JMP	0FCC0H		; CALL THE JUMP

				; DOESNT MATTER WHAT HAPPENS NOW, IN ANY CASE
				; WE GET RST0


;#######################################################################################################
POKDAT:	MVI	D,09H		; POKE THE DATA FROM STOR INTO MEMORY AT HL
	PUSH	H
	LXI	H,SWDATA

POKLOP:	MOV	A,M
	INX	H
	XTHL

	MOV	M,A
	INX	H
	XTHL

	DCR	D
	JNZ	POKLOP		; LOOP 6 TIMES

	POP	H
	RET
;#######################################################################################################
GETMAP:	RLC			; INPUT IN A, NUMBER 0-7
	RLC
	ANI	1CH		; and with 00011100  4+8+16 = 28, equals 1CH
	ORA	D
	OUT	97		; SEND TO PORT 97
	RET
;#######################################################################################################
ADVANC:	MOV	A,D
	ANA	A		; AND a WITH a
ALOOP:	RZ
	IN	99		; ADVANCES IN RECORD D TIMES
	IN 	99
	DCR	D
	JMP	ALOOP
;#######################################################################################################
	DB	00H		; LINE 5
line5:	db	00h			
	db	00h
	DB	05H		; line 261
	DB	01H
;#######################################################################################################
INIT:	CALL	PDSP28		; CLEAR OUT BOTTOM ROW


	LXI H,	0108H		; START AT BOTTOM ROW 1ST CHARACTER
	CALL	POSIT

	IN	112		; GET STATUS BYTE
	ANI	01		; AND WITH 1
	JZ	ERROR		; BEEP AND MENU NO POP

	MVI B,	30H		; STORE 30H '0' IN B

INTL:	CALL	MAPLOP

	INR	B
	MOV A, 	B		; LOAD a WITH B
	CPI	38H		; COMPARE WITH 38H
	JNZ	INTL		; LOOP BACK IF B <> 38 -- SHOULD PRINT OUT MAPX 8 TIMES
				; SHOULD ONLY PRINT OUT MAP0 IF MODE = 0

	CALL 	GETFN		; RETURNS WITH B = SELECTION MAP NUMBER 0-7
	CALL	GETCMP		; PUT CURRENT MAP IN A AND C
	CMP	B		; COMPARE TO B
	JZ	ERROR		; IF CURRENT MAP = B THEN BEEP AND MENU NO POP

	PUSH 	B

	LXI	D, INTMSG
	CALL 	PRTMM

	LXI H,	AYS		; print out ARE YOU SURE
	CALL	PRNTFF
	CALL	KEYWT
	CPI	59H     	; Y
	JNZ	MENU		; RETURN IF NOT EQUAL TO Y

	POP	B

				; WE CAN INITIALIZE RAM IN MAP B - CURRENT MAP IN C

INITS:	IN 	112
	ORI	04H
	OUT	112		; TURN ON MAPS, LEAVING MODE THE SAME


	CALL	STORD		; STORE CURRENT MAP DATA INTO STOR LOCATIONS


	DI

	MVI	D,1FH		; START AT 1F AND LOOP TILL 00
INITLP:	MVI	E,01H		; LOAD D WITH BYTE LOCATION AND E WITH RECORD NUMBER WITHIN MAP
	PUSH 	D
	CALL	TFRDAT		; PLACE THE DATA FROM TARGET INTO SOURCE MAP
	POP	D

	LXI	H, 03FFH	; TOP OF FIRST BLOCK IN MEMORY

INTLP1:	XRA	A		; ZERO A
	MOV	M,A		; WRITE 00 TO MEMORY

	MOV	A,H
	ORA	L		; OR H AND L
	JZ	NEXTR		; IF HL= 0000 THEN GOTO NEXT RECORD
	DCX	H
	JMP	INTLP1

NEXTR:	XRA	A		; ZERO A
	ORA	D		; OR A AND D
	JZ	INITDN		; LOOP TO DO ANOTHER BLOCK IF D <> 00
	DCR	D		; DECREMENT D
	JMP 	INITLP

INITDN:	CALL	RESTOR		; RESTORE THE ORIGINAL MAP DATA

	IN	112
	ANI	0FBH		; 1111 1011
	OUT	112		; TURN OFF MAPS

	EI

	JMP	MENU		; DONE, RESTART MENU


;#######################################################################################################
RESTOR:	MOV	A,C		; SOURCE MAP
	MVI	D,01H		; ROM RECORD
	DCR	D		; CAN'T USE A 00....
	CALL	GETMAP		; CONVERT MAP TO RECORD NUMBER, AND SEND TO 97

	LXI	H,STOR1		; POINT HL TO STOR1

	MOV	A,M
	OUT 	99

	LXI	H,STOR2		; POINT HL TO STOR2
	MOV	A,M
	OUT 	99		; RESTORE THE ORIGINAL DATA FROM THE SOURCE MAP
	RET
;#######################################################################################################
STORD:	MOV	A,C		; SOURCE MAP
	MVI	D,01H		; ROM RECORD
	DCR	D		; CAN'T USE A 00....
	CALL	GETMAP		; CONVERT MAP TO RECORD NUMBER, AND SEND TO 97


	LXI	H,STOR1		; POINT HL TO STOR1
	IN 	99
	MOV	M,A
	LXI	H,STOR2		; POINT HL TO STOR2
	IN 	99
	MOV	M,A		; STORE THE ORIGINAL DATA FROM THE SOURCE MAP
	RET
;#######################################################################################################
TFRDAT:	PUSH	D

	MOV	A,B		; TARGET
	MOV	D,E		; PLACE RECORD NUMBER IN D
	CALL 	GETMAP		; A holds the map #, d holds specific record 0-3
				; CONVERT MAP TO RECORD NUMBER, AND SEND TO 97


	POP 	D
	CALL	ADVANC		; ADVANCE IN TARGET RAM MAP BY VALUE IN D


	IN 	99
	MOV	E,A
	IN	99
	MOV	D,A		; GET THE DATA FROM THE TARGET MAP

	PUSH 	D

	MOV	A,C		; SOURCE
	MVI	D,01H		; ROM RECORD
	DCR	D		; CAN'T USE A 00.....
	CALL	GETMAP		; CONVERT  MAP TO RECORD NUMBER, AND SEND TO 97

	POP 	D

	MOV	A,E
	OUT	99
	MOV	A,D
	OUT 	99		; WRITE NEW DATA TO MAP


	RET
;#######################################################################################################
GETCMP:	IN	112
	ANI	56
	RAR
	RAR
	RAR
	MOV	C,A		; A AND C NOW HOLDS THE CURRENT MAP NUMBER (NUMBER 0-7)
	RET
;#######################################################################################################
PRTMM:	PUSH	B		; TEMPORARILY SAVE B
	PUSH	D		; D POINTS TO TEXT TO PRINT TERMINATED IN FF
				; B HOLDS MAP NUMBER
	CALL	PDSP28		; CLEAR BOTTOM LINE
	LXI H,	0108H		; SET DISPLAY LOCATION TO ROW 8 COLUMN 1
	POP	D
	CALL    PRTTXT		; prints TEXT at screen location HL
	POP 	B		; GET B BACK AGAIN

	MOV	A,B
	ADI	30H
	RST 4			; PRINT OUT THE TARGET MAP NUMBER B
	RET
;#######################################################################################################
GETFN:	CALL	KEYWT		; PRINT TIME AND WAIT FOR A KEY

	LDA	FNBITS		; LOAD A WITH VALUE IN FNBITS (CONTAINS VALUE THAT INDICATES FN KEY PRESSED)				
	PUSH 	B
	MOV	C,A		; STORE C AND LOAD C WITH A

	MVI	A,01H		; LOAD A WITH 1000 0000	

	MVI	B,01H
	DCR	B		; CAN'T USE A 00....

TMAPF:	CMP	C		; COMPARE A WITH C

	JZ	TMDONE		; IF A = C, THEN DONE
	
	INR	B
	RLC			; ROTATE ACCUMULATOR RIGHT

	JC	TMERR		; IF IT ROTATES TO THE POINT WHERE CARRY SET, THEN IT'S AN ERROR
	JMP	TMAPF

TMERR:	POP 	B		; IF ERROR, THEN POP C AND BEEP
	JMP	ERROR1
				
TMDONE:	MOV	A,B		
	POP	B		; B IS NOW A NUMBER 0-7
	MOV	B,A
	RET
;#######################################################################################################
	DB	00H			; LINE 6 VARIABLE STORAGE
line6:	db	00h			
	db	00h
STOR1	DB	00H
	DB	02H			; line 512+
;#######################################################################################################
	DB	00H			; LINE 7 VARIABLE STORAGE
line7:	db	00h			
	db	00h
STOR2	DB	00H
	DB	03H			; line 768+
;#######################################################################################################
MAPLOP:	LXI H,	MAPT		; LOAD DE WITH MAPT POINTER
	PUSH	B
	CALL	PRNTFF		; PRINT MAP TEXT
	POP	B
	PUSH	B
	MOV 	A, B		; LOAD A WITH B
	RST 4
	MVI A,  20H		; LOAD A WITH ' '
	RST 4

	POP 	B
	RET
;#######################################################################################################
	DB	00H			; LINE 8
line8:	db	00h			; this must point to EOF + 1
	db	00h
	DB	00H
	DB	04H			; line 1024+
;#######################################################################################################
SWDATA:	;DB	243, 62, 32, 211, 112, 199		; F3 3E 20 D3 70 C7

							; DI
							; LDA 20
							; OUT 112
							; RST 0

	; changed to fix an error due to stack management
	; nine bytes instead of 6

	DI
	MVI	A,20h
	
	LXI	SP,0FCD0H
	
	OUT	112
	RST	0




INTMSG:	DB	"INITIALIZING MA"
	DB	"P "
	DB	0FFH

JMPMSG:	DB	"JUMPING TO MAP "			; DB LINES MUST BE 16 CHARS OR LESS
	DB	0FFH

TITL1:	DB	"     "		
	DB	"Jump "		
	DB	"Init "		
	DB	"     "		
	DB	"Kill "		 
	DB	"Name "		
	DB	"Mcpy "		
	DB	"Exit "		
	DB	0FFH

MAPT:	DB	"MAP"
	DB	0FFH

KILLT:	DB	"KILL "
	DB	0FFH

AYS:	DB	" "
	DB	"Are You Sure Y/N"
	DB	20H, 0FFH

DEST:	DB	"Destination Bank"
	DB	" ? "
	DB	0FFH

RNM:	DB	"Rename "
	DB	0FFH

TO:	DB 	" To "
	DB	0FFH

;#######################################################################################################
end:	DB	00H			; LAST LINE END OF FILE
;#######################################################################################################