
NUMPRT	.EQU	39D4H		; Print binary number in HL at current position
GETTOP 	.EQU 	5AE4H		; GETS TOP ADDRESS OF FILE

TDDPT	.EQU	5A15H		; Print time ,day,date on first line w/o CLS
KEYWTU	.EQU	5D64H		; Wait for char from keyboard & convert to uppercase
MNENTR	.EQU	58F7H		; Handle ENTER key from MENU command loop
MNCMD	.EQU	58A9H 		; jump back into Handle COMMANDS from MENU command loop
REBOOT 	.EQU	7D33H		; Boot routine, RST 0 or Reset vector target - initialization.
BEEP	.EQU	4229H		; BEEP statement

BLKMV	.EQU	3469H		; Move B bytes from (DE) to M with increment
MVHBI:	.EQU	02542H		; Move B number of bytes from from M to (DE) with decrement 

MVHBCI	.equ	6BDBH		; Move from HL to DE (incrementing) for BC bytes
MVHBCD	.equ	6BE6H		; Move from HL to DE (decrementing) for BC bytes

GETTP 	.EQU 	5AE3H		; GETS TOP ADDRESS OF FILE
LINKER1 .equ	05F4H		; links a .BA file

KILDC	.EQU	1FB2H		; KILL DO CO FILE TYPE
KILB 	.EQU	2017H		; KILL BA FILE TYPE

KILD	.equ	1FBFH		; entry that kills .DO and returns properly
KILC	.equ	1FD9H		; entry that kills .CO and returns properly

UPCAS	.EQU	0FE9H		; CONVERT TO UPPER CASE

LNKFIL	.EQU	2146h		; link files in directory

ALTLCD	.EQU	0FCC0h		; altlcd buffer
ALTLCDE	.EQU	0FDFFh		; end of altlcd buffer
STDLCD	.EQU	0FE00h		; start of standard LCD
STDLCDE	.EQU	0FF3Fh		; end of standard LCD

STREND 	.EQU	0FBB6h		; End of storage/ first free byte

;ASCTAB 	.equ	0FBAEH		; Pointer to start of ASCII files
BINTAB 	.equ	0FBB0H		; Pointer to start of binary files
VARTAB 	.equ	0FBB2H		; Pointer to start of simple variable space
ARYTAB 	.equ	0FBB4H		; Pointer to start of array table



 



;-----------------------------------------------------------------------
; M100/T200 specific variables
;-----------------------------------------------------------------------

DIRLEN:		.equ	11d		; number of bytes per directory entry
NAMLEN:		.equ	8d		; number of bytes per name entry
MAKUPS:		.equ	0FE8H		; convert character to uppercase

PRBUF		.EQU	27B1h		; print at cursor from hl buffer till 00

NAMES:		.equ	7d		; number of fixed entries in directory table
TOTAL_NAMES:	.equ	27d		; total number of names in directory

ASCTAB:		.equ	0FBAEh		; points to the lowest address of .DO files
NULDIR:		.equ	0F99Ah		; points to unsaved basic program
SCRPD:		.equ	0F9A5h
INPUT_BUFFER:	.EQU	0F685H		; text input buffer
EOFFIL:		.equ	1Ah		; EOF character for .DO files
TMRHK:		.equ	0F5FFh		; M100 timer hook
ROM_ID:		.equ	0FAA4h		; M100 rom id location
ROMstart:	.equ	0F624h		; M100 location to start the optrom 
LOWRAM:		.equ	0FAC0h		; address of lowest ram location, 8000h in 32k M100
LCDPTR:		.equ	0FE52h		; 3rd row, 3rd column

SETHOK:		.equ	07EC6h		; sets up the hook table to default


HOOKT1:		.equ	0FADAh		; hook table start in RAM 
HOOKL1: 	.equ	01dh		; hook table length (pairs) (29)
HOOKD1:		.equ	07FF3h		; hook table data 

HOOKT2:		.equ	0FB14h		; hook table start in RAM 
HOOKL2: 	.equ	013h		; hook table length (pairs) (19)
HOOKD2:		.equ	008DBh		; hook table data 

RAMLD:		.equ	0F605h		; 36 byte area copied on power up
RAMLDS:		.equ	036Fh		; location in ROM for ram bytes
RAMLDL:		.equ	36d		; number of bytes to copy on power up

KYBCNT:		.equ	0FFAAh		; keyboard count
MENCNT:		.equ	0FDEEh		; current menu selection count

TIMYR1:		.equ	0F92Dh		; 2 byte location for year data

SNDCOM	.equ	6E3A

;Send a character to the RS-232 without 
;XON/XOFF flow control.  On entry, C 
;contains character to be sent.  Exit 
;conditions are unknown.

; Constants

RSTAT	.equ	0F65B
;* Text string containing the current
;RS-232 setting as follows:  BAUD,
;Length, parity, Stop Bits, XON/XOFF
;switch.

